"""
Configuration package for PurpleTube Player.
Centralizes all application settings and constants.
"""
from .settings import (
    APP_NAME,
    APP_AUTHOR,
    APP_LICENSE,
    APP_DESCRIPTION,
    APP_WEBSITE,
    APP_REPO,
    DATA_DIR,
    DB_PATH,
    LOG_PATH,
    CACHE_DIR,
    THUMBNAIL_CACHE_DIR,
    DOWNLOAD_DIR,
    API_RATE_LIMITER,
    SEPIASEARCH_BASE_URL,
    PEERTUBE_API_TIMEOUT,
    DEFAULT_SEARCH_COUNT,
    MAX_SEARCH_RESULTS,
    API_REQUEST_TIMEOUT,
    API_USER_AGENT,
    MAX_API_CALLS,
    TIME_WINDOW,
    BURST_LIMIT,
    BURST_WINDOW,
    SearchConfig,
    PlayerConfig,
    UIConfig,
    LogConfig,
    DBConfig,
    SecurityConfig,
    NetworkConfig,
    CacheConfig,
    DEFAULT_LANGUAGE,
    DEFAULT_REGION,
    DEFAULT_NSFW_FILTER,
    DEFAULT_AUTO_PLAY,
    DEFAULT_SUBTITLE_LANGUAGE,
    FeatureFlags,
    ExportImportConfig,
    SEARCH_API_ENDPOINT,
    TRENDING_API_ENDPOINT,
    CHANNEL_API_ENDPOINT,
    DEFAULT_PAGE_SIZE,
    MAX_PAGE_SIZE,
    DEFAULT_SORT,
    DEFAULT_NSFW_FILTER as NSFW_FILTER_DEFAULT,
    TIME_RANGES,
    DURATION_RANGES,
    CATEGORIES,
    LANGUAGES,
    SORT_OPTIONS,
    SEARCH_TIMEOUT,
    SEARCH_MAX_RETRIES,
    SEARCH_RETRY_DELAY,
    SEARCH_CACHE_SIZE,
    TRENDING_CACHE_SIZE,
    CHANNEL_CACHE_SIZE
)

