from PyQt5.QtWidgets import (
    QDialog, QVBoxLayout, QHBoxLayout, QLabel, QLineEdit, QComboBox,
    QPushButton, QGridLayout, QGroupBox, QSpinBox, QCheckBox
)
from config.theme import Theme

class AdvancedSearchDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle("Ricerca Avanzata")
        self.setFixedSize(750, 700)
        self.setStyleSheet(Theme.global_stylesheet())
        self._setup_ui()

    def _setup_ui(self):
        layout = QVBoxLayout(self)
        layout.setSpacing(24)
        layout.setContentsMargins(32, 32, 32, 32)

        # Intestazione
        header_layout = QVBoxLayout()
        header_layout.setSpacing(8)
        title_layout = QHBoxLayout()
        title_icon = QLabel("🔍")
        title_icon.setStyleSheet("font-size: 24px; margin-right: 12px;")
        title_label = QLabel("Ricerca Avanzata")
        title_label.setStyleSheet("font-size: 22px; font-weight: bold; color: white; margin: 0;")
        title_layout.addWidget(title_icon)
        title_layout.addWidget(title_label)
        title_layout.addStretch()
        subtitle_label = QLabel("Affina la tua ricerca con filtri specifici")
        subtitle_label.setStyleSheet("font-size: 14px; color: #AAAAAA; margin: 0;")
        header_layout.addLayout(title_layout)
        header_layout.addWidget(subtitle_label)
        layout.addLayout(header_layout)

        # Query
        query_layout = QVBoxLayout()
        query_layout.setSpacing(8)
        query_label = QLabel("Testo della Ricerca")
        self.query_input = QLineEdit()
        self.query_input.setPlaceholderText("Inserisci parole chiave, frasi o argomenti...")
        self.query_input.setClearButtonEnabled(True)
        query_layout.addWidget(query_label)
        query_layout.addWidget(self.query_input)
        layout.addLayout(query_layout)

        # Filtri
        filters_grid = QGridLayout()
        filters_grid.setHorizontalSpacing(20)
        filters_grid.setVerticalSpacing(16)

        # Lingua
        filters_grid.addWidget(QLabel("Lingua"), 0, 0)
        self.language_filter = QComboBox()
        self.language_filter.addItem("Qualsiasi Lingua", "")
        self.language_filter.addItem("Inglese", "en")
        self.language_filter.addItem("Cinese Semplificato", "zh-Hans")
        self.language_filter.addItem("Cinese Tradizionale", "zh-Hant")
        self.language_filter.addItem("Spagnolo", "es")
        self.language_filter.addItem("Francese", "fr")
        self.language_filter.addItem("Arabo", "ar")
        self.language_filter.addItem("Portoghese Brasiliano", "pt")
        self.language_filter.addItem("Portoghese", "pt-PT")
        self.language_filter.addItem("Russo", "ru")
        self.language_filter.addItem("Giapponese", "ja")
        self.language_filter.addItem("Tedesco", "de")
        self.language_filter.addItem("Turco", "tr")
        self.language_filter.addItem("Vietnamita", "vi")
        self.language_filter.addItem("Italiano", "it")
        self.language_filter.addItem("Persiano", "fa")
        self.language_filter.addItem("Polacco", "pl")
        self.language_filter.addItem("Ucraino", "uk")
        self.language_filter.addItem("Olandese", "nl")
        self.language_filter.addItem("Lao", "th")
        self.language_filter.addItem("Ungherese", "hu")
        self.language_filter.addItem("Greco", "el")
        self.language_filter.addItem("Ceco", "cs")
        self.language_filter.addItem("Svedese", "sv")
        self.language_filter.addItem("Norvegese", "no")
        self.language_filter.addItem("Finlandese", "fi")
        self.language_filter.addItem("Slovacco", "sk")
        self.language_filter.addItem("Croato", "hr")
        self.language_filter.addItem("Albanese", "sq")
        self.language_filter.addItem("Catalano", "ca")
        self.language_filter.addItem("Basco", "eu")
        self.language_filter.addItem("Gaelico Irlandese", "gd")
        self.language_filter.addItem("Islandese", "is")
        self.language_filter.addItem("Occitano", "oc")
        self.language_filter.addItem("Cabilo", "kab")
        self.language_filter.addItem("Esperanto", "eo")
        self.language_filter.addItem("Toki Pona", "tok")
        filters_grid.addWidget(self.language_filter, 0, 1)

        # Categoria
        filters_grid.addWidget(QLabel("Categoria"), 1, 0)
        self.category_filter = QComboBox()
        self.category_filter.addItem("Qualsiasi Categoria", "")
        self.category_filter.addItem("💻 Scienza e Tecnologia", "15")
        self.category_filter.addItem("🛠️ Guide e Tutorial", "12")
        self.category_filter.addItem("🎬 Film", "2")
        self.category_filter.addItem("📚 Istruzione", "13")
        self.category_filter.addItem("🍿 Intrattenimento", "10")
        self.category_filter.addItem("✊ Attivismo", "14")
        self.category_filter.addItem("🎵 Musica", "1")
        self.category_filter.addItem("🎤 Commedia", "9")
        self.category_filter.addItem("📰 Notizie e Politica", "11")
        self.category_filter.addItem("🎮 Videogiochi", "7")
        self.category_filter.addItem("⚽ Sport", "5")
        self.category_filter.addItem("🐱 Animali", "16")
        self.category_filter.addItem("🖌️ Arte", "4")
        self.category_filter.addItem("🧳 Viaggi", "6")
        self.category_filter.addItem("👥 Persone", "8")
        self.category_filter.addItem("🚗 Veicoli", "3")
        self.category_filter.addItem("🍎 Cibo", "18")
        filters_grid.addWidget(self.category_filter, 1, 1)

        # Durata
        filters_grid.addWidget(QLabel("Durata"), 2, 0)
        self.duration_filter = QComboBox()
        self.duration_filter.addItem("Qualsiasi Durata", "")
        self.duration_filter.addItem("⏱️ Breve (< 4 min)", "short")
        self.duration_filter.addItem("⏱️ Media (4-20 min)", "medium")
        self.duration_filter.addItem("⏱️ Lunga (> 20 min)", "long")
        filters_grid.addWidget(self.duration_filter, 2, 1)

        # Ordina per
        filters_grid.addWidget(QLabel("Ordina per"), 3, 0)
        self.sort_dropdown = QComboBox()
        self.sort_dropdown.addItems(["Migliore corrispondenza", "Più recenti", "Meno recenti"])
        filters_grid.addWidget(self.sort_dropdown, 3, 1)

        layout.addLayout(filters_grid)

        # Pulsanti
        button_layout = QHBoxLayout()
        button_layout.setSpacing(16)
        clear_btn = QPushButton("Pulisci Filtri")
        clear_btn.clicked.connect(self.clear_filters)
        cancel_btn = QPushButton("Annulla")
        cancel_btn.clicked.connect(self.reject)
        search_btn = QPushButton("Cerca")
        search_btn.setDefault(True)
        search_btn.clicked.connect(self.accept)
        button_layout.addWidget(clear_btn)
        button_layout.addStretch()
        button_layout.addWidget(cancel_btn)
        button_layout.addWidget(search_btn)
        layout.addLayout(button_layout)

    def clear_filters(self):
        self.query_input.clear()
        self.language_filter.setCurrentIndex(0)
        self.duration_filter.setCurrentIndex(0)
        self.category_filter.setCurrentIndex(0)
        self.sort_dropdown.setCurrentIndex(0)
        self.query_input.setFocus()

    def get_search_params(self):
        return {
            "query": self.query_input.text().strip(),
            "language": self.language_filter.currentData(),
            "duration": self.duration_filter.currentData(),
            "category": self.category_filter.currentData(),
            "sort_by": self.sort_dropdown.currentText()
        }

