#!/bin/sh

set -e

dump2dcm /dev/stdin "$AUTOPKGTEST_TMP"/dataset.dcm <<EOF
(0002,0000) UL 188                                      #   4, 1 FileMetaInformationGroupLength
(0002,0001) OB 00\01                                    #   2, 1 FileMetaInformationVersion
(0002,0002) UI =RawDataStorage                          #  26, 1 MediaStorageSOPClassUID
(0002,0003) UI [2.25.950903449422502667095875590734673] #  44, 1 MediaStorageSOPInstanceUID
(0002,0010) UI =LittleEndianExplicit                    #  20, 1 TransferSyntaxUID
(0002,0012) UI [1.2.276.0.7230010.3.0.3.6.5]            #  28, 1 ImplementationClassUID
(0002,0013) SH [OFFIS_DCMTK_365]                        #  16, 1 ImplementationVersionName
(0008,0016) UI =RawDataStorage                          #  26, 1 SOPClassUID
(0008,0018) UI [2.25.950903449422502667095875590734673] #  44, 1 SOPInstanceUID
(0010,0010) PN [Doe^John]                               #   8, 1 PatientName
(0010,0020) LO [DJ001]                                  #   6, 1 PatientID
EOF

for py in $(py3versions -vs) ; do 
    python${py} -c \
        'import sys; import odil; \
        header, data_set=odil.Reader.read_file(sys.argv[1]); \
        print("\n".join([": ".join((str(k), str(list(v)))) for k, v in data_set.items()]))' \
        "$AUTOPKGTEST_TMP"/dataset.dcm
done
