// These raw data values are converted from the original Illustrator-exported
// SVG using Snap.svg's `Snap.path.toAbsolute()` function
// http://snapsvg.io/docs/#Snap.path.toAbsolute

export interface Coords {
    x: number;
    y: number;
}

export interface Dimensions {
    width: number;
    height: number;
}

interface ViewBox extends Dimensions, Coords {}

export const waveData: {
    viewbox: ViewBox;
    layers: {
        [key: string]: {
            color: [number, number, number];
            from: string;
            to: string;
        }[];
    };
} = {
    viewbox: { x: 0, y: 0, width: 1440, height: 604 },
    layers: {
        bg: [
            {
                color: [90, 193, 204],
                from:
                    `M-103.7,142.5` +
                    `C-103.7,142.5,375.6,625,752.3,292.5` +
                    `C1124.5,-36,1268.8,95,1711.3,537.5`,
                to:
                    `M-103.7,139` +
                    `C-103.7,139,434.2,731.9,812.3,401` +
                    `C1185.9,73.9,1268.8,91.5,1711.3,534`,
            },
            {
                color: [233, 77, 113],
                from:
                    `M-43.7,352.5` +
                    `C-43.7,352.5,282.3,-80.7,631.8,158` +
                    `C975.9,393,1293.3,648.5,1711.3,284.5`,
                to:
                    `M-45.1,349` +
                    `C-45.1,349,319.7,2.7,684.9,115` +
                    `C1082.9,237.4,1057.9,775,1709.9,281`,
            },
        ],
        waves: [
            {
                color: [252, 80, 60],
                from:
                    `M-64.5,11.6` +
                    `C-64.5,11.6,36,219.1,217.3,359.5` +
                    `C312.9,433.6,430.9,489,568.5,485.4` +
                    `C728.9,481.3,902.9,387.1,1065,297.1` +
                    `C1305.6,163.5,1520,39.3,1624.6,232.6`,
                to:
                    `M-62.6,-36.5` +
                    `C-62.6,-36.5,50.3,125.6,216.4,274.7` +
                    `C360.4,403.9,544.4,523.3,729.4,518.5` +
                    `C905.4,514,1066.8,394.7,1207.2,290.8` +
                    `C1384.7,159.5,1528.7,52.8,1626.5,233.4`,
            },
            {
                color: [185, 40, 97],
                from:
                    `M-61.6,456` +
                    `C-61.6,456,88.8,-206.9,445.7,254.4` +
                    `C633,496.6,732.8,402.8,834.7,309.2` +
                    `C926.9,224.5,1020.9,139.9,1183,304.5` +
                    `C1455.2,580.7,1408,225.3,1619.6,440`,
                to:
                    `M-134.6,356.5` +
                    `C-134.6,356.5,-50.4,18.1,442.4,330.5` +
                    `C570.3,411.6,671.9,314.1,788.5,246.4` +
                    `C896.2,183.9,1016.6,146.8,1182.1,299.5` +
                    `C1467.1,562.5,1407.1,220.3,1618.7,435`,
            },
            {
                color: [252, 80, 60],
                from:
                    `M-60.5,424.6` +
                    `C-60.5,424.6,153,24,446.8,252.6` +
                    `C667.9,424.6,608.4,-21.9,867.4,278.9` +
                    `C1175.5,636.7,1120.5,62,1439.2,385.4` +
                    `C1559.9,507.9,1664.5,323.2,1664.5,323.2`,
                to:
                    `M-62.6,421.4` +
                    `C-62.6,421.4,48.5,40.3,399.4,164.5` +
                    `C560.4,221.5,563.4,107.5,721.4,253.5` +
                    `C1068.2,573.9,1109.7,-95.9,1428.4,227.5` +
                    `C1549.1,350,1662.4,320,1662.4,320`,
            },
        ],
    },
};
