"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GposTableIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const table_1 = require("../gsub-gpos-shared/table");
const contextual_read_1 = require("../lookups/contextual-read");
const contextual_write_1 = require("../lookups/contextual-write");
const gpos_cursive_1 = require("../lookups/gpos-cursive");
const gpos_mark_read_1 = require("../lookups/gpos-mark-read");
const gpos_mark_write_1 = require("../lookups/gpos-mark-write");
const gpos_pair_read_1 = require("../lookups/gpos-pair-read");
const gpos_pair_write_1 = require("../lookups/gpos-pair-write");
const gpos_single_1 = require("../lookups/gpos-single");
const gpos = {
    extendedFormat: 9,
    isExtendedFormat: x => x === 9,
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    createReader(x) {
        switch (x) {
            case 1:
                return new gpos_single_1.GposSingleReader();
            case 2:
                return new gpos_pair_read_1.GposPairReader();
            case 3:
                return new gpos_cursive_1.GposCursiveReader();
            case 4:
                return new gpos_mark_read_1.GposMarkToBaseReader();
            case 5:
                return new gpos_mark_read_1.GposMarkToLigatureReader();
            case 6:
                return new gpos_mark_read_1.GposMarkToMarkReader();
            case 7:
                return new contextual_read_1.GposContextualReader();
            case 8:
                return new contextual_read_1.GposChainingReader();
            default:
                throw errors_1.Errors.FormatNotSupported(`GSUB lookup`, x);
        }
    },
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    *writers() {
        yield new gpos_single_1.GposSingleWriter();
        yield new gpos_pair_write_1.GposPairWriter();
        yield new gpos_cursive_1.GposCursiveWriter();
        yield new gpos_mark_write_1.GposMarkToBaseWriter();
        yield new gpos_mark_write_1.GposMarkToLigatureWriter();
        yield new gpos_mark_write_1.GposMarkToMarkWriter();
        yield new contextual_write_1.GposChainingContextualWriter();
    },
    queryDependencies(lookup) {
        if (lookup.type !== ot_layout_1.Gpos.LookupType.Chaining)
            return [];
        const sink = [];
        for (const rule of lookup.rules)
            for (const app of rule.applications)
                sink.push(app.apply);
        return sink;
    }
};
exports.GposTableIo = {
    read(view, cfg, trc) {
        const o = view.next(new table_1.CGsubGposTable(), cfg, gpos, trc);
        return new ot_layout_1.Gpos.Table(o.scripts, o.features, o.lookups, o.featureVariations);
    },
    write(frag, table, cfg, twc) {
        return frag.push(new table_1.CGsubGposTable(), table, cfg, gpos, twc);
    }
};
//# sourceMappingURL=index.js.map