#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""add-quota-related-tables

Revision ID: d6f033d8fa5b
Revises: f50980397351
Create Date: 2018-04-28 03:07:06.857245

"""

# revision identifiers, used by Alembic.
revision = 'd6f033d8fa5b'
down_revision = 'f50980397351'

from alembic import op
import sqlalchemy as sa


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'quota_usages',
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.String(length=255), nullable=True),
        sa.Column('user_id', sa.String(length=255), nullable=True),
        sa.Column('resource', sa.String(length=255), nullable=False),
        sa.Column('in_use', sa.Integer(), nullable=False),
        sa.Column('reserved', sa.Integer(), nullable=False),
        sa.Column('until_refresh', sa.Integer(), nullable=True),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index('ix_quota_usages_project_id', 'quota_usages',
                    ['project_id'], unique=False)
    op.create_index('ix_quota_usages_user_id', 'quota_usages', ['user_id'],
                    unique=False)

    op.create_table(
        'reservations',
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('uuid', sa.String(length=36), nullable=False),
        sa.Column('usage_id', sa.Integer(), nullable=False),
        sa.Column('project_id', sa.String(length=255), nullable=True),
        sa.Column('user_id', sa.String(length=255), nullable=True),
        sa.Column('resource', sa.String(length=255), nullable=True),
        sa.Column('delta', sa.Integer(), nullable=False),
        sa.Column('expire', sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(['usage_id'], ['quota_usages.id'], ),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_index('ix_reservations_project_id', 'reservations',
                    ['project_id'], unique=False)
    op.create_index('ix_reservations_user_id', 'reservations', ['user_id'],
                    unique=False)
    op.create_index('reservations_uuid_idx', 'reservations', ['uuid'],
                    unique=False)
    # ### end Alembic commands ###
