/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H_
#define _SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H_

#include <stdint.h>

#define AOSS_CC_BASE			0x0C2A0000
#define QSPI_BASE			0x088DC000
#define TLMM_TILE_BASE			0x0F100000
#define GCC_BASE			0x00100000
#define NCC0_BASE			0x19A30000

/* X1P42100 NCC0 PLL CONFIG ADDRESSES */
#define NCC0_NCC_CMU_NCC_PLL_CFG	0x199A2010
#define NCC0_NCC_CMU_NCC_CLK_CFG	0x199A2030

/* CPUCP */
#define APSS_HM_BASE						0x17000000
#define APSS_CPUCP_LPM_BFSM_REG_BASE				(APSS_HM_BASE + 0x019d0000)
#define HWIO_APSS_CPUCP_CPUCP_LPM_SEQ_WAIT_EVT_CTRL_MASK_ADDR	(APSS_CPUCP_LPM_BFSM_REG_BASE + 0x161c)
#define HWIO_APSS_CPUCP_CPUCP_SW_WAKEUP_REQ_ADDR		(APSS_CPUCP_LPM_BFSM_REG_BASE + 0x1688)

/* X1P42100 QSPI GPIO PINS */
#define QSPI_CS				GPIO(132)
#define QSPI_DATA_0			GPIO(128)
#define QSPI_DATA_1			GPIO(129)
#define QSPI_CLK			GPIO(127)

#define GPIO_FUNC_QSPI_DATA_0		GPIO128_FUNC_QSPI0_DATA_0
#define GPIO_FUNC_QSPI_DATA_1		GPIO129_FUNC_QSPI0_DATA_1
#define GPIO_FUNC_QSPI_CLK		GPIO127_FUNC_QSPI0_CLK

/* QUP SERIAL ENGINE BASE ADDRESSES */
/* QUPV3_0 */
#define QUP_SERIAL0_BASE		0x00B80000
#define QUP_SERIAL1_BASE		0x00B84000
#define QUP_SERIAL2_BASE		0x00B88000
#define QUP_SERIAL3_BASE		0x00B8C000
#define QUP_SERIAL4_BASE		0x00B90000
#define QUP_SERIAL5_BASE		0x00B94000
#define QUP_SERIAL6_BASE		0x00B98000
#define QUP_SERIAL7_BASE		0x00B9C000
#define QUP_WRAP0_BASE			0x00BC0000
#define QUP_0_GSI_BASE			0x00B04000

/* QUPV3_1 */
#define QUP_SERIAL8_BASE		0x00A80000
#define QUP_SERIAL9_BASE		0x00A84000
#define QUP_SERIAL10_BASE		0x00A88000
#define QUP_SERIAL11_BASE		0x00A8C000
#define QUP_SERIAL12_BASE		0x00A90000
#define QUP_SERIAL13_BASE		0x00A94000
#define QUP_SERIAL14_BASE		0x00A98000
#define QUP_SERIAL15_BASE		0x00A9C000
#define QUP_WRAP1_BASE			0x00AC0000
#define QUP_1_GSI_BASE			0x00A04000

/* QUPV3_2 */
#define QUP_SERIAL16_BASE		0x00880000
#define QUP_SERIAL17_BASE		0x00884000
#define QUP_SERIAL18_BASE		0x00888000
#define QUP_SERIAL19_BASE		0x0088C000
#define QUP_SERIAL20_BASE		0x00890000
#define QUP_SERIAL21_BASE		0x00894000
#define QUP_SERIAL22_BASE		0x00898000
#define QUP_SERIAL23_BASE		0x0089C000
#define QUP_WRAP2_BASE			0x008C0000
#define QUP_2_GSI_BASE			0x00804000

/* USB BASE ADDRESSES */
#define HS_USB_MP0_PHY_BASE		0x088e1000
#define HS_USB_MP1_PHY_BASE		0x088E2000
#define QMP_PHY_MP0_QSERDES_COM_REG_BASE	0x088E3000
#define QMP_PHY_MP0_QSERDES_TX_REG_BASE		0x088E3E00
#define QMP_PHY_MP0_QSERDES_RX_REG_BASE		0x088E4000
#define QMP_PHY_MP0_PCS_REG_BASE			0x088E3200
#define QMP_PHY_MP0_PCS_USB3_REG_BASE		0x088E4200
#define USB_HOST_DWC3_BASE					0x0a40c100

#define QMP_PHY_MP1_QSERDES_COM_REG_BASE	0x088E5000
#define QMP_PHY_MP1_QSERDES_TX_REG_BASE		0x088E5E00
#define QMP_PHY_MP1_QSERDES_RX_REG_BASE		0x088E6000
#define QMP_PHY_MP1_PCS_REG_BASE			0x088E5200
#define QMP_PHY_MP1_PCS_USB3_REG_BASE		0x088E6200

/* PCIE 6A */
#define PCIE6A_PCIE_PARF		0x01BF8000
#define PCIE6A_GEN1X4_PCIE_DBI		0x70000000
#define PCIE6A_GEN1X4_PCIE_ELBI		0x70000F40
#define PCIE6A_GEN1X4_DWC_PCIE_DM_IATU	0x70001000
#define PCIE6A_SPACE_END_ADDR		0x74000000
#define PCIE6A_BCR			0x131000
#define GCC_PCIE_6A_PHY_BCR		0x1AC01C

/* QMP PHY, Serdes,Tx, Rx and PCS register definitions */
#define PCIE_6A_AQMP_PHY		0x01BFC000
#define PCIE_6A_BQMP_PHY		0x01BFE000

#define PCIE6A_AQPHY_TX0		0x01BFC000
#define PCIE6A_AQPHY_RX0		0x01BFC200
#define PCIE6A_AQPHY_TX1		0x01BFC800
#define PCIE6A_AQPHY_RX1		0x01BFCA00
#define PCIE6A_AQPHY_LN_SHRD		0x01BFCE00
#define PCIE6A_AQPHY_SERDES		0x01BFD000
#define PCIE6A_AQPHY_PCS_COM		0x01BFD200
#define PCIE6A_AQPHY_PCS_PCIE		0x01BFD400
#define PCIE6A_AQPHY_PCS_LANE0		0x01BFD800
#define PCIE6A_AQPHY_PCS_PCIE_LANE0	0x01BFDA00
#define PCIE6A_AQPHY_PCS_LANE1		0x01BFDC00
#define PCIE6A_AQPHY_PCS_PCIE_LANE1	0x01BFDE00

#define PCIE6A_BQPHY_TX0		0x01BFE000
#define PCIE6A_BQPHY_RX0		0x01BFE200
#define PCIE6A_BQPHY_TX1		0x01BFE800
#define PCIE6A_BQPHY_RX1		0x01BFEA00
#define PCIE6A_BQPHY_LN_SHRD		0x01BFEE00
#define PCIE6A_BQPHY_SERDES		0x01BFF000
#define PCIE6A_BQPHY_PCS_COM		0x01BFF200
#define PCIE6A_BQPHY_PCS_PCIE		0x01BFF400
#define PCIE6A_BQPHY_PCS_LANE0		0x01BFF800
#define PCIE6A_BQPHY_PCS_PCIE_LANE0	0x01BFFA00
#define PCIE6A_BQPHY_PCS_LANE1		0x01BFFC00
#define PCIE6A_BQPHY_PCS_PCIE_LANE1	0x01BFFE00

/* TCSR */
#define TCSR_GCC_PCIE_4L_CLKREF_EN_PCIE_ENABLE	((void *)0x1FD512C)
#define TCSR_PCIE_CTRL_4LN_CONFIG_SEL	((void *)0x1FDA000)

#define TCSR_GCC_CXO_1_REFGEN_BIAS_SEL__SEL_REFGEN_ADDR		((void *)0x1FD511C)
#define TCSR_GCC_CXO_0_REFGEN_BIAS_SEL__SEL_REFGEN_ADDR		((void *)0x1FD5134)

#define TCSR_QREFS_CXO_0_RPT3_CONFIG_ADDR			((void *)0x1FD5014)
#define TCSR_QREFS_CXO_0_RPT4_CONFIG_ADDR			((void *)0x1FD5018)
#define TCSR_QREFS_CXO_1_RPT0_CONFIG_ADDR			((void *)0x1FD5000)
#define TCSR_QREFS_CXO_1_RX3_CONFIG_ADDR			((void *)0x1FD502C)
#define TCSR_QREFS_CXO_1_RX0_CONFIG_ADDR			((void *)0x1FD5020)
#define TCSR_QREFS_CXO_0_RX3_CONFIG_ADDR			((void *)0x1FD5030)
#define TCSR_QREFS_CXO_0_RX4_CONFIG_ADDR			((void *)0x1FD5034)

#define TCSR_GCC_USB3_MP0_CLKREF_EN_ADDR	((void *)0x1FD510C)
#define TCSR_GCC_USB3_MP1_CLKREF_EN_ADDR	((void *)0x1FD5110)
#define USB3_CLKREF_ENABLE_VALUE			0x1

/* SPMI PMIC ARB */
#define SPMI_PMIC_ARB_CORE_BASE		0x0C400000
#define FIRST_APID_MAP_OFFSET		0x2000
#define LAST_APID_MAP_OFFSET		0x3000
#define SPMI_PMIC_ARB_APID_COUNT	((LAST_APID_MAP_OFFSET - FIRST_APID_MAP_OFFSET) / 4)
#define SPMI_PMIC_ARB_APID_MAP_BASE	(SPMI_PMIC_ARB_CORE_BASE + FIRST_APID_MAP_OFFSET)
#define SPMI_PMIC_ARB_CHANNEL_BASE	0x0C500000
#define SPMI_PMIC_ARB_CHANNEL_SIZE	0x1000

#endif /*  __SOC_QUALCOMM_X1P42100_ADDRESS_MAP_H__ */
