#!/bin/sh
# Run this to generate all the initial makefiles, etc.

set -e

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

PKG_NAME="Update Notifier"

(test -f $srcdir/configure.ac \
  && test -f $srcdir/README) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level gnome directory"
    exit 1
}

dpkg-checkbuilddeps -d 'libtool, automake, intltool, libglib2.0-dev'

cd "$srcdir"
autoreconf --force -i -v    
intltoolize -c
aclocal
rm -rf autom4te.cache
cd po; intltool-update -p --verbose
