/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright (C) 2017-2018 Intel Corporation <www.intel.com>
 *
 */

#ifndef	_SDRAM_S10_H_
#define	_SDRAM_S10_H_

#define DDR_TWR				15
#define DDR_READ_LATENCY_DELAY		40
#define DDR_ACTIVATE_FAWBANK		0x1

/* NOC DDR scheduler */
#define DDR_SCH_ID_COREID		0
#define DDR_SCH_ID_REVID		0x4
#define DDR_SCH_DDRCONF			0x8
#define DDR_SCH_DDRTIMING		0xc
#define DDR_SCH_DDRMODE			0x10
#define DDR_SCH_READ_LATENCY		0x14
#define DDR_SCH_ACTIVATE		0x38
#define DDR_SCH_DEVTODEV		0x3c
#define DDR_SCH_DDR4TIMING		0x40

#define DDR_SCH_DDRTIMING_ACTTOACT_OFF		0
#define DDR_SCH_DDRTIMING_RDTOMISS_OFF		6
#define DDR_SCH_DDRTIMING_WRTOMISS_OFF		12
#define DDR_SCH_DDRTIMING_BURSTLEN_OFF		18
#define DDR_SCH_DDRTIMING_RDTOWR_OFF		21
#define DDR_SCH_DDRTIMING_WRTORD_OFF		26
#define DDR_SCH_DDRTIMING_BWRATIO_OFF		31
#define DDR_SCH_DDRMOD_BWRATIOEXTENDED_OFF	1
#define DDR_SCH_ACTIVATE_RRD_OFF		0
#define DDR_SCH_ACTIVATE_FAW_OFF		4
#define DDR_SCH_ACTIVATE_FAWBANK_OFF		10
#define DDR_SCH_DEVTODEV_BUSRDTORD_OFF		0
#define DDR_SCH_DEVTODEV_BUSRDTOWR_OFF		2
#define DDR_SCH_DEVTODEV_BUSWRTORD_OFF		4

#include "sdram_soc64.h"

#endif /* _SDRAM_S10_H_ */
