---
myst:
  html_meta:
    keywords: LaTeX, programmation, extensions, classes, exemple complet minimal, 
              déboguer du code LaTeX, simplifier son exemple
---

# Que fait la classe <ctanpkg:minimal> ?

Cette classe a servi de test dans les années 1990, lors du développement de LaTeXe, 
et reste dans les distributions LaTeX pour des raisons historiques, 
mais elle n'a plus d'usage réel. Elle ne définit même pas les commandes 
pour les différentes tailles de caractère, ni `\parindent`, par exemple. 
En l'utilisant, vous ne vous mettez pas dans les conditions d'un document réel. 
Son code est présenté en réponse à la question 
"[](/2_programmation/erreurs/t/the_font_size_command_normalsize_is_not_defined)".

De fait, dans la vie de tous les jours, cette classe ne doit **pas** être utilisée, 
même pour composer un 
"[exemple complet minimal](/1_generalites/documentation/listes_de_discussion/comment_rediger_un_exemple_complet_minimal)".


## Une meilleur candidate : <ctanpkg:standalone>

Si vous souhaitez produire un document qui ait juste la taille de son contenu 
(donc "minimal" au sens de "sans marges, sans numéro de page, sans titre..."), 
vous pouvez utiliser la classe <ctanpkg:standalone>, de Martin Scharrer :

```
\documentclass{standalone} 
  \pagestyle{empty}      % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
\begin{tikzpicture}
  \fill[orange] circle (3ex) ;
  \draw (-3ex,-3ex) rectangle (3ex,3ex) ;
\end{tikzpicture}
\end{document}
```

Cette classe, basée sur la classe <ctanpkg:article>, est spécialement conçue 
pour créer des documents dont le résultat peut-être inclus dans un autre document 
avec un `\includegraphics` (de l'extension <ctanpkg:graphicx>). 
La question "[](/3_composition/illustrations/images/inclure_une_image)" 
illustre ce sujet.

Elle propose de nombreuses options pour ajuster son comportement, 
détaillées dans sa [documentation](texdoc:standalone) (en anglais).

:::{sources}
- [Why should the minimal class be avoided?](https://tex.stackexchange.com/q/42114), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [What is the advantage of using minimal over article when creating a standalone graphic?](https://tex.stackexchange.com/q/20974), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::