# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
import datetime
import json
from typing import Any, Callable, Iterator, Optional, TypeVar
import urllib.parse

from azure.core import MatchConditions, PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import BatchClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC, prep_if_match, prep_if_none_match

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_batch_list_applications_request(
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/applications"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_application_request(
    application_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/applications/{applicationId}"
    path_format_arguments = {
        "applicationId": _SERIALIZER.url("application_id", application_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pool_usage_metrics_request(  # pylint: disable=name-too-long
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    starttime: Optional[datetime.datetime] = None,
    endtime: Optional[datetime.datetime] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/poolusagemetrics"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if starttime is not None:
        _params["startTime"] = _SERIALIZER.query("starttime", starttime, "iso-8601")
    if endtime is not None:
        _params["endtime"] = _SERIALIZER.query("endtime", endtime, "iso-8601")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_pool_request(
    *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pools_request(
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_pool_internal_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_pool_exists_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_pool_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_pool_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/disableautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/enableautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_evaluate_pool_auto_scale_request(  # pylint: disable=name-too-long
    pool_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/evaluateautoscale"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_resize_pool_internal_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/resize"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_stop_pool_resize_internal_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/stopresize"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_pool_properties_request(  # pylint: disable=name-too-long
    pool_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/updateproperties"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_remove_nodes_internal_request(  # pylint: disable=name-too-long
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/removenodes"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_supported_images_request(  # pylint: disable=name-too-long
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/supportedimages"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_pool_node_counts_request(  # pylint: disable=name-too-long
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/nodecounts"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_job_internal_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    force: Optional[bool] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if force is not None:
        _params["force"] = _SERIALIZER.query("force", force, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_job_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_job_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_job_internal_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/disable"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_job_internal_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/enable"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_job_internal_request(  # pylint: disable=name-too-long
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    force: Optional[bool] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/terminate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if force is not None:
        _params["force"] = _SERIALIZER.query("force", force, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_job_request(
    *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_jobs_request(
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_jobs_from_schedule_request(  # pylint: disable=name-too-long
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/jobs"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_job_preparation_and_release_task_status_request(  # pylint: disable=name-too-long
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/jobpreparationandreleasetaskstatus"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_task_counts_request(
    job_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/taskcounts"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_job_schedule_exists_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_job_schedule_internal_request(  # pylint: disable=name-too-long
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    force: Optional[bool] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if force is not None:
        _params["force"] = _SERIALIZER.query("force", force, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_job_schedule_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_update_job_schedule_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_job_schedule_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_job_schedule_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/disable"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_job_schedule_request(
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/enable"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_job_schedule_internal_request(  # pylint: disable=name-too-long
    job_schedule_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    force: Optional[bool] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules/{jobScheduleId}/terminate"
    path_format_arguments = {
        "jobScheduleId": _SERIALIZER.url("job_schedule_id", job_schedule_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if force is not None:
        _params["force"] = _SERIALIZER.query("force", force, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_job_schedule_request(
    *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobschedules"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_job_schedules_request(
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobschedules"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_task_request(
    job_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_tasks_request(
    job_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_task_collection_request(  # pylint: disable=name-too-long
    job_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/addtaskcollection"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_task_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    expand: Optional[list[str]] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")
    if expand is not None:
        _params["$expand"] = _SERIALIZER.query("expand", expand, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_task_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_sub_tasks_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/subtasksinfo"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_terminate_task_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/terminate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_reactivate_task_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    etag: Optional[str] = None,
    match_condition: Optional[MatchConditions] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/reactivate"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if_match = prep_if_match(etag, match_condition)
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if_none_match = prep_if_none_match(etag, match_condition)
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_task_file_request(
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_file_request(
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    ocp_range: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if ocp_range is not None:
        _headers["ocp-range"] = _SERIALIZER.header("ocp_range", ocp_range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_task_file_properties_internal_request(  # pylint: disable=name-too-long
    job_id: str,
    task_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files/{filePath}"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_task_files_request(
    job_id: str,
    task_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/jobs/{jobId}/tasks/{taskId}/files"
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, "str"),
        "taskId": _SERIALIZER.url("task_id", task_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_create_node_user_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_node_user_request(
    pool_id: str,
    node_id: str,
    user_name: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users/{userName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "userName": _SERIALIZER.url("user_name", user_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_replace_node_user_request(
    pool_id: str,
    node_id: str,
    user_name: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/users/{userName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "userName": _SERIALIZER.url("user_name", user_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_reboot_node_internal_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/reboot"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_start_node_internal_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/start"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_reimage_node_internal_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/reimage"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_deallocate_node_internal_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/deallocate"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_disable_node_scheduling_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/disablescheduling"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_enable_node_scheduling_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/enablescheduling"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_remote_login_settings_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/remoteloginsettings"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_upload_node_logs_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_nodes_request(
    pool_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_extension_request(
    pool_id: str,
    node_id: str,
    extension_name: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/extensions/{extensionName}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "extensionName": _SERIALIZER.url("extension_name", extension_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_node_extensions_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    select: Optional[list[str]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/extensions"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "[str]", div=",")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_delete_node_file_request(
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_file_request(
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    ocp_range: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")
    if ocp_range is not None:
        _headers["ocp-range"] = _SERIALIZER.header("ocp_range", ocp_range, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_get_node_file_properties_internal_request(  # pylint: disable=name-too-long
    pool_id: str,
    node_id: str,
    file_path: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    if_modified_since: Optional[datetime.datetime] = None,
    if_unmodified_since: Optional[datetime.datetime] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files/{filePath}"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
        "filePath": _SERIALIZER.url("file_path", file_path, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    if if_modified_since is not None:
        _headers["If-Modified-Since"] = _SERIALIZER.header("if_modified_since", if_modified_since, "rfc-1123")
    if if_unmodified_since is not None:
        _headers["If-Unmodified-Since"] = _SERIALIZER.header("if_unmodified_since", if_unmodified_since, "rfc-1123")

    return HttpRequest(method="HEAD", url=_url, params=_params, headers=_headers, **kwargs)


def build_batch_list_node_files_request(
    pool_id: str,
    node_id: str,
    *,
    timeout: Optional[int] = None,
    ocpdate: Optional[datetime.datetime] = None,
    max_results: Optional[int] = None,
    filter: Optional[str] = None,
    recursive: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-06-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/pools/{poolId}/nodes/{nodeId}/files"
    path_format_arguments = {
        "poolId": _SERIALIZER.url("pool_id", pool_id, "str"),
        "nodeId": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if timeout is not None:
        _params["timeOut"] = _SERIALIZER.query("timeout", timeout, "int")
    if max_results is not None:
        _params["maxresults"] = _SERIALIZER.query("max_results", max_results, "int")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if recursive is not None:
        _params["recursive"] = _SERIALIZER.query("recursive", recursive, "bool")

    # Construct headers
    if ocpdate is not None:
        _headers["ocp-date"] = _SERIALIZER.header("ocpdate", ocpdate, "rfc-1123")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class _BatchClientOperationsMixin(  # pylint: disable=too-many-public-methods
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], BatchClientConfiguration]
):

    @distributed_trace
    def list_applications(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchApplication"]:
        """Lists all of the applications available in the specified Account.

        This operation returns only Applications and versions that are available for
        use on Compute Nodes; that is, that can be used in an Package reference. For
        administrator information about applications and versions that are not yet
        available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        API.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :return: An iterator like instance of BatchApplication
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchApplication]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchApplication]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_applications_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchApplication], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_application(
        self,
        application_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.BatchApplication:
        """Gets information about the specified Application.

        This operation returns only Applications and versions that are available for
        use on Compute Nodes; that is, that can be used in an Package reference. For
        administrator information about Applications and versions that are not yet
        available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        API.

        :param application_id: The ID of the Application. Required.
        :type application_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: BatchApplication. The BatchApplication is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchApplication
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchApplication] = kwargs.pop("cls", None)

        _request = build_batch_get_application_request(
            application_id=application_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchApplication, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_pool_usage_metrics(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        starttime: Optional[datetime.datetime] = None,
        endtime: Optional[datetime.datetime] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchPoolUsageMetrics"]:
        """Lists the usage metrics, aggregated by Pool across individual time intervals,
        for the specified Account.

        If you do not specify a $filter clause including a poolId, the response
        includes all Pools that existed in the Account in the time range of the
        returned aggregation intervals. If you do not specify a $filter clause
        including a startTime or endTime these filters default to the start and end
        times of the last aggregation interval currently available; that is, only the
        last aggregation interval is returned.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword starttime: The earliest time from which to include metrics. This must be at least two
         and
         a half hours before the current time. If not specified this defaults to the
         start time of the last aggregation interval currently available. Default value is None.
        :paramtype starttime: ~datetime.datetime
        :keyword endtime: The latest time from which to include metrics. This must be at least two
         hours
         before the current time. If not specified this defaults to the end time of the
         last aggregation interval currently available. Default value is None.
        :paramtype endtime: ~datetime.datetime
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics>`_.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchPoolUsageMetrics
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPoolUsageMetrics]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchPoolUsageMetrics]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pool_usage_metrics_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    starttime=starttime,
                    endtime=endtime,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchPoolUsageMetrics], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def create_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool: _models.BatchPoolCreateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Creates a Pool to the specified Account.

        When naming Pools, avoid including sensitive information such as user names or
        secret project names. This information may appear in telemetry logs accessible
        to Microsoft Support engineers.

        :param pool: The Pool to be created. Required.
        :type pool: ~azure.batch.models.BatchPoolCreateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_pool_request(
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_pools(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchPool"]:
        """Lists all of the Pools in the specified Account.

        Lists all of the Pools in the specified Account.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-pools
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-pools>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchPool
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPool]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchPool]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pools_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchPool], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def _delete_pool_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Pool from the specified Account.

        When you request that a Pool be deleted, the following actions occur: the Pool
        state is set to deleting; any ongoing resize operation on the Pool are stopped;
        the Batch service starts resizing the Pool to zero Compute Nodes; any Tasks
        running on existing Compute Nodes are terminated and requeued (as if a resize
        Pool operation had been requested with the default requeue option); finally,
        the Pool is removed from the system. Because running Tasks are requeued, the
        user can rerun these Tasks by updating their Job to target a different Pool.
        The Tasks can then run on the new Pool. If you want to override the requeue
        behavior, then you should call resize Pool explicitly to shrink the Pool to
        zero size before deleting the Pool. If you call an Update, Patch or Delete API
        on a Pool in the deleting state, it will fail with HTTP status code 409 with
        error code PoolBeingDeleted.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_pool_internal_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def pool_exists(
        self,
        pool_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Gets basic properties of a Pool.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_pool_exists_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
            response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
            response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def get_pool(
        self,
        pool_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchPool:
        """Gets information about the specified Pool.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchPool. The BatchPool is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchPool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchPool] = kwargs.pop("cls", None)

        _request = build_batch_get_pool_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchPool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def update_pool(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        pool: _models.BatchPoolUpdateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Pool.

        This only replaces the Pool properties specified in the request. For example,
        if the Pool has a StartTask associated with it, and a request does not specify
        a StartTask element, then the Pool keeps the existing StartTask.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param pool: The pool properties to update. Required.
        :type pool: ~azure.batch.models.BatchPoolUpdateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_update_pool_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def disable_pool_auto_scale(  # pylint: disable=inconsistent-return-statements
        self, pool_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """Disables automatic scaling for a Pool.

        Disables automatic scaling for a Pool.

        :param pool_id: The ID of the Pool on which to disable automatic scaling. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_disable_pool_auto_scale_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def enable_pool_auto_scale(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        enable_auto_scale_options: _models.BatchPoolEnableAutoScaleOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Enables automatic scaling for a Pool.

        You cannot enable automatic scaling on a Pool if a resize operation is in
        progress on the Pool. If automatic scaling of the Pool is currently disabled,
        you must specify a valid autoscale formula as part of the request. If automatic
        scaling of the Pool is already enabled, you may specify a new autoscale formula
        and/or a new evaluation interval. You cannot call this API for the same Pool
        more than once every 30 seconds.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param enable_auto_scale_options: The options to use for enabling automatic scaling. Required.
        :type enable_auto_scale_options: ~azure.batch.models.BatchPoolEnableAutoScaleOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(enable_auto_scale_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_enable_pool_auto_scale_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def evaluate_pool_auto_scale(
        self,
        pool_id: str,
        evaluate_auto_scale_options: _models.BatchPoolEvaluateAutoScaleOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.AutoScaleRun:
        """Gets the result of evaluating an automatic scaling formula on the Pool.

        This API is primarily for validating an autoscale formula, as it simply returns
        the result without applying the formula to the Pool. The Pool must have auto
        scaling enabled in order to evaluate a formula.

        :param pool_id: The ID of the Pool on which to evaluate the automatic scaling formula.
         Required.
        :type pool_id: str
        :param evaluate_auto_scale_options: The options to use for evaluating the automatic scaling
         formula. Required.
        :type evaluate_auto_scale_options: ~azure.batch.models.BatchPoolEvaluateAutoScaleOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: AutoScaleRun. The AutoScaleRun is compatible with MutableMapping
        :rtype: ~azure.batch.models.AutoScaleRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[_models.AutoScaleRun] = kwargs.pop("cls", None)

        _content = json.dumps(evaluate_auto_scale_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_evaluate_pool_auto_scale_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AutoScaleRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _resize_pool_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        resize_options: _models.BatchPoolResizeOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Changes the number of Compute Nodes that are assigned to a Pool.

        You can only resize a Pool when its allocation state is steady. If the Pool is
        already resizing, the request fails with status code 409. When you resize a
        Pool, the Pool's allocation state changes from steady to resizing. You cannot
        resize Pools which are configured for automatic scaling. If you try to do this,
        the Batch service returns an error 409. If you resize a Pool downwards, the
        Batch service chooses which Compute Nodes to remove. To remove specific Compute
        Nodes, use the Pool remove Compute Nodes API instead.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param resize_options: The options to use for resizing the pool. Required.
        :type resize_options: ~azure.batch.models.BatchPoolResizeOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(resize_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_resize_pool_internal_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _stop_pool_resize_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Stops an ongoing resize operation on the Pool.

        This does not restore the Pool to its previous state before the resize
        operation: it only stops any further changes being made, and the Pool maintains
        its current state. After stopping, the Pool stabilizes at the number of Compute
        Nodes it was at when the stop operation was done. During the stop operation,
        the Pool allocation state changes first to stopping and then to steady. A
        resize operation need not be an explicit resize Pool request; this API can also
        be used to halt the initial sizing of the Pool when it is created.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_stop_pool_resize_internal_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_pool_properties(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        pool: _models.BatchPoolReplaceOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Pool.

        This fully replaces all the updatable properties of the Pool. For example, if
        the Pool has a StartTask associated with it and if StartTask is not specified
        with this request, then the Batch service will remove the existing StartTask.

        :param pool_id: The ID of the Pool to update. Required.
        :type pool_id: str
        :param pool: The options to use for replacing properties on the pool. Required.
        :type pool: ~azure.batch.models.BatchPoolReplaceOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(pool, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_pool_properties_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _remove_nodes_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        remove_options: _models.BatchNodeRemoveOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Removes Compute Nodes from the specified Pool.

        This operation can only run when the allocation state of the Pool is steady.
        When this operation runs, the allocation state changes from steady to resizing.
        Each request may remove up to 100 nodes.

        :param pool_id: The ID of the Pool to get. Required.
        :type pool_id: str
        :param remove_options: The options to use for removing the node. Required.
        :type remove_options: ~azure.batch.models.BatchNodeRemoveOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(remove_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_remove_nodes_internal_request(
            pool_id=pool_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_supported_images(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchSupportedImage"]:
        """Lists all Virtual Machine Images supported by the Azure Batch service.

        Lists all Virtual Machine Images supported by the Azure Batch service.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-support-images
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-support-images>`_.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchSupportedImage
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchSupportedImage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchSupportedImage]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_supported_images_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchSupportedImage], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_pool_node_counts(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchPoolNodeCounts"]:
        """Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        numbers returned may not always be up to date. If you need exact node counts,
        use a list query.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-support-images
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-support-images>`_.
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of BatchPoolNodeCounts
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchPoolNodeCounts]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchPoolNodeCounts]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_pool_node_counts_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchPoolNodeCounts], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def _delete_job_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        force: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Job.

        Deleting a Job also deletes all Tasks that are part of that Job, and all Job
        statistics. This also overrides the retention period for Task data; that is, if
        the Job contains Tasks which are still retained on Compute Nodes, the Batch
        services deletes those Tasks' working directories and all their contents.  When
        a Delete Job request is received, the Batch service sets the Job to the
        deleting state. All update operations on a Job that is in deleting state will
        fail with status code 409 (Conflict), with additional information indicating
        that the Job is being deleted.

        :param job_id: The ID of the Job to delete. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword force: If true, the server will delete the Job even if the corresponding nodes have
         not fully processed the deletion. The default value is false. Default value is None.
        :paramtype force: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_job_internal_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            force=force,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_job(
        self,
        job_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchJob:
        """Gets information about the specified Job.

        Gets information about the specified Job.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchJob. The BatchJob is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchJob] = kwargs.pop("cls", None)

        _request = build_batch_get_job_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchJob, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def update_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        job: _models.BatchJobUpdateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Job.

        This replaces only the Job properties specified in the request. For example, if
        the Job has constraints, and a request does not specify the constraints
        element, then the Job keeps the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update. Required.
        :type job_id: str
        :param job: The options to use for updating the Job. Required.
        :type job: ~azure.batch.models.BatchJobUpdateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_update_job_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_job(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        job: _models.BatchJob,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Job.

        This fully replaces all the updatable properties of the Job. For example, if
        the Job has constraints associated with it and if constraints is not specified
        with this request, then the Batch service will remove the existing constraints.

        :param job_id: The ID of the Job whose properties you want to update. Required.
        :type job_id: str
        :param job: A job with updated properties. Required.
        :type job: ~azure.batch.models.BatchJob
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_job_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _disable_job_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        disable_options: _models.BatchJobDisableOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Disables the specified Job, preventing new Tasks from running.

        The Batch Service immediately moves the Job to the disabling state. Batch then
        uses the disableTasks parameter to determine what to do with the currently
        running Tasks of the Job. The Job remains in the disabling state until the
        disable operation is completed and all Tasks have been dealt with according to
        the disableTasks option; the Job then moves to the disabled state. No new Tasks
        are started under the Job until it moves back to active state. If you try to
        disable a Job that is in any state other than active, disabling, or disabled,
        the request fails with status code 409.

        :param job_id: The ID of the Job to disable. Required.
        :type job_id: str
        :param disable_options: The options to use for disabling the Job. Required.
        :type disable_options: ~azure.batch.models.BatchJobDisableOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(disable_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_disable_job_internal_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _enable_job_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Enables the specified Job, allowing new Tasks to run.

        When you call this API, the Batch service sets a disabled Job to the enabling
        state. After the this operation is completed, the Job moves to the active
        state, and scheduling of new Tasks under the Job resumes. The Batch service
        does not allow a Task to remain in the active state for more than 180 days.
        Therefore, if you enable a Job containing active Tasks which were added more
        than 180 days ago, those Tasks will not run.

        :param job_id: The ID of the Job to enable. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_enable_job_internal_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _terminate_job_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        options: Optional[_models.BatchJobTerminateOptions] = None,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        force: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Terminates the specified Job, marking it as completed.

        When a Terminate Job request is received, the Batch service sets the Job to the
        terminating state. The Batch service then terminates any running Tasks
        associated with the Job and runs any required Job release Tasks. Then the Job
        moves into the completed state. If there are any Tasks in the Job in the active
        state, they will remain in the active state. Once a Job is terminated, new
        Tasks cannot be added and any remaining active Tasks will not be scheduled.

        :param job_id: The ID of the Job to terminate. Required.
        :type job_id: str
        :param options: The options to use for terminating the Job. Default value is None.
        :type options: ~azure.batch.models.BatchJobTerminateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword force: If true, the server will terminate the Job even if the corresponding nodes have
         not fully processed the termination. The default value is false. Default value is None.
        :paramtype force: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        content_type = content_type if options else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        if options is not None:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_terminate_job_internal_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            force=force,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def create_job(  # pylint: disable=inconsistent-return-statements
        self,
        job: _models.BatchJobCreateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Creates a Job to the specified Account.

        The Batch service supports two ways to control the work done as part of a Job.
        In the first approach, the user specifies a Job Manager Task. The Batch service
        launches this Task when it is ready to start the Job. The Job Manager Task
        controls all other Tasks that run under this Job, by using the Task APIs. In
        the second approach, the user directly controls the execution of Tasks under an
        active Job, by using the Task APIs. Also note: when naming Jobs, avoid
        including sensitive information such as user names or secret project names.
        This information may appear in telemetry logs accessible to Microsoft Support
        engineers.

        :param job: The Job to be created. Required.
        :type job: ~azure.batch.models.BatchJobCreateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_job_request(
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_jobs(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchJob"]:
        """Lists all of the Jobs in the specified Account.

        Lists all of the Jobs in the specified Account.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-jobs
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-jobs>`_. Default
         value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchJob
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchJob]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_jobs_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchJob], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_jobs_from_schedule(
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchJob"]:
        """Lists the Jobs that have been created under the specified Job Schedule.

        Lists the Jobs that have been created under the specified Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule from which you want to get a list of Jobs.
         Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchJob
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchJob]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_jobs_from_schedule_request(
                    job_schedule_id=job_schedule_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchJob], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_job_preparation_and_release_task_status(  # pylint: disable=name-too-long
        self,
        job_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchJobPreparationAndReleaseTaskStatus"]:
        """Lists the execution status of the Job Preparation and Job Release Task for the
        specified Job across the Compute Nodes where the Job has run.

        This API returns the Job Preparation and Job Release Task status on all Compute
        Nodes that have run the Job Preparation or Job Release Task. This includes
        Compute Nodes which have since been removed from the Pool. If this API is
        invoked on a Job which has no Job Preparation or Job Release Task, the Batch
        service returns HTTP status code 409 (Conflict) with an error code of
        JobPreparationTaskNotSpecified.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: An iterator like instance of BatchJobPreparationAndReleaseTaskStatus
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.batch.models.BatchJobPreparationAndReleaseTaskStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchJobPreparationAndReleaseTaskStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_job_preparation_and_release_task_status_request(
                    job_id=job_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                list[_models.BatchJobPreparationAndReleaseTaskStatus], deserialized.get("value", [])
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_job_task_counts(
        self, job_id: str, *, timeout: Optional[int] = None, ocpdate: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> _models.BatchTaskCountsResult:
        """Gets the Task counts for the specified Job.

        Task counts provide a count of the Tasks by active, running or completed Task
        state, and a count of Tasks which succeeded or failed. Tasks in the preparing
        state are counted as running. Note that the numbers returned may not always be
        up to date. If you need exact task counts, use a list query.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: BatchTaskCountsResult. The BatchTaskCountsResult is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchTaskCountsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchTaskCountsResult] = kwargs.pop("cls", None)

        _request = build_batch_get_job_task_counts_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchTaskCountsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def job_schedule_exists(
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> bool:
        """Checks the specified Job Schedule exists.

        Checks the specified Job Schedule exists.

        :param job_schedule_id: The ID of the Job Schedule which you want to check. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_job_schedule_exists_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
            response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
            response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
            response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def _delete_job_schedule_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        force: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Job Schedule from the specified Account.

        When you delete a Job Schedule, this also deletes all Jobs and Tasks under that
        schedule. When Tasks are deleted, all the files in their working directories on
        the Compute Nodes are also deleted (the retention period is ignored). The Job
        Schedule statistics are no longer accessible once the Job Schedule is deleted,
        though they are still counted towards Account lifetime statistics.

        :param job_schedule_id: The ID of the Job Schedule to delete. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword force: If true, the server will delete the JobSchedule even if the corresponding nodes
         have not fully processed the deletion. The default value is false. Default value is None.
        :paramtype force: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_job_schedule_internal_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            force=force,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_job_schedule(
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchJobSchedule:
        """Gets information about the specified Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to get. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchJobSchedule. The BatchJobSchedule is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchJobSchedule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchJobSchedule] = kwargs.pop("cls", None)

        _request = build_batch_get_job_schedule_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchJobSchedule, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def update_job_schedule(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        job_schedule: _models.BatchJobScheduleUpdateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Job Schedule.

        This replaces only the Job Schedule properties specified in the request. For
        example, if the schedule property is not specified with this request, then the
        Batch service will keep the existing schedule. Changes to a Job Schedule only
        impact Jobs created by the schedule after the update has taken place; currently
        running Jobs are unaffected.

        :param job_schedule_id: The ID of the Job Schedule to update. Required.
        :type job_schedule_id: str
        :param job_schedule: The options to use for updating the Job Schedule. Required.
        :type job_schedule: ~azure.batch.models.BatchJobScheduleUpdateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job_schedule, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_update_job_schedule_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_job_schedule(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        job_schedule: _models.BatchJobSchedule,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Job Schedule.

        This fully replaces all the updatable properties of the Job Schedule. For
        example, if the schedule property is not specified with this request, then the
        Batch service will remove the existing schedule. Changes to a Job Schedule only
        impact Jobs created by the schedule after the update has taken place; currently
        running Jobs are unaffected.

        :param job_schedule_id: The ID of the Job Schedule to update. Required.
        :type job_schedule_id: str
        :param job_schedule: A Job Schedule with updated properties. Required.
        :type job_schedule: ~azure.batch.models.BatchJobSchedule
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job_schedule, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_job_schedule_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def disable_job_schedule(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Disables a Job Schedule.

        No new Jobs will be created until the Job Schedule is enabled again.

        :param job_schedule_id: The ID of the Job Schedule to disable. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_disable_job_schedule_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def enable_job_schedule(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Enables a Job Schedule.

        Enables a Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to enable. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_enable_job_schedule_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _terminate_job_schedule_internal(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        force: Optional[bool] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Terminates a Job Schedule.

        Terminates a Job Schedule.

        :param job_schedule_id: The ID of the Job Schedule to terminates. Required.
        :type job_schedule_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword force: If true, the server will terminate the JobSchedule even if the corresponding
         nodes have not fully processed the termination. The default value is false. Default value is
         None.
        :paramtype force: bool
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_terminate_job_schedule_internal_request(
            job_schedule_id=job_schedule_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            force=force,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def create_job_schedule(  # pylint: disable=inconsistent-return-statements
        self,
        job_schedule: _models.BatchJobScheduleCreateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Creates a Job Schedule to the specified Account.

        Creates a Job Schedule to the specified Account.

        :param job_schedule: The Job Schedule to be created. Required.
        :type job_schedule: ~azure.batch.models.BatchJobScheduleCreateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(job_schedule, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_job_schedule_request(
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_job_schedules(
        self,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchJobSchedule"]:
        """Lists all of the Job Schedules in the specified Account.

        Lists all of the Job Schedules in the specified Account.

        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-job-schedules
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-job-schedules>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchJobSchedule
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchJobSchedule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchJobSchedule]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_job_schedules_request(
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchJobSchedule], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def create_task(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task: _models.BatchTaskCreateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Creates a Task to the specified Job.

        The maximum lifetime of a Task from addition to completion is 180 days. If a
        Task has not completed within 180 days of being added it will be terminated by
        the Batch service and left in whatever state it was in at that time.

        :param job_id: The ID of the Job to which the Task is to be created. Required.
        :type job_id: str
        :param task: The Task to be created. Required.
        :type task: ~azure.batch.models.BatchTaskCreateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(task, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_task_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_tasks(
        self,
        job_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchTask"]:
        """Lists all of the Tasks that are associated with the specified Job.

        For multi-instance Tasks, information such as affinityId, executionInfo and
        nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        information about subtasks.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-tasks
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-tasks>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :return: An iterator like instance of BatchTask
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchTask]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchTask]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_tasks_request(
                    job_id=job_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    expand=expand,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchTask], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def create_task_collection(
        self,
        job_id: str,
        task_collection: _models.BatchTaskGroup,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.BatchCreateTaskCollectionResult:
        """Adds a collection of Tasks to the specified Job.

        Note that each Task must have a unique ID. The Batch service may not return the
        results for each Task in the same order the Tasks were submitted in this
        request. If the server times out or the connection is closed during the
        request, the request may have been partially or fully processed, or not at all.
        In such cases, the user should re-issue the request. Note that it is up to the
        user to correctly handle failures when re-issuing a request. For example, you
        should use the same Task IDs during a retry so that if the prior operation
        succeeded, the retry will not create extra Tasks unexpectedly. If the response
        contains any Tasks which failed to add, a client can retry the request. In a
        retry, it is most efficient to resubmit only Tasks that failed to add, and to
        omit Tasks that were successfully added on the first attempt. The maximum
        lifetime of a Task from addition to completion is 180 days. If a Task has not
        completed within 180 days of being added it will be terminated by the Batch
        service and left in whatever state it was in at that time.

        :param job_id: The ID of the Job to which the Task collection is to be added. Required.
        :type job_id: str
        :param task_collection: The Tasks to be added. Required.
        :type task_collection: ~azure.batch.models.BatchTaskGroup
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: BatchCreateTaskCollectionResult. The BatchCreateTaskCollectionResult is compatible
         with MutableMapping
        :rtype: ~azure.batch.models.BatchCreateTaskCollectionResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[_models.BatchCreateTaskCollectionResult] = kwargs.pop("cls", None)

        _content = json.dumps(task_collection, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_task_collection_request(
            job_id=job_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchCreateTaskCollectionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_task(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a Task from the specified Job.

        When a Task is deleted, all of the files in its directory on the Compute Node
        where it ran are also deleted (regardless of the retention time). For
        multi-instance Tasks, the delete Task operation applies synchronously to the
        primary task; subtasks and their files are then deleted asynchronously in the
        background.

        :param job_id: The ID of the Job from which to delete the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task to delete. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_task_request(
            job_id=job_id,
            task_id=task_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_task(
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        expand: Optional[list[str]] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.BatchTask:
        """Gets information about the specified Task.

        For multi-instance Tasks, information such as affinityId, executionInfo and
        nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        information about subtasks.

        :param job_id: The ID of the Job that contains the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task to get information about. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :keyword expand: An OData $expand clause. Default value is None.
        :paramtype expand: list[str]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: BatchTask. The BatchTask is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchTask
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchTask] = kwargs.pop("cls", None)

        _request = build_batch_get_task_request(
            job_id=job_id,
            task_id=task_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            select=select,
            expand=expand,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchTask, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def replace_task(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task_id: str,
        task: _models.BatchTask,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the properties of the specified Task.

        :param job_id: The ID of the Job containing the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task to update. Required.
        :type task_id: str
        :param task: The Task to update. Required.
        :type task: ~azure.batch.models.BatchTask
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(task, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_task_request(
            job_id=job_id,
            task_id=task_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def list_sub_tasks(
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchSubtask"]:
        """Lists all of the subtasks that are associated with the specified multi-instance
        Task.

        If the Task is not a multi-instance Task then this returns an empty collection.

        :param job_id: The ID of the Job. Required.
        :type job_id: str
        :param task_id: The ID of the Task. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: An iterator like instance of BatchSubtask
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchSubtask]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchSubtask]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_sub_tasks_request(
                    job_id=job_id,
                    task_id=task_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchSubtask], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def terminate_task(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Terminates the specified Task.

        When the Task has been terminated, it moves to the completed state. For
        multi-instance Tasks, the terminate Task operation applies synchronously to the
        primary task; subtasks are then terminated asynchronously in the background.

        :param job_id: The ID of the Job containing the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task to terminate. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_terminate_task_request(
            job_id=job_id,
            task_id=task_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def reactivate_task(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> None:
        """Reactivates a Task, allowing it to run again even if its retry count has been
        exhausted.

        Reactivation makes a Task eligible to be retried again up to its maximum retry
        count. The Task's state is changed to active. As the Task is no longer in the
        completed state, any previous exit code or failure information is no longer
        available after reactivation. Each time a Task is reactivated, its retry count
        is reset to 0. Reactivation will fail for Tasks that are not completed or that
        previously completed successfully (with an exit code of 0). Additionally, it
        will fail if the Job has completed (or is terminating or deleting).

        :param job_id: The ID of the Job containing the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task to reactivate. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_reactivate_task_request(
            job_id=job_id,
            task_id=task_id,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            etag=etag,
            match_condition=match_condition,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def delete_task_file(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        task_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes the specified Task file from the Compute Node where the Task ran.

        Deletes the specified Task file from the Compute Node where the Task ran.

        :param job_id: The ID of the Job that contains the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task whose file you want to retrieve. Required.
        :type task_id: str
        :param file_path: The path to the Task file that you want to get the content of. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword recursive: Whether to delete children of a directory. If the filePath parameter
         represents
         a directory instead of a file, you can set recursive to true to delete the
         directory and all of the files and subdirectories in it. If recursive is false
         then the directory must be empty or deletion will fail. Default value is None.
        :paramtype recursive: bool
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_task_file_request(
            job_id=job_id,
            task_id=task_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            recursive=recursive,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_task_file(
        self,
        job_id: str,
        task_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        ocp_range: Optional[str] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        """Returns the content of the specified Task file.

        :param job_id: The ID of the Job that contains the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task whose file you want to retrieve. Required.
        :type task_id: str
        :param file_path: The path to the Task file that you want to get the content of. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword ocp_range: The byte range to be retrieved. The default is to retrieve the entire file.
         The
         format is bytes=startRange-endRange. Default value is None.
        :paramtype ocp_range: str
        :return: Iterator[bytes]
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_batch_get_task_file_request(
            job_id=job_id,
            task_id=task_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            ocp_range=ocp_range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["ocp-batch-file-isdirectory"] = self._deserialize(
            "bool", response.headers.get("ocp-batch-file-isdirectory")
        )
        response_headers["ocp-batch-file-mode"] = self._deserialize("str", response.headers.get("ocp-batch-file-mode"))
        response_headers["ocp-batch-file-url"] = self._deserialize("str", response.headers.get("ocp-batch-file-url"))
        response_headers["ocp-creation-time"] = self._deserialize("rfc-1123", response.headers.get("ocp-creation-time"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _get_task_file_properties_internal(
        self,
        job_id: str,
        task_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> bool:
        """Gets the properties of the specified Task file.

        :param job_id: The ID of the Job that contains the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task whose file you want to retrieve. Required.
        :type task_id: str
        :param file_path: The path to the Task file that you want to get the content of. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_get_task_file_properties_internal_request(
            job_id=job_id,
            task_id=task_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["ocp-batch-file-isdirectory"] = self._deserialize(
            "bool", response.headers.get("ocp-batch-file-isdirectory")
        )
        response_headers["ocp-batch-file-mode"] = self._deserialize("str", response.headers.get("ocp-batch-file-mode"))
        response_headers["ocp-batch-file-url"] = self._deserialize("str", response.headers.get("ocp-batch-file-url"))
        response_headers["ocp-creation-time"] = self._deserialize("rfc-1123", response.headers.get("ocp-creation-time"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def list_task_files(
        self,
        job_id: str,
        task_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchNodeFile"]:
        """Lists the files in a Task's directory on its Compute Node.

        Lists the files in a Task's directory on its Compute Node.

        :param job_id: The ID of the Job that contains the Task. Required.
        :type job_id: str
        :param task_id: The ID of the Task whose files you want to list. Required.
        :type task_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-task-files
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-task-files>`_.
         Default value is None.
        :paramtype filter: str
        :keyword recursive: Whether to list children of the Task directory. This parameter can be used
         in
         combination with the filter parameter to list specific type of files. Default value is None.
        :paramtype recursive: bool
        :return: An iterator like instance of BatchNodeFile
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchNodeFile]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchNodeFile]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_task_files_request(
                    job_id=job_id,
                    task_id=task_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    recursive=recursive,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchNodeFile], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def create_node_user(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        user: _models.BatchNodeUserCreateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Adds a user Account to the specified Compute Node.

        You can add a user Account to a Compute Node only when it is in the idle or
        running state.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the machine on which you want to create a user Account. Required.
        :type node_id: str
        :param user: The options to use for creating the user. Required.
        :type user: ~azure.batch.models.BatchNodeUserCreateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(user, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_create_node_user_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def delete_node_user(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        user_name: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a user Account from the specified Compute Node.

        You can delete a user Account to a Compute Node only when it is in the idle or
        running state.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the machine on which you want to delete a user Account. Required.
        :type node_id: str
        :param user_name: The name of the user Account to delete. Required.
        :type user_name: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_node_user_request(
            pool_id=pool_id,
            node_id=node_id,
            user_name=user_name,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def replace_node_user(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        user_name: str,
        update_options: _models.BatchNodeUserUpdateOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Updates the password and expiration time of a user Account on the specified Compute Node.

        This operation replaces of all the updatable properties of the Account. For
        example, if the expiryTime element is not specified, the current value is
        replaced with the default value, not left unmodified. You can update a user
        Account on a Compute Node only when it is in the idle or running state.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the machine on which you want to update a user Account. Required.
        :type node_id: str
        :param user_name: The name of the user Account to update. Required.
        :type user_name: str
        :param update_options: The options to use for updating the user. Required.
        :type update_options: ~azure.batch.models.BatchNodeUserUpdateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _content = json.dumps(update_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_replace_node_user_request(
            pool_id=pool_id,
            node_id=node_id,
            user_name=user_name,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_node(
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> _models.BatchNode:
        """Gets information about the specified Compute Node.

        Gets information about the specified Compute Node.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to get information about. Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: BatchNode. The BatchNode is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchNode
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchNode] = kwargs.pop("cls", None)

        _request = build_batch_get_node_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchNode, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _reboot_node_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        options: Optional[_models.BatchNodeRebootOptions] = None,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Restarts the specified Compute Node.

        You can restart a Compute Node only if it is in an idle or running state.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to restart. Required.
        :type node_id: str
        :param options: The options to use for rebooting the Compute Node. Default value is None.
        :type options: ~azure.batch.models.BatchNodeRebootOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        content_type = content_type if options else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        if options is not None:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_reboot_node_internal_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _start_node_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Starts the specified Compute Node.

        You can start a Compute Node only if it has been deallocated.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to restart. Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_start_node_internal_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _reimage_node_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        options: Optional[_models.BatchNodeReimageOptions] = None,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Reinstalls the operating system on the specified Compute Node.

        You can reinstall the operating system on a Compute Node only if it is in an
        idle or running state. This API can be invoked only on Pools created with the
        cloud service configuration property.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to restart. Required.
        :type node_id: str
        :param options: The options to use for reimaging the Compute Node. Default value is None.
        :type options: ~azure.batch.models.BatchNodeReimageOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        content_type = content_type if options else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        if options is not None:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_reimage_node_internal_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def _deallocate_node_internal(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        options: Optional[_models.BatchNodeDeallocateOptions] = None,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Deallocates the specified Compute Node.

        You can deallocate a Compute Node only if it is in an idle or running state.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to restart. Required.
        :type node_id: str
        :param options: The options to use for deallocating the Compute Node. Default value is None.
        :type options: ~azure.batch.models.BatchNodeDeallocateOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        content_type = content_type if options else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        if options is not None:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_deallocate_node_internal_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def disable_node_scheduling(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        options: Optional[_models.BatchNodeDisableSchedulingOptions] = None,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Disables Task scheduling on the specified Compute Node.

        You can disable Task scheduling on a Compute Node only if its current
        scheduling state is enabled.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node on which you want to disable Task scheduling.
         Required.
        :type node_id: str
        :param options: The options to use for disabling scheduling on the Compute Node. Default value
         is None.
        :type options: ~azure.batch.models.BatchNodeDisableSchedulingOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        content_type = content_type if options else None
        cls: ClsType[None] = kwargs.pop("cls", None)

        if options is not None:
            _content = json.dumps(options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
        else:
            _content = None

        _request = build_batch_disable_node_scheduling_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def enable_node_scheduling(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """Enables Task scheduling on the specified Compute Node.

        You can enable Task scheduling on a Compute Node only if its current scheduling
        state is disabled.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node on which you want to enable Task scheduling.
         Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_enable_node_scheduling_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["DataServiceId"] = self._deserialize("str", response.headers.get("DataServiceId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_node_remote_login_settings(
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.BatchNodeRemoteLoginSettings:
        """Gets the settings required for remote login to a Compute Node.

        Before you can remotely login to a Compute Node using the remote login settings,
        you must create a user Account on the Compute Node.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node for which to obtain the remote login settings.
         Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: BatchNodeRemoteLoginSettings. The BatchNodeRemoteLoginSettings is compatible with
         MutableMapping
        :rtype: ~azure.batch.models.BatchNodeRemoteLoginSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchNodeRemoteLoginSettings] = kwargs.pop("cls", None)

        _request = build_batch_get_node_remote_login_settings_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchNodeRemoteLoginSettings, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def upload_node_logs(
        self,
        pool_id: str,
        node_id: str,
        upload_options: _models.UploadBatchServiceLogsOptions,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> _models.UploadBatchServiceLogsResult:
        """Upload Azure Batch service log files from the specified Compute Node to Azure
        Blob Storage.

        This is for gathering Azure Batch service log files in an automated fashion
        from Compute Nodes if you are experiencing an error and wish to escalate to
        Azure support. The Azure Batch service log files should be shared with Azure
        support to aid in debugging issues with the Batch service.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node for which you want to get the Remote Desktop
         Protocol file. Required.
        :type node_id: str
        :param upload_options: The Azure Batch service log files upload options. Required.
        :type upload_options: ~azure.batch.models.UploadBatchServiceLogsOptions
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :return: UploadBatchServiceLogsResult. The UploadBatchServiceLogsResult is compatible with
         MutableMapping
        :rtype: ~azure.batch.models.UploadBatchServiceLogsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("content-type", "application/json; odata=minimalmetadata")
        )
        cls: ClsType[_models.UploadBatchServiceLogsResult] = kwargs.pop("cls", None)

        _content = json.dumps(upload_options, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_upload_node_logs_request(
            pool_id=pool_id,
            node_id=node_id,
            timeout=timeout,
            ocpdate=ocpdate,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.UploadBatchServiceLogsResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_nodes(
        self,
        pool_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchNode"]:
        """Lists the Compute Nodes in the specified Pool.

        Lists the Compute Nodes in the specified Pool.

        :param pool_id: The ID of the Pool from which you want to list Compute Nodes. Required.
        :type pool_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool>`_.
         Default value is None.
        :paramtype filter: str
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: An iterator like instance of BatchNode
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchNode]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchNode]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_nodes_request(
                    pool_id=pool_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchNode], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_node_extension(
        self,
        pool_id: str,
        node_id: str,
        extension_name: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> _models.BatchNodeVMExtension:
        """Gets information about the specified Compute Node Extension.

        Gets information about the specified Compute Node Extension.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that contains the extensions. Required.
        :type node_id: str
        :param extension_name: The name of the Compute Node Extension that you want to get information
         about. Required.
        :type extension_name: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: BatchNodeVMExtension. The BatchNodeVMExtension is compatible with MutableMapping
        :rtype: ~azure.batch.models.BatchNodeVMExtension
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchNodeVMExtension] = kwargs.pop("cls", None)

        _request = build_batch_get_node_extension_request(
            pool_id=pool_id,
            node_id=node_id,
            extension_name=extension_name,
            timeout=timeout,
            ocpdate=ocpdate,
            select=select,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchNodeVMExtension, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_node_extensions(
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        select: Optional[list[str]] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchNodeVMExtension"]:
        """Lists the Compute Nodes Extensions in the specified Pool.

        Lists the Compute Nodes Extensions in the specified Pool.

        :param pool_id: The ID of the Pool that contains Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node that you want to list extensions. Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword select: An OData $select clause. Default value is None.
        :paramtype select: list[str]
        :return: An iterator like instance of BatchNodeVMExtension
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchNodeVMExtension]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchNodeVMExtension]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_node_extensions_request(
                    pool_id=pool_id,
                    node_id=node_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    select=select,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchNodeVMExtension], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def delete_node_file(  # pylint: disable=inconsistent-return-statements
        self,
        pool_id: str,
        node_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes the specified file from the Compute Node.

        Deletes the specified file from the Compute Node.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node. Required.
        :type node_id: str
        :param file_path: The path to the file or directory. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword recursive: Whether to delete children of a directory. If the filePath parameter
         represents
         a directory instead of a file, you can set recursive to true to delete the
         directory and all of the files and subdirectories in it. If recursive is false
         then the directory must be empty or deletion will fail. Default value is None.
        :paramtype recursive: bool
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_delete_node_file_request(
            pool_id=pool_id,
            node_id=node_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            recursive=recursive,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace
    def get_node_file(
        self,
        pool_id: str,
        node_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        ocp_range: Optional[str] = None,
        **kwargs: Any
    ) -> Iterator[bytes]:
        """Returns the content of the specified Compute Node file.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node. Required.
        :type node_id: str
        :param file_path: The path to the file or directory. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword ocp_range: The byte range to be retrieved. The default is to retrieve the entire file.
         The
         format is bytes=startRange-endRange. Default value is None.
        :paramtype ocp_range: str
        :return: Iterator[bytes]
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _request = build_batch_get_node_file_request(
            pool_id=pool_id,
            node_id=node_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            ocp_range=ocp_range,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["ocp-batch-file-isdirectory"] = self._deserialize(
            "bool", response.headers.get("ocp-batch-file-isdirectory")
        )
        response_headers["ocp-batch-file-mode"] = self._deserialize("str", response.headers.get("ocp-batch-file-mode"))
        response_headers["ocp-batch-file-url"] = self._deserialize("str", response.headers.get("ocp-batch-file-url"))
        response_headers["ocp-creation-time"] = self._deserialize("rfc-1123", response.headers.get("ocp-creation-time"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _get_node_file_properties_internal(
        self,
        pool_id: str,
        node_id: str,
        file_path: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        if_modified_since: Optional[datetime.datetime] = None,
        if_unmodified_since: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> bool:
        """Gets the properties of the specified Compute Node file.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node. Required.
        :type node_id: str
        :param file_path: The path to the file or directory. Required.
        :type file_path: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword if_modified_since: A timestamp indicating the last modified time of the resource known
         to the
         client. The operation will be performed only if the resource on the service has
         been modified since the specified time. Default value is None.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: A timestamp indicating the last modified time of the resource
         known to the
         client. The operation will be performed only if the resource on the service has
         not been modified since the specified time. Default value is None.
        :paramtype if_unmodified_since: ~datetime.datetime
        :return: bool
        :rtype: bool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_get_node_file_properties_internal_request(
            pool_id=pool_id,
            node_id=node_id,
            file_path=file_path,
            timeout=timeout,
            ocpdate=ocpdate,
            if_modified_since=if_modified_since,
            if_unmodified_since=if_unmodified_since,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.BatchError,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["Content-Length"] = self._deserialize("int", response.headers.get("Content-Length"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["client-request-id"] = self._deserialize("str", response.headers.get("client-request-id"))
        response_headers["ocp-batch-file-isdirectory"] = self._deserialize(
            "bool", response.headers.get("ocp-batch-file-isdirectory")
        )
        response_headers["ocp-batch-file-mode"] = self._deserialize("str", response.headers.get("ocp-batch-file-mode"))
        response_headers["ocp-batch-file-url"] = self._deserialize("str", response.headers.get("ocp-batch-file-url"))
        response_headers["ocp-creation-time"] = self._deserialize("rfc-1123", response.headers.get("ocp-creation-time"))
        response_headers["request-id"] = self._deserialize("str", response.headers.get("request-id"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
        return 200 <= response.status_code <= 299

    @distributed_trace
    def list_node_files(
        self,
        pool_id: str,
        node_id: str,
        *,
        timeout: Optional[int] = None,
        ocpdate: Optional[datetime.datetime] = None,
        max_results: Optional[int] = None,
        filter: Optional[str] = None,
        recursive: Optional[bool] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.BatchNodeFile"]:
        """Lists all of the files in Task directories on the specified Compute Node.

        Lists all of the files in Task directories on the specified Compute Node.

        :param pool_id: The ID of the Pool that contains the Compute Node. Required.
        :type pool_id: str
        :param node_id: The ID of the Compute Node whose files you want to list. Required.
        :type node_id: str
        :keyword timeout: The maximum time that the server can spend processing the request, in
         seconds. The default is 30 seconds. If the value is larger than 30, the default will be used
         instead.". Default value is None.
        :paramtype timeout: int
        :keyword ocpdate: The time the request was issued. Client libraries typically set this to the
         current system clock time; set it explicitly if you are calling the REST API
         directly. Default value is None.
        :paramtype ocpdate: ~datetime.datetime
        :keyword max_results: The maximum number of items to return in the response. A maximum of 1000
         applications can be returned. Default value is None.
        :paramtype max_results: int
        :keyword filter: An OData $filter clause. For more information on constructing this filter, see
         `https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files
         <https://learn.microsoft.com/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files>`_.
         Default value is None.
        :paramtype filter: str
        :keyword recursive: Whether to list children of a directory. Default value is None.
        :paramtype recursive: bool
        :return: An iterator like instance of BatchNodeFile
        :rtype: ~azure.core.paging.ItemPaged[~azure.batch.models.BatchNodeFile]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[list[_models.BatchNodeFile]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_list_node_files_request(
                    pool_id=pool_id,
                    node_id=node_id,
                    timeout=timeout,
                    ocpdate=ocpdate,
                    max_results=max_results,
                    filter=filter,
                    recursive=recursive,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(list[_models.BatchNodeFile], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("odata.nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.BatchError,
                    response,
                )
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
