# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterServerVulnerabilityAssessmentOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_server_vulnerability_assessment_list_by_extended_resource(self, resource_group):
        response = self.client.server_vulnerability_assessment.list_by_extended_resource(
            resource_group_name=resource_group.name,
            resource_namespace="str",
            resource_type="str",
            resource_name="str",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_server_vulnerability_assessment_get(self, resource_group):
        response = self.client.server_vulnerability_assessment.get(
            resource_group_name=resource_group.name,
            resource_namespace="str",
            resource_type="str",
            resource_name="str",
            server_vulnerability_assessment="default",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_server_vulnerability_assessment_create_or_update(self, resource_group):
        response = self.client.server_vulnerability_assessment.create_or_update(
            resource_group_name=resource_group.name,
            resource_namespace="str",
            resource_type="str",
            resource_name="str",
            server_vulnerability_assessment="default",
            api_version="2020-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_server_vulnerability_assessment_begin_delete(self, resource_group):
        response = self.client.server_vulnerability_assessment.begin_delete(
            resource_group_name=resource_group.name,
            resource_namespace="str",
            resource_type="str",
            resource_name="str",
            server_vulnerability_assessment="default",
            api_version="2020-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
