# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class Alias(_serialization.Model):
    """The alias type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The alias name.
    :vartype name: str
    :ivar paths: The paths for an alias.
    :vartype paths: list[~azure.mgmt.resource.deployments.models.AliasPath]
    :ivar type: The type of the alias. Known values are: "NotSpecified", "PlainText", and "Mask".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.AliasType
    :ivar default_path: The default path for an alias.
    :vartype default_path: str
    :ivar default_pattern: The default pattern for an alias.
    :vartype default_pattern: ~azure.mgmt.resource.deployments.models.AliasPattern
    :ivar default_metadata: The default alias path metadata. Applies to the default path and to any
     alias path that doesn't have metadata.
    :vartype default_metadata: ~azure.mgmt.resource.deployments.models.AliasPathMetadata
    """

    _validation = {
        "default_metadata": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "paths": {"key": "paths", "type": "[AliasPath]"},
        "type": {"key": "type", "type": "str"},
        "default_path": {"key": "defaultPath", "type": "str"},
        "default_pattern": {"key": "defaultPattern", "type": "AliasPattern"},
        "default_metadata": {"key": "defaultMetadata", "type": "AliasPathMetadata"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        paths: Optional[List["_models.AliasPath"]] = None,
        type: Optional[Union[str, "_models.AliasType"]] = None,
        default_path: Optional[str] = None,
        default_pattern: Optional["_models.AliasPattern"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The alias name.
        :paramtype name: str
        :keyword paths: The paths for an alias.
        :paramtype paths: list[~azure.mgmt.resource.deployments.models.AliasPath]
        :keyword type: The type of the alias. Known values are: "NotSpecified", "PlainText", and
         "Mask".
        :paramtype type: str or ~azure.mgmt.resource.deployments.models.AliasType
        :keyword default_path: The default path for an alias.
        :paramtype default_path: str
        :keyword default_pattern: The default pattern for an alias.
        :paramtype default_pattern: ~azure.mgmt.resource.deployments.models.AliasPattern
        """
        super().__init__(**kwargs)
        self.name = name
        self.paths = paths
        self.type = type
        self.default_path = default_path
        self.default_pattern = default_pattern
        self.default_metadata: Optional["_models.AliasPathMetadata"] = None


class AliasPath(_serialization.Model):
    """The type of the paths for alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of an alias.
    :vartype path: str
    :ivar api_versions: The API versions.
    :vartype api_versions: list[str]
    :ivar pattern: The pattern for an alias path.
    :vartype pattern: ~azure.mgmt.resource.deployments.models.AliasPattern
    :ivar metadata: The metadata of the alias path. If missing, fall back to the default metadata
     of the alias.
    :vartype metadata: ~azure.mgmt.resource.deployments.models.AliasPathMetadata
    """

    _validation = {
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "pattern": {"key": "pattern", "type": "AliasPattern"},
        "metadata": {"key": "metadata", "type": "AliasPathMetadata"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        api_versions: Optional[List[str]] = None,
        pattern: Optional["_models.AliasPattern"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path of an alias.
        :paramtype path: str
        :keyword api_versions: The API versions.
        :paramtype api_versions: list[str]
        :keyword pattern: The pattern for an alias path.
        :paramtype pattern: ~azure.mgmt.resource.deployments.models.AliasPattern
        """
        super().__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions
        self.pattern = pattern
        self.metadata: Optional["_models.AliasPathMetadata"] = None


class AliasPathMetadata(_serialization.Model):
    """AliasPathMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the token that the alias path is referring to. Known values are:
     "NotSpecified", "Any", "String", "Object", "Array", "Integer", "Number", and "Boolean".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.AliasPathTokenType
    :ivar attributes: The attributes of the token that the alias path is referring to. Known values
     are: "None" and "Modifiable".
    :vartype attributes: str or ~azure.mgmt.resource.deployments.models.AliasPathAttributes
    """

    _validation = {
        "type": {"readonly": True},
        "attributes": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "attributes": {"key": "attributes", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.AliasPathTokenType"]] = None
        self.attributes: Optional[Union[str, "_models.AliasPathAttributes"]] = None


class AliasPattern(_serialization.Model):
    """The type of the pattern for an alias path.

    :ivar phrase: The alias pattern phrase.
    :vartype phrase: str
    :ivar variable: The alias pattern variable.
    :vartype variable: str
    :ivar type: The type of alias pattern. Known values are: "NotSpecified" and "Extract".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.AliasPatternType
    """

    _attribute_map = {
        "phrase": {"key": "phrase", "type": "str"},
        "variable": {"key": "variable", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        phrase: Optional[str] = None,
        variable: Optional[str] = None,
        type: Optional[Union[str, "_models.AliasPatternType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword phrase: The alias pattern phrase.
        :paramtype phrase: str
        :keyword variable: The alias pattern variable.
        :paramtype variable: str
        :keyword type: The type of alias pattern. Known values are: "NotSpecified" and "Extract".
        :paramtype type: str or ~azure.mgmt.resource.deployments.models.AliasPatternType
        """
        super().__init__(**kwargs)
        self.phrase = phrase
        self.variable = variable
        self.type = type


class ApiProfile(_serialization.Model):
    """ApiProfile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar profile_version: The profile version.
    :vartype profile_version: str
    :ivar api_version: The API version.
    :vartype api_version: str
    """

    _validation = {
        "profile_version": {"readonly": True},
        "api_version": {"readonly": True},
    }

    _attribute_map = {
        "profile_version": {"key": "profileVersion", "type": "str"},
        "api_version": {"key": "apiVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.profile_version: Optional[str] = None
        self.api_version: Optional[str] = None


class BasicDependency(_serialization.Model):
    """Deployment dependency information.

    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class DebugSetting(_serialization.Model):
    """The debug setting.

    :ivar detail_level: Specifies the type of information to log for debugging. The permitted
     values are none, requestContent, responseContent, or both requestContent and responseContent
     separated by a comma. The default is none. When setting this value, carefully consider the type
     of information you are passing in during deployment. By logging information about the request
     or response, you could potentially expose sensitive data that is retrieved through the
     deployment operations.
    :vartype detail_level: str
    """

    _attribute_map = {
        "detail_level": {"key": "detailLevel", "type": "str"},
    }

    def __init__(self, *, detail_level: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword detail_level: Specifies the type of information to log for debugging. The permitted
         values are none, requestContent, responseContent, or both requestContent and responseContent
         separated by a comma. The default is none. When setting this value, carefully consider the type
         of information you are passing in during deployment. By logging information about the request
         or response, you could potentially expose sensitive data that is retrieved through the
         deployment operations.
        :paramtype detail_level: str
        """
        super().__init__(**kwargs)
        self.detail_level = detail_level


class Dependency(_serialization.Model):
    """Deployment dependency information.

    :ivar depends_on: The list of dependencies.
    :vartype depends_on: list[~azure.mgmt.resource.deployments.models.BasicDependency]
    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        "depends_on": {"key": "dependsOn", "type": "[BasicDependency]"},
        "id": {"key": "id", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        depends_on: Optional[List["_models.BasicDependency"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword depends_on: The list of dependencies.
        :paramtype depends_on: list[~azure.mgmt.resource.deployments.models.BasicDependency]
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.depends_on = depends_on
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class Deployment(_serialization.Model):
    """Deployment operation parameters.

    All required parameters must be populated in order to send to server.

    :ivar location: The location to store the deployment data.
    :vartype location: str
    :ivar properties: The deployment properties. Required.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentProperties
    :ivar tags: Deployment tags.
    :vartype tags: dict[str, str]
    :ivar identity: The Managed Identity configuration for a deployment.
    :vartype identity: ~azure.mgmt.resource.deployments.models.DeploymentIdentity
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "DeploymentIdentity"},
    }

    def __init__(
        self,
        *,
        properties: "_models.DeploymentProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.DeploymentIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location to store the deployment data.
        :paramtype location: str
        :keyword properties: The deployment properties. Required.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentProperties
        :keyword tags: Deployment tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The Managed Identity configuration for a deployment.
        :paramtype identity: ~azure.mgmt.resource.deployments.models.DeploymentIdentity
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties
        self.tags = tags
        self.identity = identity


class DeploymentDiagnosticsDefinition(_serialization.Model):
    """DeploymentDiagnosticsDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar level: Denotes the additional response level. Required. Known values are: "Warning",
     "Info", and "Error".
    :vartype level: str or ~azure.mgmt.resource.deployments.models.Level
    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.deployments.models.ErrorAdditionalInfo]
    """

    _validation = {
        "level": {"required": True, "readonly": True},
        "code": {"required": True, "readonly": True},
        "message": {"required": True, "readonly": True},
        "target": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "level": {"key": "level", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.level: Optional[Union[str, "_models.Level"]] = None
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class DeploymentExportResult(_serialization.Model):
    """The deployment export result.

    :ivar template: The template content.
    :vartype template: JSON
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
    }

    def __init__(self, *, template: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword template: The template content.
        :paramtype template: JSON
        """
        super().__init__(**kwargs)
        self.template = template


class DeploymentExtended(_serialization.Model):
    """Deployment information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the deployment.
    :vartype id: str
    :ivar name: The name of the deployment.
    :vartype name: str
    :ivar type: The type of the deployment.
    :vartype type: str
    :ivar location: the location of the deployment.
    :vartype location: str
    :ivar properties: Deployment properties.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentPropertiesExtended
    :ivar tags: Deployment tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentPropertiesExtended"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.DeploymentPropertiesExtended"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: the location of the deployment.
        :paramtype location: str
        :keyword properties: Deployment properties.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentPropertiesExtended
        :keyword tags: Deployment tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.properties = properties
        self.tags = tags


class DeploymentExtendedFilter(_serialization.Model):
    """Deployment filter.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, provisioning_state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword provisioning_state: The provisioning state.
        :paramtype provisioning_state: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state


class DeploymentExtensionConfigItem(_serialization.Model):
    """DeploymentExtensionConfigItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The value type of the extension config property. Known values are: "String", "Int",
     "Bool", "Array", "Object", "SecureString", "SecureObject", and "Int".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.ExtensionConfigPropertyType
    :ivar value: The value of the extension config property.
    :vartype value: any
    :ivar key_vault_reference: The Azure Key Vault reference used to retrieve the secret value of
     the extension config property.
    :vartype key_vault_reference:
     ~azure.mgmt.resource.deployments.models.KeyVaultParameterReference
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "object"},
        "key_vault_reference": {"key": "keyVaultReference", "type": "KeyVaultParameterReference"},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        key_vault_reference: Optional["_models.KeyVaultParameterReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The value of the extension config property.
        :paramtype value: any
        :keyword key_vault_reference: The Azure Key Vault reference used to retrieve the secret value
         of the extension config property.
        :paramtype key_vault_reference:
         ~azure.mgmt.resource.deployments.models.KeyVaultParameterReference
        """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.ExtensionConfigPropertyType"]] = None
        self.value = value
        self.key_vault_reference = key_vault_reference


class DeploymentExtensionDefinition(_serialization.Model):
    """DeploymentExtensionDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alias: The alias of the extension as defined in the deployment template.
    :vartype alias: str
    :ivar name: The extension name.
    :vartype name: str
    :ivar version: The extension version.
    :vartype version: str
    :ivar config_id: The extension configuration ID. It uniquely identifies a deployment control
     plane within an extension.
    :vartype config_id: str
    :ivar config: The extension configuration.
    :vartype config: dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExtensionConfigItem]
    """

    _validation = {
        "alias": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
        "config_id": {"readonly": True},
        "config": {"readonly": True},
    }

    _attribute_map = {
        "alias": {"key": "alias", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "config_id": {"key": "configId", "type": "str"},
        "config": {"key": "config", "type": "{DeploymentExtensionConfigItem}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alias: Optional[str] = None
        self.name: Optional[str] = None
        self.version: Optional[str] = None
        self.config_id: Optional[str] = None
        self.config: Optional[Dict[str, "_models.DeploymentExtensionConfigItem"]] = None


class DeploymentExternalInput(_serialization.Model):
    """Deployment external input for parameterization.

    All required parameters must be populated in order to send to server.

    :ivar value: External input value. Required.
    :vartype value: any
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Any, **kwargs: Any) -> None:
        """
        :keyword value: External input value. Required.
        :paramtype value: any
        """
        super().__init__(**kwargs)
        self.value = value


class DeploymentExternalInputDefinition(_serialization.Model):
    """Deployment external input definition for parameterization.

    All required parameters must be populated in order to send to server.

    :ivar kind: The kind of external input. Required.
    :vartype kind: str
    :ivar config: Configuration for the external input.
    :vartype config: any
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "config": {"key": "config", "type": "object"},
    }

    def __init__(self, *, kind: str, config: Optional[Any] = None, **kwargs: Any) -> None:
        """
        :keyword kind: The kind of external input. Required.
        :paramtype kind: str
        :keyword config: Configuration for the external input.
        :paramtype config: any
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.config = config


class DeploymentIdentity(_serialization.Model):
    """The Managed Identity configuration for a deployment.

    All required parameters must be populated in order to send to server.

    :ivar type: The identity type. Required. Known values are: "None" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.DeploymentIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.deployments.models.UserAssignedIdentity]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.DeploymentIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Required. Known values are: "None" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.resource.deployments.models.DeploymentIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.deployments.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class DeploymentListResult(_serialization.Model):
    """List of deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployments.
    :vartype value: list[~azure.mgmt.resource.deployments.models.DeploymentExtended]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentExtended]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentExtended"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of deployments.
        :paramtype value: list[~azure.mgmt.resource.deployments.models.DeploymentExtended]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentOperation(_serialization.Model):
    """Deployment operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full deployment operation ID.
    :vartype id: str
    :ivar operation_id: Deployment operation ID.
    :vartype operation_id: str
    :ivar properties: Deployment properties.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentOperationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "operation_id": {"key": "operationId", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentOperationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeploymentOperationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Deployment properties.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentOperationProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.operation_id: Optional[str] = None
        self.properties = properties


class DeploymentOperationProperties(_serialization.Model):
    """Deployment operation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_operation: The name of the current provisioning operation. Known values are:
     "NotSpecified", "Create", "Delete", "Waiting", "AzureAsyncOperationWaiting",
     "ResourceCacheWaiting", "Action", "Read", "EvaluateDeploymentOutput", and "DeploymentCleanup".
    :vartype provisioning_operation: str or
     ~azure.mgmt.resource.deployments.models.ProvisioningOperation
    :ivar provisioning_state: The state of the provisioning.
    :vartype provisioning_state: str
    :ivar timestamp: The date and time of the operation.
    :vartype timestamp: ~datetime.datetime
    :ivar duration: The duration of the operation.
    :vartype duration: str
    :ivar service_request_id: Deployment operation service request id.
    :vartype service_request_id: str
    :ivar status_code: Operation status code from the resource provider. This property may not be
     set if a response has not yet been received.
    :vartype status_code: str
    :ivar status_message: Operation status message from the resource provider. This property is
     optional.  It will only be provided if an error was received from the resource provider.
    :vartype status_message: ~azure.mgmt.resource.deployments.models.StatusMessage
    :ivar target_resource: The target resource.
    :vartype target_resource: ~azure.mgmt.resource.deployments.models.TargetResource
    :ivar request: The HTTP request message.
    :vartype request: ~azure.mgmt.resource.deployments.models.HttpMessage
    :ivar response: The HTTP response message.
    :vartype response: ~azure.mgmt.resource.deployments.models.HttpMessage
    """

    _validation = {
        "provisioning_operation": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "timestamp": {"readonly": True},
        "duration": {"readonly": True},
        "service_request_id": {"readonly": True},
        "status_code": {"readonly": True},
        "status_message": {"readonly": True},
        "target_resource": {"readonly": True},
        "request": {"readonly": True},
        "response": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_operation": {"key": "provisioningOperation", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "str"},
        "service_request_id": {"key": "serviceRequestId", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "StatusMessage"},
        "target_resource": {"key": "targetResource", "type": "TargetResource"},
        "request": {"key": "request", "type": "HttpMessage"},
        "response": {"key": "response", "type": "HttpMessage"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_operation: Optional[Union[str, "_models.ProvisioningOperation"]] = None
        self.provisioning_state: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.duration: Optional[str] = None
        self.service_request_id: Optional[str] = None
        self.status_code: Optional[str] = None
        self.status_message: Optional["_models.StatusMessage"] = None
        self.target_resource: Optional["_models.TargetResource"] = None
        self.request: Optional["_models.HttpMessage"] = None
        self.response: Optional["_models.HttpMessage"] = None


class DeploymentOperationsListResult(_serialization.Model):
    """List of deployment operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployment operations.
    :vartype value: list[~azure.mgmt.resource.deployments.models.DeploymentOperation]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentOperation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of deployment operations.
        :paramtype value: list[~azure.mgmt.resource.deployments.models.DeploymentOperation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentParameter(_serialization.Model):
    """Deployment parameter for the template.

    :ivar value: Input value to the parameter .
    :vartype value: any
    :ivar reference: Azure Key Vault parameter reference.
    :vartype reference: ~azure.mgmt.resource.deployments.models.KeyVaultParameterReference
    :ivar expression: Input expression to the parameter.
    :vartype expression: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
        "reference": {"key": "reference", "type": "KeyVaultParameterReference"},
        "expression": {"key": "expression", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[Any] = None,
        reference: Optional["_models.KeyVaultParameterReference"] = None,
        expression: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Input value to the parameter .
        :paramtype value: any
        :keyword reference: Azure Key Vault parameter reference.
        :paramtype reference: ~azure.mgmt.resource.deployments.models.KeyVaultParameterReference
        :keyword expression: Input expression to the parameter.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.reference = reference
        self.expression = expression


class DeploymentProperties(_serialization.Model):
    """Deployment properties.

    All required parameters must be populated in order to send to server.

    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link: ~azure.mgmt.resource.deployments.models.TemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     You use this element when you want to provide the parameter values directly in the request
     rather than link to an existing parameter file. Use either the parametersLink property or the
     parameters property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: dict[str, ~azure.mgmt.resource.deployments.models.DeploymentParameter]
    :ivar external_inputs: External input values, used by external tooling for parameter
     evaluation.
    :vartype external_inputs: dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExternalInput]
    :ivar external_input_definitions: External input definitions, used by external tooling to
     define expected external input values.
    :vartype external_input_definitions: dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExternalInputDefinition]
    :ivar parameters_link: The URI of parameters file. You use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link: ~azure.mgmt.resource.deployments.models.ParametersLink
    :ivar extension_configs: The configurations to use for deployment extensions. The keys of this
     object are deployment extension aliases as defined in the deployment template.
    :vartype extension_configs: dict[str, dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExtensionConfigItem]]
    :ivar mode: The mode that is used to deploy resources. This value can be either Incremental or
     Complete. In Incremental mode, resources are deployed without deleting existing resources that
     are not included in the template. In Complete mode, resources are deployed and existing
     resources in the resource group that are not included in the template are deleted. Be careful
     when using Complete mode as you may unintentionally delete resources. Required. Known values
     are: "Incremental" and "Complete".
    :vartype mode: str or ~azure.mgmt.resource.deployments.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.deployments.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment: ~azure.mgmt.resource.deployments.models.OnErrorDeployment
    :ivar expression_evaluation_options: Specifies whether template expressions are evaluated
     within the scope of the parent template or nested template. Only applicable to nested
     templates. If not specified, default value is outer.
    :vartype expression_evaluation_options:
     ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptions
    :ivar validation_level: The validation level of the deployment. Known values are: "Template",
     "Provider", and "ProviderNoRbac".
    :vartype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "TemplateLink"},
        "parameters": {"key": "parameters", "type": "{DeploymentParameter}"},
        "external_inputs": {"key": "externalInputs", "type": "{DeploymentExternalInput}"},
        "external_input_definitions": {
            "key": "externalInputDefinitions",
            "type": "{DeploymentExternalInputDefinition}",
        },
        "parameters_link": {"key": "parametersLink", "type": "ParametersLink"},
        "extension_configs": {"key": "extensionConfigs", "type": "{{DeploymentExtensionConfigItem}}"},
        "mode": {"key": "mode", "type": "str"},
        "debug_setting": {"key": "debugSetting", "type": "DebugSetting"},
        "on_error_deployment": {"key": "onErrorDeployment", "type": "OnErrorDeployment"},
        "expression_evaluation_options": {"key": "expressionEvaluationOptions", "type": "ExpressionEvaluationOptions"},
        "validation_level": {"key": "validationLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.DeploymentMode"],
        template: Optional[JSON] = None,
        template_link: Optional["_models.TemplateLink"] = None,
        parameters: Optional[Dict[str, "_models.DeploymentParameter"]] = None,
        external_inputs: Optional[Dict[str, "_models.DeploymentExternalInput"]] = None,
        external_input_definitions: Optional[Dict[str, "_models.DeploymentExternalInputDefinition"]] = None,
        parameters_link: Optional["_models.ParametersLink"] = None,
        extension_configs: Optional[Dict[str, Dict[str, "_models.DeploymentExtensionConfigItem"]]] = None,
        debug_setting: Optional["_models.DebugSetting"] = None,
        on_error_deployment: Optional["_models.OnErrorDeployment"] = None,
        expression_evaluation_options: Optional["_models.ExpressionEvaluationOptions"] = None,
        validation_level: Optional[Union[str, "_models.ValidationLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link: ~azure.mgmt.resource.deployments.models.TemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. You use this element when you want to provide the parameter values directly in the
         request rather than link to an existing parameter file. Use either the parametersLink property
         or the parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.deployments.models.DeploymentParameter]
        :keyword external_inputs: External input values, used by external tooling for parameter
         evaluation.
        :paramtype external_inputs: dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExternalInput]
        :keyword external_input_definitions: External input definitions, used by external tooling to
         define expected external input values.
        :paramtype external_input_definitions: dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExternalInputDefinition]
        :keyword parameters_link: The URI of parameters file. You use this element to link to an
         existing parameters file. Use either the parametersLink property or the parameters property,
         but not both.
        :paramtype parameters_link: ~azure.mgmt.resource.deployments.models.ParametersLink
        :keyword extension_configs: The configurations to use for deployment extensions. The keys of
         this object are deployment extension aliases as defined in the deployment template.
        :paramtype extension_configs: dict[str, dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExtensionConfigItem]]
        :keyword mode: The mode that is used to deploy resources. This value can be either Incremental
         or Complete. In Incremental mode, resources are deployed without deleting existing resources
         that are not included in the template. In Complete mode, resources are deployed and existing
         resources in the resource group that are not included in the template are deleted. Be careful
         when using Complete mode as you may unintentionally delete resources. Required. Known values
         are: "Incremental" and "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.deployments.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.deployments.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment: ~azure.mgmt.resource.deployments.models.OnErrorDeployment
        :keyword expression_evaluation_options: Specifies whether template expressions are evaluated
         within the scope of the parent template or nested template. Only applicable to nested
         templates. If not specified, default value is outer.
        :paramtype expression_evaluation_options:
         ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptions
        :keyword validation_level: The validation level of the deployment. Known values are:
         "Template", "Provider", and "ProviderNoRbac".
        :paramtype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
        """
        super().__init__(**kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.external_inputs = external_inputs
        self.external_input_definitions = external_input_definitions
        self.parameters_link = parameters_link
        self.extension_configs = extension_configs
        self.mode = mode
        self.debug_setting = debug_setting
        self.on_error_deployment = on_error_deployment
        self.expression_evaluation_options = expression_evaluation_options
        self.validation_level = validation_level


class DeploymentPropertiesExtended(_serialization.Model):
    """Deployment properties with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Denotes the state of provisioning. Known values are: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.resource.deployments.models.ProvisioningState
    :ivar correlation_id: The correlation ID of the deployment.
    :vartype correlation_id: str
    :ivar timestamp: The timestamp of the template deployment.
    :vartype timestamp: ~datetime.datetime
    :ivar duration: The duration of the template deployment.
    :vartype duration: str
    :ivar outputs: Key/value pairs that represent deployment output.
    :vartype outputs: JSON
    :ivar providers: The list of resource providers needed for the deployment.
    :vartype providers: list[~azure.mgmt.resource.deployments.models.Provider]
    :ivar dependencies: The list of deployment dependencies.
    :vartype dependencies: list[~azure.mgmt.resource.deployments.models.Dependency]
    :ivar template_link: The URI referencing the template.
    :vartype template_link: ~azure.mgmt.resource.deployments.models.TemplateLink
    :ivar parameters: Deployment parameters.
    :vartype parameters: JSON
    :ivar parameters_link: The URI referencing the parameters.
    :vartype parameters_link: ~azure.mgmt.resource.deployments.models.ParametersLink
    :ivar extensions: The extensions used in this deployment.
    :vartype extensions:
     list[~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition]
    :ivar mode: The deployment mode. Possible values are Incremental and Complete. Known values
     are: "Incremental" and "Complete".
    :vartype mode: str or ~azure.mgmt.resource.deployments.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.deployments.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment: ~azure.mgmt.resource.deployments.models.OnErrorDeploymentExtended
    :ivar template_hash: The hash produced for the template.
    :vartype template_hash: str
    :ivar output_resources: Array of provisioned resources.
    :vartype output_resources: list[~azure.mgmt.resource.deployments.models.ResourceReference]
    :ivar validated_resources: Array of validated resources.
    :vartype validated_resources: list[~azure.mgmt.resource.deployments.models.ResourceReference]
    :ivar error: The deployment error.
    :vartype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
    :ivar diagnostics: Contains diagnostic information collected during validation process.
    :vartype diagnostics:
     list[~azure.mgmt.resource.deployments.models.DeploymentDiagnosticsDefinition]
    :ivar validation_level: The validation level of the deployment. Known values are: "Template",
     "Provider", and "ProviderNoRbac".
    :vartype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "correlation_id": {"readonly": True},
        "timestamp": {"readonly": True},
        "duration": {"readonly": True},
        "outputs": {"readonly": True},
        "providers": {"readonly": True},
        "dependencies": {"readonly": True},
        "template_link": {"readonly": True},
        "parameters": {"readonly": True},
        "parameters_link": {"readonly": True},
        "extensions": {"readonly": True},
        "mode": {"readonly": True},
        "debug_setting": {"readonly": True},
        "on_error_deployment": {"readonly": True},
        "template_hash": {"readonly": True},
        "output_resources": {"readonly": True},
        "validated_resources": {"readonly": True},
        "error": {"readonly": True},
        "diagnostics": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "str"},
        "outputs": {"key": "outputs", "type": "object"},
        "providers": {"key": "providers", "type": "[Provider]"},
        "dependencies": {"key": "dependencies", "type": "[Dependency]"},
        "template_link": {"key": "templateLink", "type": "TemplateLink"},
        "parameters": {"key": "parameters", "type": "object"},
        "parameters_link": {"key": "parametersLink", "type": "ParametersLink"},
        "extensions": {"key": "extensions", "type": "[DeploymentExtensionDefinition]"},
        "mode": {"key": "mode", "type": "str"},
        "debug_setting": {"key": "debugSetting", "type": "DebugSetting"},
        "on_error_deployment": {"key": "onErrorDeployment", "type": "OnErrorDeploymentExtended"},
        "template_hash": {"key": "templateHash", "type": "str"},
        "output_resources": {"key": "outputResources", "type": "[ResourceReference]"},
        "validated_resources": {"key": "validatedResources", "type": "[ResourceReference]"},
        "error": {"key": "error", "type": "ErrorResponse"},
        "diagnostics": {"key": "diagnostics", "type": "[DeploymentDiagnosticsDefinition]"},
        "validation_level": {"key": "validationLevel", "type": "str"},
    }

    def __init__(
        self, *, validation_level: Optional[Union[str, "_models.ValidationLevel"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword validation_level: The validation level of the deployment. Known values are:
         "Template", "Provider", and "ProviderNoRbac".
        :paramtype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.correlation_id: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.duration: Optional[str] = None
        self.outputs: Optional[JSON] = None
        self.providers: Optional[List["_models.Provider"]] = None
        self.dependencies: Optional[List["_models.Dependency"]] = None
        self.template_link: Optional["_models.TemplateLink"] = None
        self.parameters: Optional[JSON] = None
        self.parameters_link: Optional["_models.ParametersLink"] = None
        self.extensions: Optional[List["_models.DeploymentExtensionDefinition"]] = None
        self.mode: Optional[Union[str, "_models.DeploymentMode"]] = None
        self.debug_setting: Optional["_models.DebugSetting"] = None
        self.on_error_deployment: Optional["_models.OnErrorDeploymentExtended"] = None
        self.template_hash: Optional[str] = None
        self.output_resources: Optional[List["_models.ResourceReference"]] = None
        self.validated_resources: Optional[List["_models.ResourceReference"]] = None
        self.error: Optional["_models.ErrorResponse"] = None
        self.diagnostics: Optional[List["_models.DeploymentDiagnosticsDefinition"]] = None
        self.validation_level = validation_level


class DeploymentValidateResult(_serialization.Model):
    """Information from validate template deployment response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The deployment validation error.
    :vartype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
    :ivar id: The ID of the deployment.
    :vartype id: str
    :ivar name: The name of the deployment.
    :vartype name: str
    :ivar type: The type of the deployment.
    :vartype type: str
    :ivar properties: The template deployment properties.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentPropertiesExtended
    """

    _validation = {
        "error": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentPropertiesExtended"},
    }

    def __init__(self, *, properties: Optional["_models.DeploymentPropertiesExtended"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The template deployment properties.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentPropertiesExtended
        """
        super().__init__(**kwargs)
        self.error: Optional["_models.ErrorResponse"] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties


class DeploymentWhatIf(_serialization.Model):
    """Deployment What-if operation parameters.

    All required parameters must be populated in order to send to server.

    :ivar location: The location to store the deployment data.
    :vartype location: str
    :ivar properties: The deployment properties. Required.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentWhatIfProperties"},
    }

    def __init__(
        self, *, properties: "_models.DeploymentWhatIfProperties", location: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: The location to store the deployment data.
        :paramtype location: str
        :keyword properties: The deployment properties. Required.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties


class DeploymentWhatIfProperties(DeploymentProperties):
    """Deployment What-if properties.

    All required parameters must be populated in order to send to server.

    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link: ~azure.mgmt.resource.deployments.models.TemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     You use this element when you want to provide the parameter values directly in the request
     rather than link to an existing parameter file. Use either the parametersLink property or the
     parameters property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: dict[str, ~azure.mgmt.resource.deployments.models.DeploymentParameter]
    :ivar external_inputs: External input values, used by external tooling for parameter
     evaluation.
    :vartype external_inputs: dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExternalInput]
    :ivar external_input_definitions: External input definitions, used by external tooling to
     define expected external input values.
    :vartype external_input_definitions: dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExternalInputDefinition]
    :ivar parameters_link: The URI of parameters file. You use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link: ~azure.mgmt.resource.deployments.models.ParametersLink
    :ivar extension_configs: The configurations to use for deployment extensions. The keys of this
     object are deployment extension aliases as defined in the deployment template.
    :vartype extension_configs: dict[str, dict[str,
     ~azure.mgmt.resource.deployments.models.DeploymentExtensionConfigItem]]
    :ivar mode: The mode that is used to deploy resources. This value can be either Incremental or
     Complete. In Incremental mode, resources are deployed without deleting existing resources that
     are not included in the template. In Complete mode, resources are deployed and existing
     resources in the resource group that are not included in the template are deleted. Be careful
     when using Complete mode as you may unintentionally delete resources. Required. Known values
     are: "Incremental" and "Complete".
    :vartype mode: str or ~azure.mgmt.resource.deployments.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.deployments.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment: ~azure.mgmt.resource.deployments.models.OnErrorDeployment
    :ivar expression_evaluation_options: Specifies whether template expressions are evaluated
     within the scope of the parent template or nested template. Only applicable to nested
     templates. If not specified, default value is outer.
    :vartype expression_evaluation_options:
     ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptions
    :ivar validation_level: The validation level of the deployment. Known values are: "Template",
     "Provider", and "ProviderNoRbac".
    :vartype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
    :ivar what_if_settings: Optional What-If operation settings.
    :vartype what_if_settings: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfSettings
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "TemplateLink"},
        "parameters": {"key": "parameters", "type": "{DeploymentParameter}"},
        "external_inputs": {"key": "externalInputs", "type": "{DeploymentExternalInput}"},
        "external_input_definitions": {
            "key": "externalInputDefinitions",
            "type": "{DeploymentExternalInputDefinition}",
        },
        "parameters_link": {"key": "parametersLink", "type": "ParametersLink"},
        "extension_configs": {"key": "extensionConfigs", "type": "{{DeploymentExtensionConfigItem}}"},
        "mode": {"key": "mode", "type": "str"},
        "debug_setting": {"key": "debugSetting", "type": "DebugSetting"},
        "on_error_deployment": {"key": "onErrorDeployment", "type": "OnErrorDeployment"},
        "expression_evaluation_options": {"key": "expressionEvaluationOptions", "type": "ExpressionEvaluationOptions"},
        "validation_level": {"key": "validationLevel", "type": "str"},
        "what_if_settings": {"key": "whatIfSettings", "type": "DeploymentWhatIfSettings"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.DeploymentMode"],
        template: Optional[JSON] = None,
        template_link: Optional["_models.TemplateLink"] = None,
        parameters: Optional[Dict[str, "_models.DeploymentParameter"]] = None,
        external_inputs: Optional[Dict[str, "_models.DeploymentExternalInput"]] = None,
        external_input_definitions: Optional[Dict[str, "_models.DeploymentExternalInputDefinition"]] = None,
        parameters_link: Optional["_models.ParametersLink"] = None,
        extension_configs: Optional[Dict[str, Dict[str, "_models.DeploymentExtensionConfigItem"]]] = None,
        debug_setting: Optional["_models.DebugSetting"] = None,
        on_error_deployment: Optional["_models.OnErrorDeployment"] = None,
        expression_evaluation_options: Optional["_models.ExpressionEvaluationOptions"] = None,
        validation_level: Optional[Union[str, "_models.ValidationLevel"]] = None,
        what_if_settings: Optional["_models.DeploymentWhatIfSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link: ~azure.mgmt.resource.deployments.models.TemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. You use this element when you want to provide the parameter values directly in the
         request rather than link to an existing parameter file. Use either the parametersLink property
         or the parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.deployments.models.DeploymentParameter]
        :keyword external_inputs: External input values, used by external tooling for parameter
         evaluation.
        :paramtype external_inputs: dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExternalInput]
        :keyword external_input_definitions: External input definitions, used by external tooling to
         define expected external input values.
        :paramtype external_input_definitions: dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExternalInputDefinition]
        :keyword parameters_link: The URI of parameters file. You use this element to link to an
         existing parameters file. Use either the parametersLink property or the parameters property,
         but not both.
        :paramtype parameters_link: ~azure.mgmt.resource.deployments.models.ParametersLink
        :keyword extension_configs: The configurations to use for deployment extensions. The keys of
         this object are deployment extension aliases as defined in the deployment template.
        :paramtype extension_configs: dict[str, dict[str,
         ~azure.mgmt.resource.deployments.models.DeploymentExtensionConfigItem]]
        :keyword mode: The mode that is used to deploy resources. This value can be either Incremental
         or Complete. In Incremental mode, resources are deployed without deleting existing resources
         that are not included in the template. In Complete mode, resources are deployed and existing
         resources in the resource group that are not included in the template are deleted. Be careful
         when using Complete mode as you may unintentionally delete resources. Required. Known values
         are: "Incremental" and "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.deployments.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.deployments.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment: ~azure.mgmt.resource.deployments.models.OnErrorDeployment
        :keyword expression_evaluation_options: Specifies whether template expressions are evaluated
         within the scope of the parent template or nested template. Only applicable to nested
         templates. If not specified, default value is outer.
        :paramtype expression_evaluation_options:
         ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptions
        :keyword validation_level: The validation level of the deployment. Known values are:
         "Template", "Provider", and "ProviderNoRbac".
        :paramtype validation_level: str or ~azure.mgmt.resource.deployments.models.ValidationLevel
        :keyword what_if_settings: Optional What-If operation settings.
        :paramtype what_if_settings: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfSettings
        """
        super().__init__(
            template=template,
            template_link=template_link,
            parameters=parameters,
            external_inputs=external_inputs,
            external_input_definitions=external_input_definitions,
            parameters_link=parameters_link,
            extension_configs=extension_configs,
            mode=mode,
            debug_setting=debug_setting,
            on_error_deployment=on_error_deployment,
            expression_evaluation_options=expression_evaluation_options,
            validation_level=validation_level,
            **kwargs
        )
        self.what_if_settings = what_if_settings


class DeploymentWhatIfSettings(_serialization.Model):
    """Deployment What-If operation settings.

    :ivar result_format: The format of the What-If results. Known values are: "ResourceIdOnly" and
     "FullResourcePayloads".
    :vartype result_format: str or ~azure.mgmt.resource.deployments.models.WhatIfResultFormat
    """

    _attribute_map = {
        "result_format": {"key": "resultFormat", "type": "str"},
    }

    def __init__(
        self, *, result_format: Optional[Union[str, "_models.WhatIfResultFormat"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword result_format: The format of the What-If results. Known values are: "ResourceIdOnly"
         and "FullResourcePayloads".
        :paramtype result_format: str or ~azure.mgmt.resource.deployments.models.WhatIfResultFormat
        """
        super().__init__(**kwargs)
        self.result_format = result_format


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.deployments.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.deployments.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorResponse"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ExpressionEvaluationOptions(_serialization.Model):
    """Specifies whether template expressions are evaluated within the scope of the parent template or
    nested template.

    :ivar scope: The scope to be used for evaluation of parameters, variables and functions in a
     nested template. Known values are: "NotSpecified", "Outer", and "Inner".
    :vartype scope: str or
     ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptionsScopeType
    """

    _attribute_map = {
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self, *, scope: Optional[Union[str, "_models.ExpressionEvaluationOptionsScopeType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword scope: The scope to be used for evaluation of parameters, variables and functions in a
         nested template. Known values are: "NotSpecified", "Outer", and "Inner".
        :paramtype scope: str or
         ~azure.mgmt.resource.deployments.models.ExpressionEvaluationOptionsScopeType
        """
        super().__init__(**kwargs)
        self.scope = scope


class HttpMessage(_serialization.Model):
    """HTTP message.

    :ivar content: HTTP message content.
    :vartype content: JSON
    """

    _attribute_map = {
        "content": {"key": "content", "type": "object"},
    }

    def __init__(self, *, content: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword content: HTTP message content.
        :paramtype content: JSON
        """
        super().__init__(**kwargs)
        self.content = content


class KeyVaultParameterReference(_serialization.Model):
    """Azure Key Vault parameter reference.

    All required parameters must be populated in order to send to server.

    :ivar key_vault: Azure Key Vault reference. Required.
    :vartype key_vault: ~azure.mgmt.resource.deployments.models.KeyVaultReference
    :ivar secret_name: Azure Key Vault secret name. Required.
    :vartype secret_name: str
    :ivar secret_version: Azure Key Vault secret version.
    :vartype secret_version: str
    """

    _validation = {
        "key_vault": {"required": True},
        "secret_name": {"required": True},
    }

    _attribute_map = {
        "key_vault": {"key": "keyVault", "type": "KeyVaultReference"},
        "secret_name": {"key": "secretName", "type": "str"},
        "secret_version": {"key": "secretVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault: "_models.KeyVaultReference",
        secret_name: str,
        secret_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault: Azure Key Vault reference. Required.
        :paramtype key_vault: ~azure.mgmt.resource.deployments.models.KeyVaultReference
        :keyword secret_name: Azure Key Vault secret name. Required.
        :paramtype secret_name: str
        :keyword secret_version: Azure Key Vault secret version.
        :paramtype secret_version: str
        """
        super().__init__(**kwargs)
        self.key_vault = key_vault
        self.secret_name = secret_name
        self.secret_version = secret_version


class KeyVaultReference(_serialization.Model):
    """Azure Key Vault reference.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure Key Vault resource id. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Key Vault resource id. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class OnErrorDeployment(_serialization.Model):
    """Deployment on error behavior.

    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.deployments.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.deployment_name = deployment_name


class OnErrorDeploymentExtended(_serialization.Model):
    """Deployment on error behavior with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The state of the provisioning for the on error deployment.
    :vartype provisioning_state: str
    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.deployments.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.deployments.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None
        self.type = type
        self.deployment_name = deployment_name


class ParametersLink(_serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to server.

    :ivar uri: The URI of the parameters file. Required.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(self, *, uri: str, content_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of the parameters file. Required.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class Provider(_serialization.Model):
    """Resource provider information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The provider ID.
    :vartype id: str
    :ivar namespace: The namespace of the resource provider.
    :vartype namespace: str
    :ivar registration_state: The registration state of the resource provider.
    :vartype registration_state: str
    :ivar registration_policy: The registration policy of the resource provider.
    :vartype registration_policy: str
    :ivar resource_types: The collection of provider resource types.
    :vartype resource_types: list[~azure.mgmt.resource.deployments.models.ProviderResourceType]
    :ivar provider_authorization_consent_state: The provider authorization consent state. Known
     values are: "NotSpecified", "Required", "NotRequired", and "Consented".
    :vartype provider_authorization_consent_state: str or
     ~azure.mgmt.resource.deployments.models.ProviderAuthorizationConsentState
    """

    _validation = {
        "id": {"readonly": True},
        "registration_state": {"readonly": True},
        "registration_policy": {"readonly": True},
        "resource_types": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "registration_state": {"key": "registrationState", "type": "str"},
        "registration_policy": {"key": "registrationPolicy", "type": "str"},
        "resource_types": {"key": "resourceTypes", "type": "[ProviderResourceType]"},
        "provider_authorization_consent_state": {"key": "providerAuthorizationConsentState", "type": "str"},
    }

    def __init__(
        self,
        *,
        namespace: Optional[str] = None,
        provider_authorization_consent_state: Optional[Union[str, "_models.ProviderAuthorizationConsentState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword namespace: The namespace of the resource provider.
        :paramtype namespace: str
        :keyword provider_authorization_consent_state: The provider authorization consent state. Known
         values are: "NotSpecified", "Required", "NotRequired", and "Consented".
        :paramtype provider_authorization_consent_state: str or
         ~azure.mgmt.resource.deployments.models.ProviderAuthorizationConsentState
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.namespace = namespace
        self.registration_state: Optional[str] = None
        self.registration_policy: Optional[str] = None
        self.resource_types: Optional[List["_models.ProviderResourceType"]] = None
        self.provider_authorization_consent_state = provider_authorization_consent_state


class ProviderExtendedLocation(_serialization.Model):
    """The provider extended location.

    :ivar location: The azure location.
    :vartype location: str
    :ivar type: The extended location type.
    :vartype type: str
    :ivar extended_locations: The extended locations for the azure location.
    :vartype extended_locations: list[str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "extended_locations": {"key": "extendedLocations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        type: Optional[str] = None,
        extended_locations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The azure location.
        :paramtype location: str
        :keyword type: The extended location type.
        :paramtype type: str
        :keyword extended_locations: The extended locations for the azure location.
        :paramtype extended_locations: list[str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.type = type
        self.extended_locations = extended_locations


class ProviderResourceType(_serialization.Model):
    """Resource type managed by the resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar locations: The collection of locations where this resource type can be created.
    :vartype locations: list[str]
    :ivar location_mappings: The location mappings that are supported by this resource type.
    :vartype location_mappings:
     list[~azure.mgmt.resource.deployments.models.ProviderExtendedLocation]
    :ivar aliases: The aliases that are supported by this resource type.
    :vartype aliases: list[~azure.mgmt.resource.deployments.models.Alias]
    :ivar api_versions: The API version.
    :vartype api_versions: list[str]
    :ivar default_api_version: The default API version.
    :vartype default_api_version: str
    :ivar zone_mappings:
    :vartype zone_mappings: list[~azure.mgmt.resource.deployments.models.ZoneMapping]
    :ivar api_profiles: The API profiles for the resource provider.
    :vartype api_profiles: list[~azure.mgmt.resource.deployments.models.ApiProfile]
    :ivar capabilities: The additional capabilities offered by this resource type.
    :vartype capabilities: str
    :ivar properties: The properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "default_api_version": {"readonly": True},
        "api_profiles": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_mappings": {"key": "locationMappings", "type": "[ProviderExtendedLocation]"},
        "aliases": {"key": "aliases", "type": "[Alias]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "default_api_version": {"key": "defaultApiVersion", "type": "str"},
        "zone_mappings": {"key": "zoneMappings", "type": "[ZoneMapping]"},
        "api_profiles": {"key": "apiProfiles", "type": "[ApiProfile]"},
        "capabilities": {"key": "capabilities", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        location_mappings: Optional[List["_models.ProviderExtendedLocation"]] = None,
        aliases: Optional[List["_models.Alias"]] = None,
        api_versions: Optional[List[str]] = None,
        zone_mappings: Optional[List["_models.ZoneMapping"]] = None,
        capabilities: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword locations: The collection of locations where this resource type can be created.
        :paramtype locations: list[str]
        :keyword location_mappings: The location mappings that are supported by this resource type.
        :paramtype location_mappings:
         list[~azure.mgmt.resource.deployments.models.ProviderExtendedLocation]
        :keyword aliases: The aliases that are supported by this resource type.
        :paramtype aliases: list[~azure.mgmt.resource.deployments.models.Alias]
        :keyword api_versions: The API version.
        :paramtype api_versions: list[str]
        :keyword zone_mappings:
        :paramtype zone_mappings: list[~azure.mgmt.resource.deployments.models.ZoneMapping]
        :keyword capabilities: The additional capabilities offered by this resource type.
        :paramtype capabilities: str
        :keyword properties: The properties.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.locations = locations
        self.location_mappings = location_mappings
        self.aliases = aliases
        self.api_versions = api_versions
        self.default_api_version: Optional[str] = None
        self.zone_mappings = zone_mappings
        self.api_profiles: Optional[List["_models.ApiProfile"]] = None
        self.capabilities = capabilities
        self.properties = properties


class ResourceProviderOperationDisplayProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Resource provider operation's display properties.

    :ivar publisher: Operation description.
    :vartype publisher: str
    :ivar provider: Operation provider.
    :vartype provider: str
    :ivar resource: Operation resource.
    :vartype resource: str
    :ivar operation: Resource provider operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: Operation description.
        :paramtype publisher: str
        :keyword provider: Operation provider.
        :paramtype provider: str
        :keyword resource: Operation resource.
        :paramtype resource: str
        :keyword operation: Resource provider operation.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceReference(_serialization.Model):
    """The resource Id model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified Azure resource ID.
    :vartype id: str
    :ivar extension: The extension the resource was deployed with.
    :vartype extension: ~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition
    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar identifiers: The extensible resource identifiers.
    :vartype identifiers: JSON
    :ivar api_version: The API version the resource was deployed with.
    :vartype api_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "extension": {"readonly": True},
        "resource_type": {"readonly": True},
        "identifiers": {"readonly": True},
        "api_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "extension": {"key": "extension", "type": "DeploymentExtensionDefinition"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "identifiers": {"key": "identifiers", "type": "object"},
        "api_version": {"key": "apiVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.extension: Optional["_models.DeploymentExtensionDefinition"] = None
        self.resource_type: Optional[str] = None
        self.identifiers: Optional[JSON] = None
        self.api_version: Optional[str] = None


class ScopedDeployment(_serialization.Model):
    """Deployment operation parameters.

    All required parameters must be populated in order to send to server.

    :ivar location: The location to store the deployment data. Required.
    :vartype location: str
    :ivar properties: The deployment properties. Required.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentProperties
    :ivar tags: Deployment tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "_models.DeploymentProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location to store the deployment data. Required.
        :paramtype location: str
        :keyword properties: The deployment properties. Required.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentProperties
        :keyword tags: Deployment tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties
        self.tags = tags


class ScopedDeploymentWhatIf(_serialization.Model):
    """Deployment What-if operation parameters.

    All required parameters must be populated in order to send to server.

    :ivar location: The location to store the deployment data. Required.
    :vartype location: str
    :ivar properties: The deployment properties. Required.
    :vartype properties: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfProperties
    """

    _validation = {
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentWhatIfProperties"},
    }

    def __init__(self, *, location: str, properties: "_models.DeploymentWhatIfProperties", **kwargs: Any) -> None:
        """
        :keyword location: The location to store the deployment data. Required.
        :paramtype location: str
        :keyword properties: The deployment properties. Required.
        :paramtype properties: ~azure.mgmt.resource.deployments.models.DeploymentWhatIfProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties


class StatusMessage(_serialization.Model):
    """Operation status message object.

    :ivar status: Status of the deployment operation.
    :vartype status: str
    :ivar error: The error reported by the operation.
    :vartype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(
        self, *, status: Optional[str] = None, error: Optional["_models.ErrorResponse"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the deployment operation.
        :paramtype status: str
        :keyword error: The error reported by the operation.
        :paramtype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class SubResource(_serialization.Model):
    """Sub-resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class TargetResource(_serialization.Model):
    """Target resource.

    :ivar id: The Azure resource ID of the resource.
    :vartype id: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar extension: The extension the resource was deployed with.
    :vartype extension: ~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition
    :ivar identifiers: The extensible resource identifiers.
    :vartype identifiers: JSON
    :ivar api_version: The API version the resource was deployed with.
    :vartype api_version: str
    :ivar symbolic_name: The symbolic name of the resource as defined in the deployment template.
    :vartype symbolic_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "extension": {"key": "extension", "type": "DeploymentExtensionDefinition"},
        "identifiers": {"key": "identifiers", "type": "object"},
        "api_version": {"key": "apiVersion", "type": "str"},
        "symbolic_name": {"key": "symbolicName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        extension: Optional["_models.DeploymentExtensionDefinition"] = None,
        identifiers: Optional[JSON] = None,
        api_version: Optional[str] = None,
        symbolic_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The Azure resource ID of the resource.
        :paramtype id: str
        :keyword resource_name: The name of the resource.
        :paramtype resource_name: str
        :keyword resource_type: The type of the resource.
        :paramtype resource_type: str
        :keyword extension: The extension the resource was deployed with.
        :paramtype extension: ~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition
        :keyword identifiers: The extensible resource identifiers.
        :paramtype identifiers: JSON
        :keyword api_version: The API version the resource was deployed with.
        :paramtype api_version: str
        :keyword symbolic_name: The symbolic name of the resource as defined in the deployment
         template.
        :paramtype symbolic_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_name = resource_name
        self.resource_type = resource_type
        self.extension = extension
        self.identifiers = identifiers
        self.api_version = api_version
        self.symbolic_name = symbolic_name


class TemplateHashResult(_serialization.Model):
    """Result of the request to calculate template hash. It contains a string of minified template and
    its hash.

    :ivar minified_template: The minified template string.
    :vartype minified_template: str
    :ivar template_hash: The template hash.
    :vartype template_hash: str
    """

    _attribute_map = {
        "minified_template": {"key": "minifiedTemplate", "type": "str"},
        "template_hash": {"key": "templateHash", "type": "str"},
    }

    def __init__(
        self, *, minified_template: Optional[str] = None, template_hash: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword minified_template: The minified template string.
        :paramtype minified_template: str
        :keyword template_hash: The template hash.
        :paramtype template_hash: str
        """
        super().__init__(**kwargs)
        self.minified_template = minified_template
        self.template_hash = template_hash


class TemplateLink(_serialization.Model):
    """Entity representing the reference to the template.

    :ivar uri: The URI of the template to deploy. Use either the uri or id property, but not both.
    :vartype uri: str
    :ivar id: The resource id of a Template Spec. Use either the id or uri property, but not both.
    :vartype id: str
    :ivar relative_path: The relativePath property can be used to deploy a linked template at a
     location relative to the parent. If the parent template was linked with a TemplateSpec, this
     will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
     deployment will be a combination of the parent and relativePath URIs.
    :vartype relative_path: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    :ivar query_string: The query string (for example, a SAS token) to be used with the
     templateLink URI.
    :vartype query_string: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
        "query_string": {"key": "queryString", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        relative_path: Optional[str] = None,
        content_version: Optional[str] = None,
        query_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uri: The URI of the template to deploy. Use either the uri or id property, but not
         both.
        :paramtype uri: str
        :keyword id: The resource id of a Template Spec. Use either the id or uri property, but not
         both.
        :paramtype id: str
        :keyword relative_path: The relativePath property can be used to deploy a linked template at a
         location relative to the parent. If the parent template was linked with a TemplateSpec, this
         will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
         deployment will be a combination of the parent and relativePath URIs.
        :paramtype relative_path: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        :keyword query_string: The query string (for example, a SAS token) to be used with the
         templateLink URI.
        :paramtype query_string: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.id = id
        self.relative_path = relative_path
        self.content_version = content_version
        self.query_string = query_string


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class WhatIfChange(_serialization.Model):
    """Information about a single resource change predicted by What-If operation.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    :ivar deployment_id: The resource id of the Deployment responsible for this change.
    :vartype deployment_id: str
    :ivar symbolic_name: The symbolic name of the resource responsible for this change.
    :vartype symbolic_name: str
    :ivar identifiers: A subset of properties that uniquely identify a Bicep extensible resource
     because it lacks a resource id like an Azure resource has.
    :vartype identifiers: JSON
    :ivar extension: The extension the resource was deployed with.
    :vartype extension: ~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition
    :ivar change_type: Type of change that will be made to the resource when the deployment is
     executed. Required. Known values are: "Create", "Delete", "Ignore", "Deploy", "NoChange",
     "Modify", and "Unsupported".
    :vartype change_type: str or ~azure.mgmt.resource.deployments.models.ChangeType
    :ivar unsupported_reason: The explanation about why the resource is unsupported by What-If.
    :vartype unsupported_reason: str
    :ivar before: The snapshot of the resource before the deployment is executed.
    :vartype before: JSON
    :ivar after: The predicted snapshot of the resource after the deployment is executed.
    :vartype after: JSON
    :ivar delta: The predicted changes to resource properties.
    :vartype delta: list[~azure.mgmt.resource.deployments.models.WhatIfPropertyChange]
    """

    _validation = {
        "change_type": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "symbolic_name": {"key": "symbolicName", "type": "str"},
        "identifiers": {"key": "identifiers", "type": "object"},
        "extension": {"key": "extension", "type": "DeploymentExtensionDefinition"},
        "change_type": {"key": "changeType", "type": "str"},
        "unsupported_reason": {"key": "unsupportedReason", "type": "str"},
        "before": {"key": "before", "type": "object"},
        "after": {"key": "after", "type": "object"},
        "delta": {"key": "delta", "type": "[WhatIfPropertyChange]"},
    }

    def __init__(
        self,
        *,
        change_type: Union[str, "_models.ChangeType"],
        resource_id: Optional[str] = None,
        deployment_id: Optional[str] = None,
        symbolic_name: Optional[str] = None,
        identifiers: Optional[JSON] = None,
        extension: Optional["_models.DeploymentExtensionDefinition"] = None,
        unsupported_reason: Optional[str] = None,
        before: Optional[JSON] = None,
        after: Optional[JSON] = None,
        delta: Optional[List["_models.WhatIfPropertyChange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Resource ID.
        :paramtype resource_id: str
        :keyword deployment_id: The resource id of the Deployment responsible for this change.
        :paramtype deployment_id: str
        :keyword symbolic_name: The symbolic name of the resource responsible for this change.
        :paramtype symbolic_name: str
        :keyword identifiers: A subset of properties that uniquely identify a Bicep extensible resource
         because it lacks a resource id like an Azure resource has.
        :paramtype identifiers: JSON
        :keyword extension: The extension the resource was deployed with.
        :paramtype extension: ~azure.mgmt.resource.deployments.models.DeploymentExtensionDefinition
        :keyword change_type: Type of change that will be made to the resource when the deployment is
         executed. Required. Known values are: "Create", "Delete", "Ignore", "Deploy", "NoChange",
         "Modify", and "Unsupported".
        :paramtype change_type: str or ~azure.mgmt.resource.deployments.models.ChangeType
        :keyword unsupported_reason: The explanation about why the resource is unsupported by What-If.
        :paramtype unsupported_reason: str
        :keyword before: The snapshot of the resource before the deployment is executed.
        :paramtype before: JSON
        :keyword after: The predicted snapshot of the resource after the deployment is executed.
        :paramtype after: JSON
        :keyword delta: The predicted changes to resource properties.
        :paramtype delta: list[~azure.mgmt.resource.deployments.models.WhatIfPropertyChange]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.deployment_id = deployment_id
        self.symbolic_name = symbolic_name
        self.identifiers = identifiers
        self.extension = extension
        self.change_type = change_type
        self.unsupported_reason = unsupported_reason
        self.before = before
        self.after = after
        self.delta = delta


class WhatIfOperationResult(_serialization.Model):
    """Result of the What-If operation. Contains a list of predicted changes and a URL link to get to
    the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Status of the What-If operation.
    :vartype status: str
    :ivar error: Error when What-If operation fails.
    :vartype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
    :ivar changes: List of resource changes predicted by What-If operation.
    :vartype changes: list[~azure.mgmt.resource.deployments.models.WhatIfChange]
    :ivar potential_changes: List of resource changes predicted by What-If operation.
    :vartype potential_changes: list[~azure.mgmt.resource.deployments.models.WhatIfChange]
    :ivar diagnostics: List of resource diagnostics detected by What-If operation.
    :vartype diagnostics:
     list[~azure.mgmt.resource.deployments.models.DeploymentDiagnosticsDefinition]
    """

    _validation = {
        "diagnostics": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorResponse"},
        "changes": {"key": "properties.changes", "type": "[WhatIfChange]"},
        "potential_changes": {"key": "properties.potentialChanges", "type": "[WhatIfChange]"},
        "diagnostics": {"key": "properties.diagnostics", "type": "[DeploymentDiagnosticsDefinition]"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error: Optional["_models.ErrorResponse"] = None,
        changes: Optional[List["_models.WhatIfChange"]] = None,
        potential_changes: Optional[List["_models.WhatIfChange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the What-If operation.
        :paramtype status: str
        :keyword error: Error when What-If operation fails.
        :paramtype error: ~azure.mgmt.resource.deployments.models.ErrorResponse
        :keyword changes: List of resource changes predicted by What-If operation.
        :paramtype changes: list[~azure.mgmt.resource.deployments.models.WhatIfChange]
        :keyword potential_changes: List of resource changes predicted by What-If operation.
        :paramtype potential_changes: list[~azure.mgmt.resource.deployments.models.WhatIfChange]
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error
        self.changes = changes
        self.potential_changes = potential_changes
        self.diagnostics: Optional[List["_models.DeploymentDiagnosticsDefinition"]] = None


class WhatIfPropertyChange(_serialization.Model):
    """The predicted change to the resource property.

    All required parameters must be populated in order to send to server.

    :ivar path: The path of the property. Required.
    :vartype path: str
    :ivar property_change_type: The type of property change. Required. Known values are: "Create",
     "Delete", "Modify", "Array", and "NoEffect".
    :vartype property_change_type: str or
     ~azure.mgmt.resource.deployments.models.PropertyChangeType
    :ivar before: The value of the property before the deployment is executed.
    :vartype before: JSON
    :ivar after: The value of the property after the deployment is executed.
    :vartype after: JSON
    :ivar children: Nested property changes.
    :vartype children: list[~azure.mgmt.resource.deployments.models.WhatIfPropertyChange]
    """

    _validation = {
        "path": {"required": True},
        "property_change_type": {"required": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "property_change_type": {"key": "propertyChangeType", "type": "str"},
        "before": {"key": "before", "type": "object"},
        "after": {"key": "after", "type": "object"},
        "children": {"key": "children", "type": "[WhatIfPropertyChange]"},
    }

    def __init__(
        self,
        *,
        path: str,
        property_change_type: Union[str, "_models.PropertyChangeType"],
        before: Optional[JSON] = None,
        after: Optional[JSON] = None,
        children: Optional[List["_models.WhatIfPropertyChange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path of the property. Required.
        :paramtype path: str
        :keyword property_change_type: The type of property change. Required. Known values are:
         "Create", "Delete", "Modify", "Array", and "NoEffect".
        :paramtype property_change_type: str or
         ~azure.mgmt.resource.deployments.models.PropertyChangeType
        :keyword before: The value of the property before the deployment is executed.
        :paramtype before: JSON
        :keyword after: The value of the property after the deployment is executed.
        :paramtype after: JSON
        :keyword children: Nested property changes.
        :paramtype children: list[~azure.mgmt.resource.deployments.models.WhatIfPropertyChange]
        """
        super().__init__(**kwargs)
        self.path = path
        self.property_change_type = property_change_type
        self.before = before
        self.after = after
        self.children = children


class ZoneMapping(_serialization.Model):
    """ZoneMapping.

    :ivar location: The location of the zone mapping.
    :vartype location: str
    :ivar zones:
    :vartype zones: list[str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, *, location: Optional[str] = None, zones: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the zone mapping.
        :paramtype location: str
        :keyword zones:
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.zones = zones
