# File: makefile.defs.linux.pulse-clang.BE
# System: Linux
# David Weenink and Paul Boersma, 29 December 2025

CC = clang
CXX = clang
LINK = $(CXX)

PKG_CONFIG ?= pkg-config

COMMONFLAGS = -DUNIX -Dlinux -DALSA -DJACK -DHAVE_PULSEAUDIO \
	-DWORDS_BIGENDIAN=1 -DPA_BIG_ENDIAN \
	-D_FILE_OFFSET_BITS=64 `$(PKG_CONFIG) --cflags gtk+-3.0` \
	-Wreturn-type -Wunused -Wunused-parameter -Wuninitialized -O3 -g1 -pthread

CFLAGS = -std=gnu99 $(COMMONFLAGS) -Werror=missing-prototypes -Werror=implicit

# This one works for the Praat team:
CXXFLAGS = -std=c++17 $(COMMONFLAGS) -stdlib=libc++ -Wshadow
# Some others have been tried by others:
#CXXFLAGS = -std=c++17 $(COMMONFLAGS) -Wshadow
#CXXFLAGS = -std=c++17 $(COMMONFLAGS) -stdlib=libstdc++ -Wshadow

EXECUTABLE = praat

#LIBS = `$(PKG_CONFIG) --libs gtk+-3.0` -no-pie -lm -lpulse -lasound -ljack -lpthread
LIBS = `$(PKG_CONFIG) --libs gtk+-3.0 jack` -no-pie -lc++ -lm -lpulse -lasound -lpthread
#LIBS = `$(PKG_CONFIG) --libs gtk+-3.0` -no-pie -lc++ -lc++abi -lm -lpulse -lasound -ljack -lpthread
#LIBS = `$(PKG_CONFIG) --libs gtk+-3.0` -no-pie -lm -lpulse -lasound -ljack -lpthread /usr/lib/llvm-10/lib/libc++.a /usr/lib/llvm-10/lib/libc++abi.a 
#LIBS = `$(PKG_CONFIG) --libs gtk+-3.0` -no-pie -Wl,-Bstatic ~/libunwind/unpacked/usr/lib/aarch64-linux-gnu/libunwind.a -Wl,-Bdynamic -lc++ -lm -lpulse -lasound -ljack -lpthread

AR = ar
RANLIB = ls
ICON =
MAIN_ICON =

INSTALL = install -p praat /usr/local/bin
