#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "RK1Reader.h"
#include "BaseCommunication.h"

#include "memory_placements.h"


#define base CRFKReader

CRK1Reader::CRK1Reader(CReader *Owner,CBaseCommunication *Communicator)
			  :base(Owner,Communicator)
{}

CRK1Reader::~CRK1Reader(void)
{
}

/*
CJ_RESULT CRK1Reader::BuildReaderInfo()
{
	CJ_RESULT Res;

	Res = base::BuildReaderInfo();

	m_ReaderInfo.HardwareMask |= RSCT_READER_HARDWARE_MASK_BUZZER |
		RSCT_READER_HARDWARE_MASK_DISPLAY_ONOFF |
		RSCT_READER_HARDWARE_MASK_PACE |
		RSCT_READER_HARDWARE_MASK_BACKLIGHT |
		RSCT_READER_HARDWARE_MASK_CONTRAST;

	return Res;
}
*/
void CRK1Reader::SetNFCSpeedLimit()
{
	uint32_t l = 1;
	uint8_t s = (uint8_t)GetEnviroment("NFCSpeedLimit", 0xff);
	Escape(MODULE_ID_KERNEL, CCID_ESCAPE_NFC_SPEED_LIMIT, &s, 1, NULL, &s, &l);// Fire and forgot
}


void CRK1Reader::SetHWString(char *String)
{
	SetNFCSpeedLimit();
    strcpy(String,"RK1_");
}

void CRK1Reader::GetProductString(uint8_t *Product)
{
	memcpy(Product,"CJRK1",5);
}

//CJ_RESULT CRK1Reader::CtSetBacklight(EBacklight eBacklight,uint32_t *Result)
//{
//	CJ_RESULT Res;
//	switch(eBacklight)
//	{
//	case BacklightOff:
//		Res=_CtSetBacklight(0,Result);
//		break;
//	case BacklightVeryLow:
//		Res=_CtSetBacklight(70,Result);
//		break;
//	case BacklightLow:
//		Res=_CtSetBacklight(100,Result);
//		break;
//	case BacklightMedium:
//		Res=_CtSetBacklight(120,Result);
//		break;
//	case BacklightHigh:
//		Res=_CtSetBacklight(160,Result);
//		break;
//	case BacklightVeryHigh:
//		Res=_CtSetBacklight(255,Result);
//		break;
//	default:
//		Res=CJ_ERR_WRONG_PARAMETER;
//	}
//	return Res;
//}
//
//CJ_RESULT CRK1Reader::CtSelfTest2(const uint8_t *TransportKey,uint8_t KeyNr)
//{
//	uint32_t Res;
//	uint8_t buffer[256];
//	struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime *DateTime=(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime *)buffer;
//   struct tm *t;
//   time_t tim;
//	 CJ_RESULT Result;
//
//   time(&tim);
//   t=localtime(&tim);
//
//	 DateTime->Nr=1;
//   sprintf((char *)DateTime->dtDate.ProductionDate,"%02d.%02d.%04d",t->tm_mday,t->tm_mon+1,t->tm_year+1900);
//   sprintf((char *)DateTime->dtDate.ProductionTime,"%02d:%02d",t->tm_hour,t->tm_min);
//	 memcpy(buffer+sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime),TransportKey,16);
//	 buffer[16+sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime)]=KeyNr;
//
//  Result=Escape(MODULE_ID_KERNEL,CCID_ESCAPE_SELF_TEST,buffer,sizeof(struct _CCID_Message::_Data::_Escape::_Reader::_EC30::_Data::_SetDateTime)+17,&Res,0,0);
//	if(Result!=CJ_SUCCESS && Result!=CJ_ERR_CHECK_RESULT)
//	{
//		m_Owner->DebugLeveled(DEBUG_MASK_COMMUNICATION_ERROR,"Error Selftest");
//		return CJ_ERR_DEVICE_LOST;
//	}
//   return Res;
//}
//
//#ifdef WITH_SECODER_INFO_OVERRIDE
//CJ_RESULT CRK1Reader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
//{
//	static const uint8_t SECODER3_INFO_0[] = {
//		"\x40\x07""Secoder"
//		"\x80\x05""1.2.0"
//		"\x80\x05""1.1.2"
//		"\x81\x21""Reiner Kartenger\x7b""te GmbH & Co.KG."
//	};
//	static const uint8_t SECODER3_INFO_1[] = {
//		"\x84\x02""de"
//		"\x90\x01\x01"
//		"\xa0\x13\x40\x03""tan\x80\x05""1.1.2\x83\x05""1.0.0"
//		"\xa0\x13\x40\x03""aut\x80\x05""1.1.2\x83\x05""1.0.0"
//		"\xa0\x13\x40\x03""sig\x80\x05""1.1.2\x83\x05""1.0.0"
//		"\xa0\x13\x40\x03""gkp\x80\x05""1.1.2\x83\x05""1.0.0"
//		"\xa0\x16\x40\x03""ctn\x80\x05""1.2.1\x83\x05""1.0.0\x84\x01\x33"
//		"\x90\x00"
//	};
//
//	CJ_RESULT res;
//	uint16_t InLenr = *lenr;
//	uint8_t ReaderId[20 + 2];
//	uint8_t SWImpVers[10 + 2];
//	uint8_t ReaderPorp[9 + 2];
//	int lenReaderId = 0;
//	int lenSWImpVers = 0;
//	int lenReaderProp = 0;
//	uint8_t *Tag92 = NULL;
//	uint8_t *Tag83 = NULL;
//	uint8_t *Tag91 = NULL;
//	uint8_t inCmd1 = *(cmd + 1);
//
//	memset(ReaderId, 0, sizeof(ReaderId));
//	memset(SWImpVers, 0, sizeof(SWImpVers));
//
//	if ((res = base::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr)) == CJ_SUCCESS)
//	{
//		if (inCmd1 == 0x70 && hasReaderChipTanLicense())
//		{
//			if (GetEnviroment("SecoderInfoOverride", 0x00000001) > 0)
//			{
//				if (GetEnviroment("SecoderInfoOverride_RFK", 0x00000001) > 0)
//				{
//					if (((Tag91 = GetTag(response, *lenr - 2, 0x91, &lenReaderProp)) != NULL) &&
//						((Tag92 = GetTag(response, *lenr - 2, 0x92, &lenReaderId)) != NULL) &&
//						((Tag83 = GetTag(response, *lenr - 2, 0x83, &lenSWImpVers)) != NULL) &&
//						(lenReaderId <= 20) && (lenSWImpVers <= 10) && (lenReaderProp == 9))
//					{
//						lenReaderProp += 2;
//						memcpy(ReaderPorp, Tag91 - 2, lenReaderProp);
//
//						lenReaderId += 2;
//						memcpy(ReaderId, Tag92 - 2, lenReaderId);
//
//						lenSWImpVers += 2;
//						memcpy(SWImpVers, Tag83 - 2, lenSWImpVers);
//
//						if (InLenr >= (sizeof(SECODER3_INFO_0) + lenReaderProp + lenReaderId + lenSWImpVers + sizeof(SECODER3_INFO_1)))
//						{
//							memcpy(response, SECODER3_INFO_0, sizeof(SECODER3_INFO_0) - 1);
//							memcpy(response + sizeof(SECODER3_INFO_0) - 1, ReaderPorp, lenReaderProp);
//							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp, ReaderId, lenReaderId);
//							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId, SWImpVers, lenSWImpVers);
//							memcpy(response + sizeof(SECODER3_INFO_0) - 1 + lenReaderProp + lenReaderId + lenSWImpVers, SECODER3_INFO_1, sizeof(SECODER3_INFO_1) - 1);
//							*lenr = sizeof(SECODER3_INFO_0) - 1 + (USHORT)lenReaderProp + (USHORT)lenReaderId + (USHORT)lenSWImpVers + sizeof(SECODER3_INFO_1) - 1;
//						}
//						else
//						{
//							return CJ_ERR_RBUFFER_TO_SMALL;
//						}
//					}
//				}
//			}
//		}
//	}
//	return res;
//}
//#endif
