import { Algebra } from "@ot-builder/prelude";
import * as Transform2X3 from "../transform-2x3";
export interface T<X> {
    readonly x: X;
    readonly y: X;
    readonly kind: number;
}
export interface PointFactoryT<X> {
    create(x: X, y: X, kind: number): T<X>;
}
export declare class OpT<X> implements Algebra.VectorSpace<T<X>, number> {
    private vsX;
    private factory;
    readonly neutral: T<X>;
    constructor(vsX: Algebra.VectorSpace<X, number>, factory: PointFactoryT<X>);
    add(a: T<X>, b: T<X>): T<X>;
    negate(a: T<X>): T<X>;
    minus(a: T<X>, b: T<X>): T<X>;
    scale(s: number, a: T<X>): T<X>;
    addScale(a: T<X>, s: number, b: T<X>): T<X>;
    applyTransform(a: T<X>, t: Transform2X3.T<X>): T<X>;
    removeScaledOffset(t: Transform2X3.T<X>): Transform2X3.T<X>;
    combineTransform(_a: Transform2X3.T<X>, _b: Transform2X3.T<X>): Transform2X3.T<X>;
}
export type ContourT<X> = ReadonlyArray<T<X>>;
export type ContourWT<X> = Array<T<X>>;
//# sourceMappingURL=point.d.ts.map