import { BinaryView, Frag } from "@ot-builder/bin-util";
import { Cff } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { CffDrawCallRaw } from "../char-string/write/draw-call";
import { CffReadContext } from "../context/read";
import { CffWriteContext } from "../context/write";
import { DictEncoder } from "./encoder";
import { CffFontDictDataCollector, CffFontDictInterpreterBase } from "./font-dict";
import { CffDictDataCollector, CffDictInterpreter } from "./general";
export declare class CffTopDictInterpreter extends CffFontDictInterpreterBase implements CffDictInterpreter<CffTopDictRead> {
    constructor(ctx: CffReadContext);
    private td;
    protected doOperator(opCode: number, flags?: Data.Maybe<number[]>): void;
    getResult(): CffTopDictRead;
}
export declare class CffTopDictDataCollector extends CffDictDataCollector<CffTopDictWrite, void> {
    fdDC: CffFontDictDataCollector;
    collectDrawCalls(td: CffTopDictWrite, ctx: CffWriteContext, rest: void): Generator<CffDrawCallRaw, void, unknown>;
    processPointers(encoder: DictEncoder, td: CffTopDictWrite, ctx: CffWriteContext, rest: void): void;
}
export declare class CffTopDictRead {
    fd: Cff.FontDict;
    constructor(fd: Cff.FontDict);
    cidROS: null | Cff.CID;
    vCharStrings: null | BinaryView;
    vFDArray: null | BinaryView;
    vFDSelect: null | BinaryView;
    vVarStore: null | BinaryView;
    vCharSet: null | BinaryView;
    vEncoding: null | BinaryView;
}
export declare class CffTopDictWrite {
    fd: Cff.FontDict;
    constructor(fd: Cff.FontDict);
    fgCharStrings: null | Frag;
    fgFDArray: null | Frag;
    fgFDSelect: null | Frag;
    fgVarStore: null | Frag;
    fgCharSet: null | Frag;
    cidROS: null | Cff.CID;
}
export declare const CffTopDictIo: {
    write(target: Frag, t: CffTopDictWrite, ctx: CffWriteContext, rest: void): void;
    read(view: BinaryView, ctx: CffReadContext, dictSize: number): CffTopDictRead;
};
export declare const CffTopDictIndexWrite: {
    write(target: Frag, t: CffTopDictWrite, ctx: CffWriteContext): void;
};
//# sourceMappingURL=top.d.ts.map