; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "C-evo-dh"
#define MyAppTitle "C-evo: Distant Horizon"
#define MyAppNameShort "C-evo-dh"
#define MyAppVersion "3.0"
#define MyAppPublisher "Peter Blackman"
#define MyAppPublisherShort "PeterB"
#define MyAppURL "https://sourceforge.net/projects/c-evo-eh/"
#define MyAppExeName "C-evo-dh.exe"
#define MyAppDebugName "C-evo-dh.dbg"
#define MyAppSubDir "../.."

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
WizardStyle=modern
AppId={{7771553F-516C-4267-98A6-1C6D8BBBEB2E}}
AppName={#MyAppTitle}
#ifdef MyAppVersionSuffix
#define MyAppVersionSuffix "-" + MyAppVersionSuffix
#else
#define MyAppVersionSuffix ""
#endif
AppVersion={#MyAppVersion}{#MyAppVersionSuffix}
AppVerName={#MyAppName} {#MyAppVersion}{#MyAppVersionSuffix}
UninstallDisplayName={#MyAppTitle}
UninstallDisplayIcon="{app}\{#MyAppExeName}"
VersionInfoVersion={#MyAppVersion}
VersionInfoCompany={#MyAppPublisher}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={commonpf}\{#MyAppName}
DefaultGroupName={#MyAppName}
AllowNoIcons=yes
OutputDir=.
Compression=lzma
SolidCompression=yes
ChangesAssociations=yes

[Languages]
Name: "en"; MessagesFile: "compiler:Default.isl"
Name: "cs"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "de"; MessagesFile: "compiler:Languages\German.isl"
Name: "it"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "es"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "fr"; MessagesFile: "compiler:Languages\French.isl"
Name: "ca"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "ru"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "pt"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "br"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "zs"; MessagesFile: "compiler:Languages\ChineseSimplified.isl"
Name: "zt"; MessagesFile: "compiler:Languages\ChineseTraditional.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags:

[Registry]
Root: HKLM; Subkey: "Software\C-evo"; Flags: uninsdeletekey

#define FileTypeName "C-evo book"
Root: HKCR; Subkey: ".cevo"; ValueType: string; ValueName: ""; ValueData: "{#FileTypeName}"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "{#FileTypeName}"; ValueType: string; ValueName: ""; ValueData: "{#FileTypeName}"; Flags: uninsdeletekey
Root: HKCR; Subkey: "{#FileTypeName}\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKCR; Subkey: "{#FileTypeName}\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

#define FileTypeName "C-evo map"
Root: HKCR; Subkey: ".cevomap"; ValueType: string; ValueName: ""; ValueData: "{#FileTypeName}"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "{#FileTypeName}"; ValueType: string; ValueName: ""; ValueData: "{#FileTypeName}"; Flags: uninsdeletekey
Root: HKCR; Subkey: "{#FileTypeName}\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\{#MyAppExeName},0"
Root: HKCR; Subkey: "{#FileTypeName}\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\{#MyAppExeName}"" ""%1"""

[Components]
Name: "main"; Description: "Main Files"; Types: full compact custom; Flags: fixed
Name: "maps"; Description: "Maps"; Types: full
Name: "lang"; Description: "Language files"; Types: full
Name: "lang\cs"; Description: "Czech"; Types: full
Name: "lang\de"; Description: "German"; Types: full
Name: "lang\fr"; Description: "French"; Types: full
Name: "lang\it"; Description: "Italian"; Types: full
Name: "lang\es"; Description: "Spanish"; Types: full
Name: "lang\pt"; Description: "Portuguese"; Types: full
Name: "lang\ru"; Description: "Russian"; Types: full
Name: "lang\zhHans"; Description: "Chinese Simplified"; Types: full
Name: "lang\zhHant"; Description: "Chinese Traditional"; Types: full
Name: "ai"; Description: "AI files"; Types: full
Name: "ai\stdai"; Description: "StdAI"; Types: full

[Files]
Source: "{#MyAppSubDir}\Graphics\*"; DestDir: "{app}\Graphics"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Sounds\*.*"; DestDir: "{app}\Sounds"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Tribes\*.*"; DestDir: "{app}\Tribes"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Saved\*.*"; DestDir: "{app}\Saved"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Maps\*.*"; DestDir: "{app}\Maps"; Flags: ignoreversion; Components: maps
Source: "{#MyAppSubDir}\Localization\cs\*.*"; DestDir: "{app}\Localization\cs"; Flags: ignoreversion recursesubdirs; Components: lang\cs
Source: "{#MyAppSubDir}\Localization\de\*.*"; DestDir: "{app}\Localization\de"; Flags: ignoreversion recursesubdirs; Components: lang\de
Source: "{#MyAppSubDir}\Localization\es\*.*"; DestDir: "{app}\Localization\es"; Flags: ignoreversion recursesubdirs; Components: lang\es
Source: "{#MyAppSubDir}\Localization\fr\*.*"; DestDir: "{app}\Localization\fr"; Flags: ignoreversion recursesubdirs; Components: lang\fr
Source: "{#MyAppSubDir}\Localization\it\*.*"; DestDir: "{app}\Localization\it"; Flags: ignoreversion recursesubdirs; Components: lang\it
Source: "{#MyAppSubDir}\Localization\pt\*.*"; DestDir: "{app}\Localization\pt"; Flags: ignoreversion recursesubdirs; Components: lang\pt
Source: "{#MyAppSubDir}\Localization\ru\*.*"; DestDir: "{app}\Localization\ru"; Flags: ignoreversion recursesubdirs; Components: lang\ru
Source: "{#MyAppSubDir}\Localization\zh-Hans\*.*"; DestDir: "{app}\Localization\zh-Hans"; Flags: ignoreversion recursesubdirs; Components: lang\zhHans
Source: "{#MyAppSubDir}\Localization\zh-Hant\*.*"; DestDir: "{app}\Localization\zh-Hant"; Flags: ignoreversion recursesubdirs; Components: lang\zhHant
Source: "{#MyAppSubDir}\Help\*.*"; DestDir: "{app}\Help"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Fonts.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Language.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\Language2.txt"; DestDir: "{app}"; Flags: ignoreversion; Components: main
Source: "{#MyAppSubDir}\AI\StdAI\StdAI.png"; DestDir: "{app}\AI\StdAI"; Flags: ignoreversion; Components: ai\stdai
Source: "{#MyAppSubDir}\AI\StdAI\StdAI.ai.txt"; DestDir: "{app}\AI\StdAI"; Flags: ignoreversion; Components: ai\stdai
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, "&", "&&")}}"; Flags: nowait postinstall skipifsilent
