//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffiledescriptornativedescriptor?language=objc)
pub type CFFileDescriptorNativeDescriptor = c_int;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffiledescriptor?language=objc)
#[repr(C)]
pub struct CFFileDescriptor {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFFileDescriptor {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFFileDescriptor"> for CFFileDescriptor {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcffiledescriptorreadcallback?language=objc)
pub const kCFFileDescriptorReadCallBack: CFOptionFlags = 1 << 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcffiledescriptorwritecallback?language=objc)
pub const kCFFileDescriptorWriteCallBack: CFOptionFlags = 1 << 1;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffiledescriptorcallback?language=objc)
pub type CFFileDescriptorCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFFileDescriptor, CFOptionFlags, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffiledescriptorcontext?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFFileDescriptorContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>,
    pub release: Option<unsafe extern "C-unwind" fn(*mut c_void)>,
    pub copyDescription: Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFFileDescriptorContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *mut c_void>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(*mut c_void) -> *const CFString>>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFFileDescriptorContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CFFileDescriptor {
    #[doc(alias = "CFFileDescriptorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFFileDescriptorGetTypeID() -> CFTypeID;
        }
        unsafe { CFFileDescriptorGetTypeID() }
    }
}

impl CFFileDescriptor {
    #[doc(alias = "CFFileDescriptorCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        fd: CFFileDescriptorNativeDescriptor,
        close_on_invalidate: bool,
        callout: CFFileDescriptorCallBack,
        context: *const CFFileDescriptorContext,
    ) -> Option<CFRetained<CFFileDescriptor>> {
        extern "C-unwind" {
            fn CFFileDescriptorCreate(
                allocator: Option<&CFAllocator>,
                fd: CFFileDescriptorNativeDescriptor,
                close_on_invalidate: Boolean,
                callout: CFFileDescriptorCallBack,
                context: *const CFFileDescriptorContext,
            ) -> Option<NonNull<CFFileDescriptor>>;
        }
        let ret = unsafe {
            CFFileDescriptorCreate(allocator, fd, close_on_invalidate as _, callout, context)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFFileDescriptorGetNativeDescriptor")]
    #[inline]
    pub fn native_descriptor(self: &CFFileDescriptor) -> CFFileDescriptorNativeDescriptor {
        extern "C-unwind" {
            fn CFFileDescriptorGetNativeDescriptor(
                f: &CFFileDescriptor,
            ) -> CFFileDescriptorNativeDescriptor;
        }
        unsafe { CFFileDescriptorGetNativeDescriptor(self) }
    }

    #[doc(alias = "CFFileDescriptorGetContext")]
    #[inline]
    pub unsafe fn context(self: &CFFileDescriptor, context: *mut CFFileDescriptorContext) {
        extern "C-unwind" {
            fn CFFileDescriptorGetContext(
                f: &CFFileDescriptor,
                context: *mut CFFileDescriptorContext,
            );
        }
        unsafe { CFFileDescriptorGetContext(self, context) }
    }

    #[doc(alias = "CFFileDescriptorEnableCallBacks")]
    #[inline]
    pub fn enable_call_backs(self: &CFFileDescriptor, call_back_types: CFOptionFlags) {
        extern "C-unwind" {
            fn CFFileDescriptorEnableCallBacks(
                f: &CFFileDescriptor,
                call_back_types: CFOptionFlags,
            );
        }
        unsafe { CFFileDescriptorEnableCallBacks(self, call_back_types) }
    }

    #[doc(alias = "CFFileDescriptorDisableCallBacks")]
    #[inline]
    pub fn disable_call_backs(self: &CFFileDescriptor, call_back_types: CFOptionFlags) {
        extern "C-unwind" {
            fn CFFileDescriptorDisableCallBacks(
                f: &CFFileDescriptor,
                call_back_types: CFOptionFlags,
            );
        }
        unsafe { CFFileDescriptorDisableCallBacks(self, call_back_types) }
    }

    #[doc(alias = "CFFileDescriptorInvalidate")]
    #[inline]
    pub fn invalidate(self: &CFFileDescriptor) {
        extern "C-unwind" {
            fn CFFileDescriptorInvalidate(f: &CFFileDescriptor);
        }
        unsafe { CFFileDescriptorInvalidate(self) }
    }

    #[doc(alias = "CFFileDescriptorIsValid")]
    #[inline]
    pub fn is_valid(self: &CFFileDescriptor) -> bool {
        extern "C-unwind" {
            fn CFFileDescriptorIsValid(f: &CFFileDescriptor) -> Boolean;
        }
        let ret = unsafe { CFFileDescriptorIsValid(self) };
        ret != 0
    }

    #[doc(alias = "CFFileDescriptorCreateRunLoopSource")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        f: Option<&CFFileDescriptor>,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFFileDescriptorCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                f: Option<&CFFileDescriptor>,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CFFileDescriptorCreateRunLoopSource(allocator, f, order) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[deprecated = "renamed to `CFFileDescriptor::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFFileDescriptorCreate(
    allocator: Option<&CFAllocator>,
    fd: CFFileDescriptorNativeDescriptor,
    close_on_invalidate: bool,
    callout: CFFileDescriptorCallBack,
    context: *const CFFileDescriptorContext,
) -> Option<CFRetained<CFFileDescriptor>> {
    extern "C-unwind" {
        fn CFFileDescriptorCreate(
            allocator: Option<&CFAllocator>,
            fd: CFFileDescriptorNativeDescriptor,
            close_on_invalidate: Boolean,
            callout: CFFileDescriptorCallBack,
            context: *const CFFileDescriptorContext,
        ) -> Option<NonNull<CFFileDescriptor>>;
    }
    let ret = unsafe {
        CFFileDescriptorCreate(allocator, fd, close_on_invalidate as _, callout, context)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFFileDescriptor::native_descriptor`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorGetNativeDescriptor(
    f: &CFFileDescriptor,
) -> CFFileDescriptorNativeDescriptor {
    extern "C-unwind" {
        fn CFFileDescriptorGetNativeDescriptor(
            f: &CFFileDescriptor,
        ) -> CFFileDescriptorNativeDescriptor;
    }
    unsafe { CFFileDescriptorGetNativeDescriptor(f) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFFileDescriptor::context`"]
    pub fn CFFileDescriptorGetContext(f: &CFFileDescriptor, context: *mut CFFileDescriptorContext);
}

#[deprecated = "renamed to `CFFileDescriptor::enable_call_backs`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorEnableCallBacks(
    f: &CFFileDescriptor,
    call_back_types: CFOptionFlags,
) {
    extern "C-unwind" {
        fn CFFileDescriptorEnableCallBacks(f: &CFFileDescriptor, call_back_types: CFOptionFlags);
    }
    unsafe { CFFileDescriptorEnableCallBacks(f, call_back_types) }
}

#[deprecated = "renamed to `CFFileDescriptor::disable_call_backs`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorDisableCallBacks(
    f: &CFFileDescriptor,
    call_back_types: CFOptionFlags,
) {
    extern "C-unwind" {
        fn CFFileDescriptorDisableCallBacks(f: &CFFileDescriptor, call_back_types: CFOptionFlags);
    }
    unsafe { CFFileDescriptorDisableCallBacks(f, call_back_types) }
}

#[deprecated = "renamed to `CFFileDescriptor::invalidate`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorInvalidate(f: &CFFileDescriptor) {
    extern "C-unwind" {
        fn CFFileDescriptorInvalidate(f: &CFFileDescriptor);
    }
    unsafe { CFFileDescriptorInvalidate(f) }
}

#[deprecated = "renamed to `CFFileDescriptor::is_valid`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorIsValid(f: &CFFileDescriptor) -> bool {
    extern "C-unwind" {
        fn CFFileDescriptorIsValid(f: &CFFileDescriptor) -> Boolean;
    }
    let ret = unsafe { CFFileDescriptorIsValid(f) };
    ret != 0
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFFileDescriptor::new_run_loop_source`"]
#[inline]
pub extern "C-unwind" fn CFFileDescriptorCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    f: Option<&CFFileDescriptor>,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFFileDescriptorCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            f: Option<&CFFileDescriptor>,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CFFileDescriptorCreateRunLoopSource(allocator, f, order) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
