/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.annotations.Beta;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionListener;
import com.mongodb.event.ConnectionMessageReceivedEvent;
import com.mongodb.event.ConnectionMessagesSentEvent;
import com.mongodb.event.ConnectionOpenedEvent;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Beta
public final class ConnectionEventMulticaster
implements ConnectionListener {
    private final Set<ConnectionListener> connectionListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void add(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public void remove(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    @Override
    public void connectionOpened(ConnectionOpenedEvent event) {
        for (ConnectionListener cur : this.connectionListeners) {
            cur.connectionOpened(event);
        }
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent event) {
        for (ConnectionListener cur : this.connectionListeners) {
            cur.connectionClosed(event);
        }
    }

    @Override
    public void messagesSent(ConnectionMessagesSentEvent event) {
        for (ConnectionListener cur : this.connectionListeners) {
            cur.messagesSent(event);
        }
    }

    @Override
    public void messageReceived(ConnectionMessageReceivedEvent event) {
        for (ConnectionListener cur : this.connectionListeners) {
            cur.messageReceived(event);
        }
    }
}

