/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_copykrn.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20251106 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_copykrn_nvl [] = 
{
    0x00002000, 0x00000040, 0x000029c0, 0x00000040,
    0x00001280, 0x00002040, 0x000012c0, 0x00000900,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002a00, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2a10002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x29c01280, 0x00409b00,
    0x00002940, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x29c01280, 0x00409300,
    0x001ffcbc, 0x11b6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x1056e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0x40fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28408514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000dc4, 0x5710c483,
    0x6a346a56, 0x0db6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000d74, 0x5710c483,
    0x6a346a56, 0x0d66e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000d24, 0x5710c483,
    0x6a346a56, 0x0d16e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000cd4, 0x5710c483,
    0x6a346a56, 0x0cc6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000c84, 0x5710c483,
    0x6a346a56, 0x0c76e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000c34, 0x5710c483,
    0x6a346a56, 0x0c26e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000be4, 0x5710c483,
    0x6a346a56, 0x0bd6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000b94, 0x5710c483,
    0x6a346a56, 0x0b86e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000b44, 0x5710c483,
    0x6a346a56, 0x0b36e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000af4, 0x5710c483,
    0x6a346a56, 0x0ae6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000aa4, 0x5710c483,
    0x6a346a56, 0x0a96e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000a54, 0x5710c483,
    0x6a346a56, 0x0a46e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000a04, 0x5710c483,
    0x6a346a56, 0x09f6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x000009b4, 0x5710c483,
    0x6a346a56, 0x09a6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000964, 0x5710c483,
    0x6a346a56, 0x0956e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000914, 0x5710c483,
    0x6a346a56, 0x0906e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x000008c4, 0x5710c483,
    0x6a346a56, 0x08b6e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0x909090c3, 0x90909090, 0x90909090,
    0x57e58955, 0x084d8b56, 0xc689e089, 0x002000bf,
    0x81c72900, 0x001fccff, 0xbf057200, 0x00001fcc,
    0x6a51346a, 0xe80f6a00, 0x00000874, 0x5710c483,
    0x6a346a56, 0x0866e80f, 0xc4830000, 0xfdebf410,
    0x5d5f5ef4, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x400101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x74b90002, 0x29ff1000, 0x01c764c1, 0x00021000,
    0x100070b9, 0x64c129ff, 0x200001c7, 0x0cb90002,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100008b9,
    0x64c129ff, 0x000001c7, 0x14b90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100010b9, 0x64c129ff,
    0x000001c7, 0x1cb90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100018b9, 0x64c129ff, 0x000001c7,
    0x24b90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100020b9, 0x64c129ff, 0x000001c7, 0x2cb90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100028b9,
    0x64c129ff, 0x000001c7, 0x34b90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100030b9, 0x64c129ff,
    0x000001c7, 0x3cb90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100038b9, 0x64c129ff, 0x000001c7,
    0x44b90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100040b9, 0x64c129ff, 0x000001c7, 0x4cb90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100048b9,
    0x64c129ff, 0x000001c7, 0x54b90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100050b9, 0x64c129ff,
    0x000001c7, 0x5cb90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100058b9, 0x64c129ff, 0x000001c7,
    0x64b90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100060b9, 0x64c129ff, 0x000001c7, 0x6cb90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100068b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x03cb8914, 0x820f0c5d,
    0x00000083, 0x83087d8b, 0x02b80fff, 0x77000000,
    0x107d8371, 0xbe6b7400, 0x00020000, 0x100000ba,
    0x8bf229ff, 0x2900bd34, 0xd6010000, 0x03368b64,
    0x28c0bd14, 0x8b640000, 0x73fe293a, 0x0002b807,
    0x3eeb0000, 0x0000ff81, 0x02b80002, 0x72000000,
    0x0fde3931, 0x00002982, 0x0fc98500, 0x00001f84,
    0x0c7d0300, 0x020000ba, 0x31d72900, 0x10458bf6,
    0x6437148d, 0x1489128b, 0x04c68330, 0xf072ce39,
    0x5f5ec031, 0xb8c35d5b, 0x00000003, 0x9090f4eb,
    0x53e58955, 0x7d8b5657, 0x0fff8308, 0x000002b8,
    0x8b7f7700, 0xc985104d, 0x458b7874, 0x03c28914,
    0x73720c55, 0x020000be, 0x0000bb00, 0xf329ff10,
    0x00bd348b, 0x01000029, 0x368b64de, 0xc0bd1c03,
    0x64000028, 0xfe293b8b, 0x02b80773, 0xeb000000,
    0x00ff8141, 0x72000200, 0x39c789f1, 0x0002b8d6,
    0x2e720000, 0x85138b64, 0x21840fff, 0x89000000,
    0x0c5503f8, 0x020000be, 0x31f22900, 0x909090f6,
    0x8d313c8b, 0x8964321c, 0x04c6833b, 0xf072c639,
    0x5f5ec031, 0xb8c35d5b, 0x00000003, 0x9090f4eb,
    0x53e58955, 0xec835657, 0x0000b81c, 0x00ba0002,
    0x29ffe0d0, 0x0a8b64c2, 0xffffe181, 0x558903ff,
    0x0a8964e4, 0x100000b9, 0x89c129ff, 0x04b9d84d,
    0x29ff1000, 0xdc4d89c1, 0x100070b9, 0x89c129ff,
    0x74b9e04d, 0x29ff1000, 0xe84d89c1, 0x020000bb,
    0xc7dbf700, 0x0000ec45, 0x00b90000, 0x31000004,
    0x0022e9f6, 0x90900000, 0x90909090, 0x90909090,
    0x64e4558b, 0x000d028b, 0x64400000, 0xc3830289,
    0x840f4904, 0x000000ad, 0xc683d231, 0x0ff08904,
    0x72f34592, 0xd8758b3b, 0x8b368b64, 0x8b64dc7d,
    0x72fe293f, 0x00ff812b, 0x0f000200, 0x00001f82,
    0x0fc63900, 0x00001782, 0x64df0100, 0x5589178b,
    0x89d285ec, 0x2a850fc6, 0xe9000000, 0x00000065,
    0x64e47d8b, 0xce81378b, 0x40000000, 0x83378964,
    0x7400ec7d, 0x0fc68950, 0x88f345b6, 0x0fd285c2,
    0xffff7b85, 0xe0458bff, 0x8b008b64, 0x8b64e855,
    0x0fd02912, 0xffff6782, 0x00fa81ff, 0x0f000200,
    0xffff5b82, 0x0ff039ff, 0xffff5382, 0xe8458bff,
    0x01008b64, 0xec558bd8, 0x83108964, 0x0f4904c3,
    0xffff5385, 0x1cc483ff, 0x5d5b5f5e, 0x909090c3,
    0x83e58955, 0xb5e808ec, 0xb8fffffe, 0x00020000,
    0xe000b0b9, 0x64c129fe, 0x000001c7, 0xc4830000,
    0x90c35d08, 0x90909090, 0x90909090, 0x90909090,
    0x83e58955, 0x95e808ec, 0xe8ffffef, 0xfffffb60,
    0xfff5dbe8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000290, 0x000002e0, 0x00000380, 0x00000330,
    0x000003d0, 0x00000420, 0x00000470, 0x000004c0,
    0x00000510, 0x00000560, 0x000005b0, 0x00000600,
    0x00000650, 0x000006a0, 0x000006f0, 0x00000080,
    0x00000790, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000004, 0x0000000c, 0x00000014, 0x0000001c,
    0x00000024, 0x0000002c, 0x00000034, 0x0000003c,
    0x00000044, 0x0000004c, 0x00000054, 0x0000005c,
    0x00000064, 0x0000006c, 0x00000074, 0x0000007c,
    0x00000000, 0x00000008, 0x00000010, 0x00000018,
    0x00000020, 0x00000028, 0x00000030, 0x00000038,
    0x00000040, 0x00000048, 0x00000050, 0x00000058,
    0x00000060, 0x00000068, 0x00000070, 0x00000078,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
