#!/usr/bin/env python3

import os
from pathlib import Path

IGNORE = [
    'tests/filters/feMorphology/huge-radius', # will timeout on CI
    'tests/structure/svg/negative-size', # invalid size
    'tests/structure/svg/no-size', # invalid size
    'tests/structure/svg/zero-size', # invalid size
    'tests/structure/svg/not-UTF-8-encoding', # invalid encoding
    # Produces slightly different output on some hardware.
    # Not a bug, just a SIMD rounding difference.
    'tests/paint-servers/radialGradient/focal-point-correction',
]

print('// Copyright 2020 the Resvg Authors')
print('// SPDX-License-Identifier: Apache-2.0 OR MIT')
print()
print('// This file is auto-generated by gen-tests.py')
print()
print('#![allow(non_snake_case)]')
print()
print('use crate::render;')
print()

files = sorted(list(Path('tests').rglob('*.svg')))
for file in files:
    file = str(file).replace('.svg', '')

    if file in IGNORE:
        continue

    fn_name = file.replace('tests/', '')
    fn_name = fn_name.replace('/', '_')
    fn_name = fn_name.replace('-', '_')
    fn_name = fn_name.replace('=', '_eq_')
    fn_name = fn_name.replace('.', '_')
    fn_name = fn_name.replace('#', '')

    print(f'#[test] fn {fn_name}() {{ assert_eq!(render("{file}"), 0); }}')
