/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.ITaskService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.Task;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JMSRISTaskService
extends JMSRISService
implements ITaskService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.Task";
    private static Vector mClassNames = new Vector();

    public JMSRISTaskService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String tasks = props.getProperty("tasks");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + tasks + "%");
        return ret;
    }

    public Task[] getTasks() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        Task[] ret = new Task[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Task)it.next();
        }
        return ret;
    }

    public int removeTasks(String owner) throws IOException {
        return this.removeResourceObjectsByOwner(owner, CLASSNAME);
    }

    public Task[] getTasks(String owner) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        Iterator it = objects.iterator();
        Task[] ret = new Task[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Task)it.next();
        }
        return ret;
    }

    public Task[] getTasks(String owner, String search) throws IOException {
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        Iterator it = objects.iterator();
        Vector<Task> tasks = new Vector<Task>();
        String lsearch = search.toLowerCase();
        while (it.hasNext()) {
            String body;
            Task task = (Task)it.next();
            String title = task.getTitle();
            if (title != null) {
                title = title.toLowerCase();
            }
            if ((body = task.getDescription()) != null) {
                body = body.toLowerCase();
            }
            if ((title == null || title.indexOf(lsearch) < 0) && (body == null || body.indexOf(lsearch) < 0)) continue;
            tasks.add(task);
        }
        Task[] ret = new Task[tasks.size()];
        for (int idx = 0; idx < ret.length; ++idx) {
            ret[idx] = (Task)tasks.elementAt(idx);
        }
        return ret;
    }

    public Task getTask(String id) throws IOException {
        return (Task)this.getResourceObjectById(id, CLASSNAME);
    }

    public void addTask(Task data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save Task " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteTask(Task data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Task " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

