#pragma once
/*
 *  $Id: correl-table.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_CORREL_TABLE_H__
#define __GWYUI_CORREL_TABLE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GWY_TYPE_CORREL_TABLE            (gwy_correl_table_get_type())
#define GWY_CORREL_TABLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_CORREL_TABLE, GwyCorrelTable))
#define GWY_CORREL_TABLE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_CORREL_TABLE, GwyCorrelTableClass))
#define GWY_IS_CORREL_TABLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_CORREL_TABLE))
#define GWY_IS_CORREL_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_CORREL_TABLE))
#define GWY_CORREL_TABLE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_CORREL_TABLE, GwyCorrelTableClass))

typedef struct _GwyCorrelTable             GwyCorrelTable;
typedef struct _GwyCorrelTableClass        GwyCorrelTableClass;
typedef struct _GwyCorrelTablePrivate      GwyCorrelTablePrivate;

struct _GwyCorrelTable {
    GtkGrid grid;
    GwyCorrelTablePrivate *priv;
};

struct _GwyCorrelTableClass {
    GtkGridClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType      gwy_correl_table_get_type          (void)                   G_GNUC_CONST;
GtkWidget* gwy_correl_table_new               (void);
void       gwy_correl_table_resize            (GwyCorrelTable *table,
                                               guint n);
void       gwy_correl_table_set_name          (GwyCorrelTable *table,
                                               guint i,
                                               const gchar *markup);
void       gwy_correl_table_set_tooltip       (GwyCorrelTable *table,
                                               guint i,
                                               const gchar *markup);
void       gwy_correl_table_set_fixed         (GwyCorrelTable *table,
                                               guint i,
                                               const gboolean fixed);
void       gwy_correl_table_set_correl        (GwyCorrelTable *table,
                                               guint i,
                                               guint j,
                                               gdouble correl);
void       gwy_correl_table_clear             (GwyCorrelTable *table);
void       gwy_correl_table_set_high_threshold(GwyCorrelTable *table,
                                               gdouble value);
void       gwy_correl_table_set_bad_threshold (GwyCorrelTable *table,
                                               gdouble value);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
