//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsightcontainers

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsightcontainers/armhdinsightcontainers"
	moduleVersion = "v0.2.0"
)

// Action - A string property that indicates the action to be performed on the Flink job. It can have one of the following
// enum values => NEW, UPDATE, STATELESSUPDATE, STOP, START, CANCEL, SAVEPOINT, LIST
// SAVEPOINT, or DELETE.
type Action string

const (
	ActionCANCEL          Action = "CANCEL"
	ActionDELETE          Action = "DELETE"
	ActionLISTSAVEPOINT   Action = "LIST_SAVEPOINT"
	ActionNEW             Action = "NEW"
	ActionSAVEPOINT       Action = "SAVEPOINT"
	ActionSTART           Action = "START"
	ActionSTATELESSUPDATE Action = "STATELESS_UPDATE"
	ActionSTOP            Action = "STOP"
	ActionUPDATE          Action = "UPDATE"
)

// PossibleActionValues returns the possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{
		ActionCANCEL,
		ActionDELETE,
		ActionLISTSAVEPOINT,
		ActionNEW,
		ActionSAVEPOINT,
		ActionSTART,
		ActionSTATELESSUPDATE,
		ActionSTOP,
		ActionUPDATE,
	}
}

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AutoscaleType - User to specify which type of Autoscale to be implemented - Scheduled Based or Load Based.
type AutoscaleType string

const (
	AutoscaleTypeLoadBased     AutoscaleType = "LoadBased"
	AutoscaleTypeScheduleBased AutoscaleType = "ScheduleBased"
)

// PossibleAutoscaleTypeValues returns the possible values for the AutoscaleType const type.
func PossibleAutoscaleTypeValues() []AutoscaleType {
	return []AutoscaleType{
		AutoscaleTypeLoadBased,
		AutoscaleTypeScheduleBased,
	}
}

// ComparisonOperator - The comparison operator.
type ComparisonOperator string

const (
	ComparisonOperatorGreaterThan        ComparisonOperator = "greaterThan"
	ComparisonOperatorGreaterThanOrEqual ComparisonOperator = "greaterThanOrEqual"
	ComparisonOperatorLessThan           ComparisonOperator = "lessThan"
	ComparisonOperatorLessThanOrEqual    ComparisonOperator = "lessThanOrEqual"
)

// PossibleComparisonOperatorValues returns the possible values for the ComparisonOperator const type.
func PossibleComparisonOperatorValues() []ComparisonOperator {
	return []ComparisonOperator{
		ComparisonOperatorGreaterThan,
		ComparisonOperatorGreaterThanOrEqual,
		ComparisonOperatorLessThan,
		ComparisonOperatorLessThanOrEqual,
	}
}

// ContentEncoding - This property indicates if the content is encoded and is case-insensitive. Please set the value to base64
// if the content is base64 encoded. Set it to none or skip it if the content is plain text.
type ContentEncoding string

const (
	ContentEncodingBase64 ContentEncoding = "Base64"
	ContentEncodingNone   ContentEncoding = "None"
)

// PossibleContentEncodingValues returns the possible values for the ContentEncoding const type.
func PossibleContentEncodingValues() []ContentEncoding {
	return []ContentEncoding{
		ContentEncodingBase64,
		ContentEncodingNone,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// JobType - Type of cluster job.
type JobType string

const (
	JobTypeFlinkJob JobType = "FlinkJob"
)

// PossibleJobTypeValues returns the possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{
		JobTypeFlinkJob,
	}
}

// KeyVaultObjectType - Type of key vault object: secret, key or certificate.
type KeyVaultObjectType string

const (
	KeyVaultObjectTypeCertificate KeyVaultObjectType = "Certificate"
	KeyVaultObjectTypeKey         KeyVaultObjectType = "Key"
	KeyVaultObjectTypeSecret      KeyVaultObjectType = "Secret"
)

// PossibleKeyVaultObjectTypeValues returns the possible values for the KeyVaultObjectType const type.
func PossibleKeyVaultObjectTypeValues() []KeyVaultObjectType {
	return []KeyVaultObjectType{
		KeyVaultObjectTypeCertificate,
		KeyVaultObjectTypeKey,
		KeyVaultObjectTypeSecret,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProvisioningStatus - Provisioning state of the resource.
type ProvisioningStatus string

const (
	ProvisioningStatusAccepted  ProvisioningStatus = "Accepted"
	ProvisioningStatusCanceled  ProvisioningStatus = "Canceled"
	ProvisioningStatusFailed    ProvisioningStatus = "Failed"
	ProvisioningStatusSucceeded ProvisioningStatus = "Succeeded"
)

// PossibleProvisioningStatusValues returns the possible values for the ProvisioningStatus const type.
func PossibleProvisioningStatusValues() []ProvisioningStatus {
	return []ProvisioningStatus{
		ProvisioningStatusAccepted,
		ProvisioningStatusCanceled,
		ProvisioningStatusFailed,
		ProvisioningStatusSucceeded,
	}
}

// ScaleActionType - The action type.
type ScaleActionType string

const (
	ScaleActionTypeScaledown ScaleActionType = "scaledown"
	ScaleActionTypeScaleup   ScaleActionType = "scaleup"
)

// PossibleScaleActionTypeValues returns the possible values for the ScaleActionType const type.
func PossibleScaleActionTypeValues() []ScaleActionType {
	return []ScaleActionType{
		ScaleActionTypeScaledown,
		ScaleActionTypeScaleup,
	}
}

type ScheduleDay string

const (
	ScheduleDayFriday    ScheduleDay = "Friday"
	ScheduleDayMonday    ScheduleDay = "Monday"
	ScheduleDaySaturday  ScheduleDay = "Saturday"
	ScheduleDaySunday    ScheduleDay = "Sunday"
	ScheduleDayThursday  ScheduleDay = "Thursday"
	ScheduleDayTuesday   ScheduleDay = "Tuesday"
	ScheduleDayWednesday ScheduleDay = "Wednesday"
)

// PossibleScheduleDayValues returns the possible values for the ScheduleDay const type.
func PossibleScheduleDayValues() []ScheduleDay {
	return []ScheduleDay{
		ScheduleDayFriday,
		ScheduleDayMonday,
		ScheduleDaySaturday,
		ScheduleDaySunday,
		ScheduleDayThursday,
		ScheduleDayTuesday,
		ScheduleDayWednesday,
	}
}
