+++
title = "google_logging_folder_exclusion resource"
draft = false
gh_repo = "inspec"
platform = "gcp"

[menu]
  [menu.inspec]
    title = "google_logging_folder_exclusion"
    identifier = "inspec/resources/gcp/google_logging_folder_exclusion.md google_logging_folder_exclusion resource"
    parent = "inspec/resources/gcp"
+++

## Syntax

A `google_logging_folder_exclusion` is used to test a Google FolderExclusion resource

## Examples

```ruby
# Getting folder exclusions is complicated due to the name being generated by the server.
# This can be drastically simplified if you have the name when writing the test
describe.one do
  google_resourcemanager_folders(parent: 'organizations/12345').names.each do |folder_name|
    # name on a folder is in the form `folders/12345`
    google_logging_folder_exclusions(folder: folder_name.split('/')[1]).names.each do |exclusion_name|
      describe google_logging_folder_exclusion(folder: folder_name.split('/')[1], name: exclusion_name) do
        its('name'){ should cmp 'inspec-folder-exclusion' }
        its('description'){ should cmp 'My folder exclusion description' }
        its('filter'){ should cmp 'resource.type = gce_instance AND severity <= DEBUG' }
      end
    end
  end
end
```

## Properties

Properties that can be accessed from the `google_logging_folder_exclusion` resource:

`folder`
: Id of the folder that this exclusion applies to.

`name`
: Name of the exclusion, specified by the server during create.

`description`
: A user provided description of this exclusion.

`filter`
: An advanced logs filter. The only exported log entries are those that are in the resource owning the sink and that match the filter.

`disabled`
: If set to true then this exclusion is disabled and it does not exclude any log entries.

## GCP Permissions

Ensure the [Stackdriver Logging API](https://console.cloud.google.com/apis/library/logging.googleapis.com/) is enabled for the current project.
