/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 \u00a8\u0006$"}, d2={"Landroid/databinding/cli/GenerateBaseClassesOptions;", "", "()V", "classInfoOut", "Ljava/io/File;", "getClassInfoOut", "()Ljava/io/File;", "setClassInfoOut", "(Ljava/io/File;)V", "dependencyClassInfoFolders", "", "getDependencyClassInfoFolders", "()Ljava/util/List;", "setDependencyClassInfoFolders", "(Ljava/util/List;)V", "layoutInfoFolder", "getLayoutInfoFolder", "setLayoutInfoFolder", "packageName", "", "getPackageName", "()Ljava/lang/String;", "setPackageName", "(Ljava/lang/String;)V", "sourceFileOut", "getSourceFileOut", "setSourceFileOut", "useAndroidX", "", "getUseAndroidX", "()Z", "setUseAndroidX", "(Z)V", "zipSourceOutput", "getZipSourceOutput", "setZipSourceOutput", "exec"})
public final class GenerateBaseClassesOptions {
    @Parameter(names={"-layoutInfoFiles"}, required=true, converter=FileConverter.class, description="The zip file containing the layout info files that were extracted from layout files in the resource processing step.")
    @NotNull
    public File layoutInfoFolder;
    @Parameter(names={"-dependencyClassInfoList"}, required=false, converter=FileConverter.class, description="The list of class info files that were extracted from dependencies. That is basically this task's output when it was run for the dependency")
    @NotNull
    private List<? extends File> dependencyClassInfoFolders = CollectionsKt.emptyList();
    @Parameter(names={"-package"}, required=true, description="The package name of the application. This should be the same package that R file uses.")
    @NotNull
    public String packageName;
    @Parameter(names={"-classInfoOut"}, required=true, description="The output file where this task will generate the class info file. That metadata should be passed down to dependants")
    @NotNull
    public File classInfoOut;
    @Parameter(names={"-sourceOut"}, required=true, description="The location of the zip file where this task should generate java sources.")
    @NotNull
    public File sourceFileOut;
    @Parameter(names={"-zipSourceOutput"}, required=false, description="Specifies whether the source output should be exported as 1 zip file instead of a folder.", arity=1)
    private boolean zipSourceOutput = true;
    @Parameter(names={"-useAndroidX"}, required=false, description="Specifies whether data binding should use androidX packages or not", arity=1)
    private boolean useAndroidX = true;

    @NotNull
    public final File getLayoutInfoFolder() {
        File file = this.layoutInfoFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutInfoFolder");
        }
        return file;
    }

    public final void setLayoutInfoFolder(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.layoutInfoFolder = file;
    }

    @NotNull
    public final List<File> getDependencyClassInfoFolders() {
        return this.dependencyClassInfoFolders;
    }

    public final void setDependencyClassInfoFolders(@NotNull List<? extends File> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.dependencyClassInfoFolders = list;
    }

    @NotNull
    public final String getPackageName() {
        String string = this.packageName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageName");
        }
        return string;
    }

    public final void setPackageName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final File getClassInfoOut() {
        File file = this.classInfoOut;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classInfoOut");
        }
        return file;
    }

    public final void setClassInfoOut(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.classInfoOut = file;
    }

    @NotNull
    public final File getSourceFileOut() {
        File file = this.sourceFileOut;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceFileOut");
        }
        return file;
    }

    public final void setSourceFileOut(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.sourceFileOut = file;
    }

    public final boolean getZipSourceOutput() {
        return this.zipSourceOutput;
    }

    public final void setZipSourceOutput(boolean bl) {
        this.zipSourceOutput = bl;
    }

    public final boolean getUseAndroidX() {
        return this.useAndroidX;
    }

    public final void setUseAndroidX(boolean bl) {
        this.useAndroidX = bl;
    }
}

