/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalDetection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001e\u001a\u00020\b2\b\b\u0002\u0010\u001f\u001a\u00020 R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "", "width", "", "height", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "ansiHyperLinks", "", "outputInteractive", "inputInteractive", "crClearsLine", "(IILcom/github/ajalt/mordant/rendering/AnsiLevel;ZZZZ)V", "getAnsiHyperLinks", "()Z", "setAnsiHyperLinks", "(Z)V", "getAnsiLevel", "()Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "setAnsiLevel", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;)V", "getCrClearsLine", "<set-?>", "getHeight", "()I", "getInputInteractive", "interactive", "getInteractive", "getOutputInteractive", "getWidth", "updateTerminalSize", "timeoutMs", "", "mordant"})
public final class TerminalInfo {
    @NotNull
    private AnsiLevel ansiLevel;
    private boolean ansiHyperLinks;
    private final boolean outputInteractive;
    private final boolean inputInteractive;
    private final boolean crClearsLine;
    private int width;
    private int height;

    public TerminalInfo(int width, int height, @NotNull AnsiLevel ansiLevel, boolean ansiHyperLinks, boolean outputInteractive, boolean inputInteractive, boolean crClearsLine) {
        Intrinsics.checkNotNullParameter((Object)ansiLevel, "ansiLevel");
        this.ansiLevel = ansiLevel;
        this.ansiHyperLinks = ansiHyperLinks;
        this.outputInteractive = outputInteractive;
        this.inputInteractive = inputInteractive;
        this.crClearsLine = crClearsLine;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final AnsiLevel getAnsiLevel() {
        return this.ansiLevel;
    }

    public final void setAnsiLevel(@NotNull AnsiLevel ansiLevel) {
        Intrinsics.checkNotNullParameter((Object)ansiLevel, "<set-?>");
        this.ansiLevel = ansiLevel;
    }

    public final boolean getAnsiHyperLinks() {
        return this.ansiHyperLinks;
    }

    public final void setAnsiHyperLinks(boolean bl) {
        this.ansiHyperLinks = bl;
    }

    public final boolean getOutputInteractive() {
        return this.outputInteractive;
    }

    public final boolean getInputInteractive() {
        return this.inputInteractive;
    }

    public final boolean getCrClearsLine() {
        return this.crClearsLine;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final boolean getInteractive() {
        return this.inputInteractive && this.inputInteractive;
    }

    public final boolean updateTerminalSize(long timeoutMs) {
        Pair<Integer, Integer> pair2 = TerminalDetection.INSTANCE.detectSize(timeoutMs);
        if (pair2 == null) {
            return false;
        }
        Pair<Integer, Integer> pair3 = pair2;
        int w = ((Number)pair3.component1()).intValue();
        int h = ((Number)pair3.component2()).intValue();
        this.width = w;
        this.height = h;
        return true;
    }

    public static /* synthetic */ boolean updateTerminalSize$default(TerminalInfo terminalInfo, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 5000L;
        }
        return terminalInfo.updateTerminalSize(l);
    }
}

