/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.SetDictNodeGen;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class SetDictNode
extends PNodeWithContext {
    public abstract void execute(Node var1, Object var2, PDict var3);

    public static void executeUncached(Object object, PDict dict) {
        SetDictNodeGen.getUncached().execute(null, object, dict);
    }

    @Specialization
    static void doPythonClass(Node inliningTarget, PythonClass object, PDict dict, @Cached.Shared @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached InlinedBranchProfile hasMroShapeProfile) {
        object.setDictHiddenProp(inliningTarget, writeHiddenAttrNode, hasMroShapeProfile, dict);
    }

    @Specialization(guards={"!isPythonClass(object)"})
    static void doPythonObjectNotClass(Node inliningTarget, PythonObject object, PDict dict, @Cached.Shared @Cached HiddenAttr.WriteNode writeHiddenAttrNode) {
        object.setDict(inliningTarget, writeHiddenAttrNode, dict);
    }

    @Specialization
    void doNativeObject(PythonAbstractNativeObject object, PDict dict, @Cached(inline=false) CApiTransitions.PythonToNativeNode objectToSulong, @Cached(inline=false) CApiTransitions.PythonToNativeNode dictToSulong, @Cached(inline=false) CExtNodes.PCallCapiFunction callGetDictNode, @Cached(inline=false) ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkResult) {
        assert (!TypeNodes.IsTypeNode.executeUncached(object));
        PythonContext context = this.getContext();
        Object result = callGetDictNode.call(NativeCAPISymbol.FUN_PY_OBJECT_GENERIC_SET_DICT, objectToSulong.execute(object), dictToSulong.execute(dict), context.getNativeNull());
        checkResult.execute(context, NativeCAPISymbol.FUN_PY_OBJECT_GENERIC_SET_DICT.getTsName(), result);
    }

    protected static boolean isPythonClass(Object object) {
        return object instanceof PythonClass;
    }
}

