/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayBufferByteLengthNode;
import com.oracle.truffle.js.nodes.array.GetViewByteLengthNodeGen;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;

@ImportStatic(value={JSDataView.class})
public abstract class GetViewByteLengthNode
extends JavaScriptBaseNode {
    public abstract int execute(JSDataViewObject var1, JSContext var2);

    @Specialization(guards={"!isOutOfBounds(dataView, context)", "!dataView.hasAutoLength()"})
    protected static int doFixedLength(JSDataViewObject dataView, JSContext context) {
        assert (!JSDataView.isOutOfBounds(dataView, context));
        return dataView.getByteLengthFixed();
    }

    @Specialization(guards={"!isOutOfBounds(dataView, context)", "dataView.hasAutoLength()"})
    protected final int doAutoLength(JSDataViewObject dataView, JSContext context, @Cached ArrayBufferByteLengthNode getByteLengthNode) {
        assert (!JSDataView.isOutOfBounds(dataView, context));
        JSArrayBufferObject arrayBuffer = dataView.getArrayBuffer();
        int byteLength = getByteLengthNode.execute(this, arrayBuffer, context);
        int byteOffset = dataView.getByteOffset();
        return byteLength - byteOffset;
    }

    @Specialization(guards={"isOutOfBounds(dataView, context)"})
    protected static int doOutOfBounds(JSDataViewObject dataView, JSContext context) {
        return 0;
    }

    @NeverDefault
    public static GetViewByteLengthNode create() {
        return GetViewByteLengthNodeGen.create();
    }
}

