/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb.io;

import java.io.IOException;
import java.io.Reader;

public class LimitedReader
extends Reader {
    private final Reader source;
    private final long maxCharsToRead;
    private long charsRead;

    public LimitedReader(Reader source, long maxCharsToRead) {
        if (source == null) {
            throw new IllegalArgumentException("Source Reader cannot be null");
        }
        if (maxCharsToRead < 0L) {
            throw new IllegalArgumentException("maxCharsToRead must be non-negative");
        }
        this.source = source;
        this.maxCharsToRead = maxCharsToRead;
        this.charsRead = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.charsRead >= this.maxCharsToRead) {
            return -1;
        }
        int result = this.source.read();
        if (result != -1) {
            ++this.charsRead;
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.charsRead >= this.maxCharsToRead) {
            return -1;
        }
        long charsRemaining = this.maxCharsToRead - this.charsRead;
        int charsToRead = (int)Math.min((long)len, charsRemaining);
        int result = this.source.read(cbuf, off, charsToRead);
        if (result != -1) {
            this.charsRead += (long)result;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

