/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Intervals;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQuery;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsQueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.IntervalsVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IntervalsFuzzy
implements IntervalsVariant,
IntervalsQueryVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, IntervalsFuzzy> {
    @Nullable
    private final String analyzer;
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer prefixLength;
    @Nonnull
    private final String term;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsFuzzy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsFuzzy::setupIntervalsFuzzyDeserializer);

    private IntervalsFuzzy(Builder builder) {
        this.analyzer = builder.analyzer;
        this.fuzziness = builder.fuzziness;
        this.prefixLength = builder.prefixLength;
        this.term = ApiTypeHelper.requireNonNull(builder.term, this, "term");
        this.transpositions = builder.transpositions;
        this.useField = builder.useField;
    }

    public static IntervalsFuzzy of(Function<Builder, ObjectBuilder<IntervalsFuzzy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Fuzzy;
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Fuzzy;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nonnull
    public final String term() {
        return this.term;
    }

    @Nullable
    public final Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        generator.writeKey("term");
        generator.write(this.term);
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIntervalsFuzzyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.fuzziness);
        result = 31 * result + Objects.hashCode(this.prefixLength);
        result = 31 * result + this.term.hashCode();
        result = 31 * result + Objects.hashCode(this.transpositions);
        result = 31 * result + Objects.hashCode(this.useField);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalsFuzzy other = (IntervalsFuzzy)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && this.term.equals(other.term) && Objects.equals(this.transpositions, other.transpositions) && Objects.equals(this.useField, other.useField);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IntervalsFuzzy> {
        @Nullable
        private String analyzer;
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer prefixLength;
        private String term;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private String useField;

        public Builder() {
        }

        private Builder(IntervalsFuzzy o) {
            this.analyzer = o.analyzer;
            this.fuzziness = o.fuzziness;
            this.prefixLength = o.prefixLength;
            this.term = o.term;
            this.transpositions = o.transpositions;
            this.useField = o.useField;
        }

        private Builder(Builder o) {
            this.analyzer = o.analyzer;
            this.fuzziness = o.fuzziness;
            this.prefixLength = o.prefixLength;
            this.term = o.term;
            this.transpositions = o.transpositions;
            this.useField = o.useField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        @Nonnull
        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        @Nonnull
        public final Builder term(String value) {
            this.term = value;
            return this;
        }

        @Nonnull
        public final Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        @Nonnull
        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        @Nonnull
        public IntervalsFuzzy build() {
            this._checkSingleUse();
            return new IntervalsFuzzy(this);
        }
    }
}

