/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.Lst;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.PanelListener;
import jspecview.api.VisibleInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.GraphSet;
import jspecview.common.Integral;
import jspecview.common.JSVFileManager;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.PrintLayout;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.dialog.JSVDialog;
import org.jmol.api.EventManager;
import org.jmol.api.GenericGraphics;
import org.jmol.util.Font;
import org.jmol.util.Logger;

public class PanelData
implements EventManager {
    public GenericGraphics g2d;
    public GenericGraphics g2d0;
    JSViewer vwr;
    private Lst<PanelListener> listeners = new Lst();
    private GraphSet currentGraphSet;
    public Hashtable<ScriptToken, Object> options = new Hashtable();
    public JSVPanel jsvp;
    public Lst<GraphSet> graphSets;
    public int currentSplitPoint;
    public PlotWidget thisWidget;
    public Coordinate coordClicked;
    public Coordinate[] coordsClicked;
    public static final int defaultPrintHeight = 450;
    public static final int defaultPrintWidth = 280;
    public static final int topMargin = 40;
    public static final int bottomMargin = 50;
    public static final int leftMargin = 60;
    public static final int rightMargin = 50;
    public boolean ctrlPressed;
    public boolean shiftPressed;
    public boolean drawXAxisLeftToRight;
    public boolean isIntegralDrag;
    public boolean xAxisLeftToRight = true;
    public int scalingFactor = 1;
    public int integralShiftMode;
    public int left = 60;
    public int right = 50;
    public String coordStr = "";
    public String startupPinTip = "Click to set.";
    public String title;
    int clickCount;
    private int nSpectra;
    public int thisWidth;
    private int thisHeight;
    private int startIndex;
    private int endIndex;
    private String commonFilePath;
    private String viewTitle;
    private String displayFontName;
    private String titleFontName;
    public boolean isPrinting;
    private boolean doReset = true;
    public String printingFontName;
    public String printGraphPosition = "default";
    public boolean titleDrawn;
    public boolean display1D;
    public boolean isLinked;
    public String printJobTitle;
    public Lst<Spectrum> spectra;
    private boolean taintedAll = true;
    private boolean testingJavaScript;
    private Font currentFont;
    private Mouse mouseState;
    public boolean gridOn;
    public boolean titleOn;
    public boolean peakTabsOn;
    public int mouseX;
    public int mouseY;
    private boolean linking;
    public int xPixelClicked;
    public GenericColor coordinatesColor;
    public GenericColor gridColor;
    public GenericColor integralPlotColor;
    public GenericColor peakTabColor;
    public GenericColor plotAreaColor;
    public GenericColor scaleColor;
    public GenericColor titleColor;
    public GenericColor unitsColor;
    public GenericColor highlightColor;
    public GenericColor zoomBoxColor;
    public GenericColor zoomBoxColor2;
    public GenericColor BLACK;
    public GenericColor bgcolor;
    public Hashtable<ScriptToken, Object> optionsSaved;
    private Object gMain;

    public PanelData(JSVPanel panel, JSViewer viewer) {
        this.vwr = viewer;
        this.jsvp = panel;
        this.g2d = this.g2d0 = viewer.g2d;
        this.BLACK = this.g2d.getColor1(0);
        this.highlightColor = this.g2d.getColor4(255, 0, 0, 200);
        this.zoomBoxColor = this.g2d.getColor4(150, 150, 100, 130);
        this.zoomBoxColor2 = this.g2d.getColor4(150, 100, 100, 130);
    }

    public void addListener(PanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addLast(listener);
        }
    }

    public GraphSet getCurrentGraphSet() {
        return this.currentGraphSet;
    }

    public void dispose() {
        this.jsvp = null;
        for (int i = 0; i < this.graphSets.size(); ++i) {
            ((GraphSet)this.graphSets.get(i)).dispose();
        }
        this.graphSets = null;
        this.currentFont = null;
        this.currentGraphSet = null;
        this.coordClicked = null;
        this.coordsClicked = null;
        this.thisWidget = null;
        this.options = null;
        this.listeners = null;
    }

    public void setViewTitle(String title) {
        this.viewTitle = title;
    }

    public String getViewTitle() {
        return this.viewTitle == null ? this.getTitle() : this.viewTitle;
    }

    public Map<String, Object> getInfo(boolean selectedOnly, String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        Lst<Map<String, Object>> sets = null;
        if (selectedOnly) {
            return this.currentGraphSet.getInfo(key, this.getCurrentSpectrumIndex());
        }
        Set<Map.Entry<ScriptToken, Object>> entries = this.options.entrySet();
        if ("".equals(key)) {
            Object val = "type title nSets ";
            for (Map.Entry<ScriptToken, Object> entry : entries) {
                val = (String)val + entry.getKey().name() + " ";
            }
            info.put("KEYS", val);
        } else {
            for (Map.Entry entry : entries) {
                Parameters.putInfo(key, info, ((ScriptToken)((Object)entry.getKey())).name(), entry.getValue());
            }
            Parameters.putInfo(key, info, "type", this.getSpectrumAt(0).getDataType());
            Parameters.putInfo(key, info, "title", this.title);
            Parameters.putInfo(key, info, "nSets", this.graphSets.size());
        }
        sets = new Lst<Map<String, Object>>();
        int i = this.graphSets.size();
        while (--i >= 0) {
            sets.addLast(((GraphSet)this.graphSets.get(i)).getInfo(key, -1));
        }
        info.put("sets", sets);
        return info;
    }

    public void setBooleans(Parameters parameters, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, Boolean> booleans = parameters.getBooleans();
            for (Map.Entry<ScriptToken, Boolean> entry : booleans.entrySet()) {
                this.setBooleans(parameters, entry.getKey());
            }
            return;
        }
        this.setBoolean(st, parameters.getBoolean(st));
    }

    public void setBoolean(ScriptToken st, boolean isTrue) {
        this.setTaintedAll();
        if (st == ScriptToken.REVERSEPLOT) {
            this.currentGraphSet.setReversePlot(isTrue);
            return;
        }
        this.options.put(st, isTrue);
        switch (st) {
            case DISPLAY1D: 
            case DISPLAY2D: {
                this.doReset = true;
            }
        }
    }

    public boolean getBoolean(ScriptToken st) {
        if (st == ScriptToken.REVERSEPLOT) {
            return this.currentGraphSet.reversePlot;
        }
        if (this.options == null) {
            return false;
        }
        Object b = this.options.get((Object)st);
        return b != null && b instanceof Boolean && (Boolean)b == Boolean.TRUE;
    }

    public void setFontName(ScriptToken st, String fontName) {
        switch (st) {
            case DISPLAYFONTNAME: {
                this.displayFontName = fontName;
                break;
            }
            case TITLEFONTNAME: {
                this.titleFontName = fontName;
            }
        }
        if (fontName != null) {
            this.options.put(st, fontName);
        }
    }

    public boolean getDisplay1D() {
        return this.display1D;
    }

    public void setTaintedAll() {
        this.taintedAll = true;
    }

    public void initOne(Spectrum spectrum) {
        this.spectra = new Lst();
        this.spectra.addLast(spectrum);
        this.initMany(this.spectra, 0, 0);
    }

    public void initMany(Lst<Spectrum> spectra, int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.nSpectra = spectra.size();
        this.spectra = spectra;
        this.commonFilePath = ((Spectrum)spectra.get(0)).getFilePath();
        for (int i = 0; i < this.nSpectra; ++i) {
            if (this.commonFilePath.equalsIgnoreCase(((Spectrum)spectra.get(i)).getFilePath())) continue;
            this.commonFilePath = null;
            break;
        }
        this.setGraphSets(LinkMode.NONE);
    }

    private void setGraphSets(LinkMode linkMode) {
        this.graphSets = GraphSet.createGraphSetsAndSetLinkMode(this, this.jsvp, this.spectra, this.startIndex, this.endIndex, linkMode);
        this.currentGraphSet = (GraphSet)this.graphSets.get(0);
        this.title = this.getSpectrum().getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        for (int i = 0; i < this.graphSets.size() && (pi2 = ((GraphSet)this.graphSets.get(i)).findMatchingPeakInfo(pi)) == null; ++i) {
        }
        return pi2;
    }

    public void integrateAll(ColorParameters parameters) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).integrate(-1, parameters);
        }
    }

    public int getNumberOfGraphSets() {
        return this.graphSets.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void refresh() {
        this.doReset = true;
    }

    public void addAnnotation(Lst<String> tokens) {
        String title = this.currentGraphSet.addAnnotation(tokens, this.getTitle());
        if (title != null) {
            this.title = title;
        }
    }

    public void addPeakHighlight(PeakInfo peakInfo) {
        for (int i = 0; i < this.graphSets.size(); ++i) {
            ((GraphSet)this.graphSets.get(i)).addPeakHighlight(peakInfo);
        }
    }

    public PeakInfo selectPeakByFileIndex(String filePath, String index, String atomKey) {
        PeakInfo pi;
        block1: {
            pi = this.currentGraphSet.selectPeakByFileIndex(filePath, index, atomKey);
            if (pi != null) break block1;
            int i = this.graphSets.size();
            while (--i >= 0 && (this.graphSets.get(i) == this.currentGraphSet || (pi = ((GraphSet)this.graphSets.get(i)).selectPeakByFileIndex(filePath, index, atomKey)) == null)) {
            }
        }
        return pi;
    }

    public void setPlotColors(GenericColor[] colors) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).setPlotColors(colors);
        }
    }

    public void selectSpectrum(String filePath, String type, String model, boolean andCurrent) {
        if (andCurrent) {
            this.currentGraphSet.selectSpectrum(filePath, type, model);
        }
        if ("ID".equals(type)) {
            this.jumpToSpectrumIndex(this.getCurrentSpectrumIndex(), true);
            return;
        }
        for (int i = 0; i < this.graphSets.size(); ++i) {
            if (this.graphSets.get(i) == this.currentGraphSet) continue;
            ((GraphSet)this.graphSets.get(i)).selectSpectrum(filePath, type, model);
        }
    }

    public boolean hasFileLoaded(String filePath) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            if (!((GraphSet)this.graphSets.get(i)).hasFileLoaded(filePath)) continue;
            return true;
        }
        return false;
    }

    public void clearAllView() {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).resetViewCompletely();
        }
    }

    public synchronized void drawGraph(Object gMain, Object gFront, Object gRear, int width, int height, boolean addFilePath) {
        boolean withCoords;
        boolean isResized;
        this.gMain = gMain;
        this.display1D = !this.isLinked && this.getBoolean(ScriptToken.DISPLAY1D);
        int top = 40;
        int bottom = 50;
        boolean bl = isResized = this.isPrinting || this.doReset || this.thisWidth != width || this.thisHeight != height;
        if (isResized) {
            this.setTaintedAll();
        }
        if (this.taintedAll) {
            this.g2d.fillBackground(gRear, this.bgcolor);
        }
        if (gFront != gMain) {
            this.g2d.fillBackground(gFront, null);
            if (gMain != gRear) {
                this.g2d.fillBackground(gMain, null);
            }
            this.g2d.setStrokeBold(gMain, false);
        }
        if (this.isPrinting) {
            top *= 3;
            bottom *= 3;
            this.scalingFactor = 10;
            withCoords = false;
        } else {
            this.scalingFactor = 1;
            withCoords = this.getBoolean(ScriptToken.COORDINATESON);
            this.titleOn = this.getBoolean(ScriptToken.TITLEON);
            this.gridOn = this.getBoolean(ScriptToken.GRIDON);
            this.peakTabsOn = this.getBoolean(ScriptToken.PEAKTABSON);
        }
        boolean pointsOnly = this.getBoolean(ScriptToken.POINTSONLY);
        this.doReset = false;
        this.titleDrawn = false;
        this.thisWidth = width;
        this.thisHeight = height;
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).drawGraphSet(gMain, gFront, gRear, width, height, this.left, this.right, top, bottom, isResized, this.taintedAll, pointsOnly);
        }
        if (this.titleOn && !this.titleDrawn && this.taintedAll) {
            this.drawTitle(gMain, height * this.scalingFactor, width * this.scalingFactor, this.getDrawTitle(this.isPrinting));
        }
        if (withCoords && this.coordStr != null) {
            this.drawCoordinates(gFront, top, this.thisWidth - this.right, top - 20);
        }
        if (addFilePath && this.taintedAll) {
            this.printFilePath(gMain, this.left, height, this.commonFilePath != null ? this.commonFilePath : (this.graphSets.size() == 1 && this.currentGraphSet.getTitle(true) != null ? this.getSpectrum().getFilePath() : null));
        }
        if (this.isPrinting) {
            this.printVersion(gMain, height);
        }
        if (!this.testingJavaScript && (this.isPrinting || gMain == gFront)) {
            this.setTaintedAll();
        } else {
            this.taintedAll = false;
        }
    }

    public void drawCoordinates(Object g, int top, int x, int y) {
        this.g2d.setGraphicsColor(g, this.coordinatesColor);
        Font font = this.setFont(g, this.jsvp.getWidth(), 1, 14.0f, true);
        this.g2d.drawString(g, this.coordStr, x - font.stringWidth(this.coordStr), y);
    }

    public Font setFont(Object g, int width, int style, float size, boolean isLabel) {
        return this.g2d.setFont(g, this.getFont(g, width, style, size, isLabel));
    }

    public void printFilePath(Object g, int x, int y, String s) {
        if (s == null) {
            return;
        }
        x *= this.scalingFactor;
        y *= this.scalingFactor;
        if (s.indexOf("?") > 0) {
            s = s.substring(s.indexOf("?") + 1);
        }
        s = s.substring(s.lastIndexOf("/") + 1);
        s = s.substring(s.lastIndexOf("\\") + 1);
        this.g2d.setGraphicsColor(g, this.BLACK);
        Font font = this.setFont(g, 1000, 0, 9.0f, true);
        if (x != this.left * this.scalingFactor) {
            x -= font.stringWidth(s);
        }
        this.g2d.drawString(g, s, x, y - font.getHeight());
    }

    public void printVersion(Object g, int pageHeight) {
        this.g2d.setGraphicsColor(g, this.BLACK);
        Font font = this.setFont(g, 100, 0, 12.0f, true);
        String s = this.jsvp.getApiPlatform().getDateFormat(null) + " JSpecView " + JSVersion.VERSION_SHORT;
        int w = font.stringWidth(s);
        this.g2d.drawString(g, s, (this.thisWidth - this.right) * this.scalingFactor - w, pageHeight * this.scalingFactor - font.getHeight() * 3);
    }

    public void drawTitle(Object g, int pageHeight, int pageWidth, String title) {
        title = title.replace('\n', ' ');
        Font font = this.getFont(g, pageWidth, this.isPrinting || this.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, 14.0f, true);
        int nPixels = font.stringWidth(title);
        if (nPixels > pageWidth) {
            int size = (int)(14.0 * (double)pageWidth / (double)nPixels);
            if (size < 10) {
                size = 10;
            }
            font = this.getFont(g, pageWidth, this.isPrinting || this.getBoolean(ScriptToken.TITLEBOLDON) ? 1 : 0, size, true);
        }
        this.g2d.setGraphicsColor(g, this.titleColor);
        this.setCurrentFont(this.g2d.setFont(g, font));
        this.g2d.drawString(g, title, this.isPrinting ? this.left * this.scalingFactor : 5, pageHeight - (int)((double)font.getHeight() * (this.isPrinting ? 2.0 : 0.5)));
    }

    private void setCurrentFont(Font font) {
        this.currentFont = font;
    }

    int getFontHeight() {
        return this.currentFont.getAscent();
    }

    int getStringWidth(String s) {
        return this.currentFont.stringWidth(s);
    }

    public void selectFromEntireSet(int iSpec) {
        int pt = 0;
        for (int i = 0; i < this.graphSets.size(); ++i) {
            if (iSpec == Integer.MIN_VALUE) {
                ((GraphSet)this.graphSets.get(i)).setSelected(-1);
                continue;
            }
            Lst<Spectrum> specs = ((GraphSet)this.graphSets.get((int)i)).spectra;
            int j = 0;
            while (j < specs.size()) {
                if (iSpec < 0 || iSpec == pt) {
                    ((GraphSet)this.graphSets.get(i)).setSelected(j);
                }
                ++j;
                ++pt;
            }
        }
    }

    public void addToList(int iSpec, Lst<Spectrum> list) {
        for (int i = 0; i < this.spectra.size(); ++i) {
            if (iSpec >= 0 && i != iSpec) continue;
            list.addLast((Spectrum)this.spectra.get(i));
        }
    }

    public void scaleSelectedBy(double f) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).scaleSelectedBy(f);
        }
    }

    boolean setCurrentGraphSet(GraphSet gs, int yPixel) {
        int splitPoint = gs.nSplit > 1 ? gs.getSplitPoint(yPixel) : gs.getCurrentSpectrumIndex();
        boolean isNewSet = this.currentGraphSet != gs;
        boolean isNewSplitPoint = isNewSet || this.currentSplitPoint != splitPoint;
        this.currentGraphSet = gs;
        this.currentSplitPoint = splitPoint;
        if (isNewSet || gs.nSplit > 1 && isNewSplitPoint) {
            this.setSpectrum(splitPoint, true);
        }
        if (!isNewSet) {
            isNewSet = gs.checkSpectrumClickedEvent(this.mouseX, this.mouseY, this.clickCount);
            if (!isNewSet) {
                return false;
            }
            this.currentSplitPoint = splitPoint = gs.getCurrentSpectrumIndex();
            this.setSpectrum(splitPoint, true);
        }
        this.jumpToSpectrumIndex(splitPoint, isNewSet || gs.nSplit > 1 && isNewSplitPoint);
        return isNewSet;
    }

    public void jumpToSpectrum(Spectrum spec) {
        int index = this.currentGraphSet.getSpectrumIndex(spec);
        this.jumpToSpectrumIndex(index, true);
    }

    public void jumpToSpectrumIndex(int index, boolean doSetSpec) {
        if (index < 0 || index >= this.currentGraphSet.nSpectra) {
            return;
        }
        this.currentSplitPoint = index;
        if (doSetSpec) {
            this.setSpectrum(this.currentSplitPoint, this.currentGraphSet.nSplit > 1);
        }
        Spectrum spec = this.getSpectrum();
        this.notifySubSpectrumChange(spec.getSubIndex(), spec);
    }

    public void splitStack(boolean doSplit) {
        this.currentGraphSet.splitStack(doSplit);
    }

    public int getNumberOfSpectraInCurrentSet() {
        return this.currentGraphSet.nSpectra;
    }

    public String getSourceID() {
        String id = this.getSpectrum().sourceID;
        return id == null ? this.getSpectrumAt((int)0).sourceID : id;
    }

    public int getStartingPointIndex(int index) {
        return this.currentGraphSet.viewData.getStartingPointIndex(index);
    }

    public int getEndingPointIndex(int index) {
        return this.currentGraphSet.viewData.getEndingPointIndex(index);
    }

    public boolean haveSelectedSpectrum() {
        return this.currentGraphSet.haveSelectedSpectrum();
    }

    public boolean getShowAnnotation(Annotation.AType type) {
        return this.currentGraphSet.getShowAnnotation(type, -1);
    }

    public void showAnnotation(Annotation.AType type, Boolean tfToggle) {
        this.currentGraphSet.setShowAnnotation(type, tfToggle);
    }

    public void setYStackOffsetPercent(int offset) {
        this.currentGraphSet.yStackOffsetPercent = offset;
    }

    public void setSpectrum(int iSpec, boolean isSplit) {
        this.currentGraphSet.setSpectrum(iSpec, isSplit);
    }

    public Spectrum getSpectrum() {
        return this.currentGraphSet.getSpectrum();
    }

    public void setSpecForIRMode(Spectrum spec) {
        this.setTaintedAll();
        Spectrum spec0 = this.currentGraphSet.getSpectrum();
        this.currentGraphSet.setSpectrumJDX(spec);
        for (int i = 0; i < this.spectra.size(); ++i) {
            if (this.spectra.get(i) != spec0) continue;
            this.spectra.set(i, spec);
        }
    }

    public boolean isShowAllStacked() {
        return this.currentGraphSet.showAllStacked;
    }

    public int getCurrentSpectrumIndex() {
        return this.currentGraphSet.getCurrentSpectrumIndex();
    }

    public Spectrum getSpectrumAt(int index) {
        if (this.currentGraphSet == null) {
            return null;
        }
        return this.currentGraphSet.getSpectrumAt(index);
    }

    public void addHighlight(GraphSet gs, double x1, double x2, Spectrum spec, int r, int g, int b, int a) {
        (gs == null ? this.currentGraphSet : gs).addHighlight(x1, x2, spec, this.g2d.getColor4(r, g, b, a));
    }

    public void removeHighlight(double x1, double x2) {
        this.currentGraphSet.removeHighlight(x1, x2);
    }

    public void removeAllHighlights() {
        this.currentGraphSet.removeAllHighlights();
    }

    public void setZoom(double x1, double y1, double x2, double y2) {
        this.currentGraphSet.setZoom(x1, y1, x2, y2);
        this.doReset = true;
        this.setTaintedAll();
        this.notifyListeners(new ZoomEvent());
    }

    public void resetView() {
        this.currentGraphSet.resetView();
    }

    public void previousView() {
        this.currentGraphSet.previousView();
    }

    public void nextView() {
        this.currentGraphSet.nextView();
    }

    public Integral getSelectedIntegral() {
        return this.currentGraphSet.getSelectedIntegral();
    }

    public void advanceSubSpectrum(int dir) {
        this.currentGraphSet.advanceSubSpectrum(dir);
    }

    public void setSelectedIntegral(double val) {
        this.currentGraphSet.setSelectedIntegral(val);
    }

    public void scaleYBy(double f) {
        this.currentGraphSet.scaleYBy(f);
    }

    public void toPeak(int i) {
        this.currentGraphSet.toPeak(i);
    }

    public Coordinate getClickedCoordinate() {
        return this.coordClicked;
    }

    public boolean getPickedCoordinates(Coordinate coord, Coordinate actualCoord) {
        return Coordinate.getPickedCoordinates(this.coordsClicked, this.coordClicked, coord, actualCoord);
    }

    public boolean shiftSpectrum(int mode, double xOld, double xNew) {
        return this.currentGraphSet.shiftSpectrum(mode, xOld, xNew);
    }

    public void findX(Spectrum spec, double d) {
        this.currentGraphSet.setXPointer(spec, d);
    }

    public void setXPointers(Spectrum spec, double x1, Spectrum spec2, double x2) {
        this.currentGraphSet.setXPointer(spec, x1);
        this.currentGraphSet.setXPointer2(spec2, x2);
    }

    public boolean isCurrentGraphSet(GraphSet graphSet) {
        return graphSet == this.currentGraphSet;
    }

    public void repaint() {
        this.jsvp.doRepaint(false);
    }

    public void setToolTipText(String s) {
        this.jsvp.setToolTipText(s);
    }

    public void setHighlightColor(GenericColor color) {
        this.setColor(ScriptToken.HIGHLIGHTCOLOR, color);
    }

    String getInput(String message, String title, String sval) {
        return this.jsvp.getInput(message, title, sval);
    }

    private Font getFont(Object g, int width, int style, float size, boolean isLabel) {
        size *= (float)this.scalingFactor;
        if (isLabel) {
            if (width < 400) {
                size = (float)width * size / 400.0f;
            }
        } else if (width < 250) {
            size = (float)width * size / 250.0f;
        }
        int face = this.jsvp.getFontFaceID(this.isPrinting ? this.printingFontName : this.displayFontName);
        this.currentFont = Font.createFont3D(face, style, size, size, 0.0f, this.jsvp.getApiPlatform(), g);
        return this.currentFont;
    }

    public void notifySubSpectrumChange(int isub, Spectrum spec) {
        this.notifyListeners(new SubSpecChangeEvent(isub, spec == null ? null : spec.getTitleLabel()));
    }

    public void notifyPeakPickedListeners(PeakPickEvent p) {
        if (p == null) {
            p = new PeakPickEvent(this.jsvp, this.coordClicked, this.getSpectrum().getAssociatedPeakInfo(this.xPixelClicked, this.coordClicked));
        }
        this.notifyListeners(p);
    }

    public void notifyListeners(Object eventObj) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) == null) continue;
            ((PanelListener)this.listeners.get(i)).panelEvent(eventObj);
        }
    }

    public void escapeKeyPressed(boolean isDEL) {
        this.currentGraphSet.escapeKeyPressed(isDEL);
    }

    public boolean hasFocus() {
        return this.jsvp.hasFocus();
    }

    public boolean isMouseUp() {
        return this.mouseState == Mouse.UP;
    }

    public void doMouseMoved(int xPixel, int yPixel) {
        this.mouseX = xPixel;
        this.mouseY = yPixel;
        this.mouseState = Mouse.UP;
        this.clickCount = 0;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        gs.mouseMovedEvent(xPixel, yPixel);
    }

    public void doMousePressed(int xPixel, int yPixel) {
        this.mouseState = Mouse.DOWN;
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        this.setCurrentGraphSet(gs, yPixel);
        ++this.clickCount;
        this.clickCount %= 3;
        this.currentGraphSet.mousePressedEvent(xPixel, yPixel, this.clickCount);
    }

    public void doMouseDragged(int xPixel, int yPixel) {
        this.isIntegralDrag |= this.ctrlPressed;
        this.mouseState = Mouse.DOWN;
        if (GraphSet.findGraphSet(this.graphSets, xPixel, yPixel) != this.currentGraphSet) {
            return;
        }
        if (this.currentGraphSet.checkWidgetEvent(xPixel, yPixel, false)) {
            this.setTaintedAll();
        }
        this.currentGraphSet.mouseMovedEvent(xPixel, yPixel);
    }

    public void doMouseReleased(int xPixel, int yPixel, boolean isButton1) {
        this.mouseState = Mouse.UP;
        if (this.thisWidget == null && this.currentGraphSet.pendingMeasurement == null || !isButton1) {
            return;
        }
        this.currentGraphSet.mouseReleasedEvent(xPixel, yPixel);
        this.thisWidget = null;
        this.isIntegralDrag = false;
        this.integralShiftMode = 0;
    }

    public void doMouseClicked(int xPixel, int yPixel, boolean isControlDown) {
        GraphSet gs = GraphSet.findGraphSet(this.graphSets, xPixel, yPixel);
        if (gs == null) {
            return;
        }
        this.setCurrentGraphSet(gs, yPixel);
        gs.mouseClickedEvent(xPixel, yPixel, this.clickCount, isControlDown);
        this.setTaintedAll();
        this.repaint();
    }

    public boolean hasCurrentMeasurements(Annotation.AType type) {
        return this.currentGraphSet.hasCurrentMeasurement(type);
    }

    public AnnotationData getDialog(Annotation.AType type) {
        return this.currentGraphSet.getDialog(type, -1);
    }

    public void addDialog(int iSpec, Annotation.AType type, AnnotationData dialog) {
        this.currentGraphSet.addDialog(iSpec, type, dialog);
    }

    public void getPeakListing(Parameters p, Boolean tfToggle) {
        if (p != null) {
            this.currentGraphSet.getPeakListing(-1, p, true);
        }
        this.currentGraphSet.setPeakListing(tfToggle);
    }

    public void checkIntegral(Parameters parameters, String value) {
        this.currentGraphSet.checkIntegralParams(parameters, value);
    }

    public void setIntegrationRatios(String value) {
        this.currentGraphSet.setIntegrationRatios(value);
    }

    public ScaleData getView() {
        return this.currentGraphSet.getCurrentView();
    }

    public void closeAllDialogsExcept(Annotation.AType type) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).closeDialogsExcept(type);
        }
    }

    public void removeDialog(JSVDialog dialog) {
        this.currentGraphSet.removeDialog(dialog);
    }

    public void normalizeIntegral() {
        Integral integral = this.getSelectedIntegral();
        if (integral == null) {
            return;
        }
        String sValue = integral.text;
        if (sValue.length() == 0) {
            sValue = "" + integral.getValue();
        }
        String newValue = this.getInput("Enter a new value for this integral", "Normalize Integral", sValue);
        try {
            this.setSelectedIntegral(Double.parseDouble(newValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDrawTitle(boolean isPrinting) {
        String title = null;
        if (isPrinting) {
            title = this.printJobTitle;
        } else if (this.nSpectra == 1) {
            title = this.getSpectrum().getPeakTitle();
        } else if (this.viewTitle != null) {
            if (this.currentGraphSet.getTitle(false) != null) {
                title = this.getSpectrum().getPeakTitle();
            }
            if (title == null) {
                title = this.viewTitle;
            }
        } else {
            title = this.jsvp.getTitle().trim();
        }
        if (title.indexOf("\n") >= 0) {
            title = title.substring(0, title.indexOf("\n")).trim();
        }
        return title;
    }

    public String getPrintJobTitle(boolean isPrinting) {
        String title = null;
        if (this.nSpectra == 1) {
            title = this.getSpectrum().getTitle();
        } else if (this.viewTitle != null) {
            if (this.graphSets.size() == 1) {
                title = this.currentGraphSet.getTitle(isPrinting);
            }
            if (title == null) {
                title = this.viewTitle;
            }
        } else {
            title = this.jsvp.getTitle().trim();
        }
        if (title.indexOf("\n") >= 0) {
            title = title.substring(0, title.indexOf("\n")).trim();
        } else if (title.startsWith("$")) {
            title = title.substring(1);
        }
        return title;
    }

    public synchronized void linkSpectra(LinkMode mode) {
        if (mode == LinkMode.ALL) {
            LinkMode linkMode = this.nSpectra == 2 ? LinkMode.AB : (mode = this.nSpectra == 3 ? LinkMode.ABC : LinkMode.NONE);
        }
        if (mode != LinkMode.NONE && mode.toString().length() != this.nSpectra) {
            return;
        }
        this.setGraphSets(mode);
    }

    public void doZoomLinked(GraphSet graphSet, double initX, double finalX, boolean addZoom, boolean checkRange, boolean is1d) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spec = graphSet.getSpectrumAt(0);
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = (GraphSet)this.graphSets.get(i);
            if (gs == graphSet || !Spectrum.areXScalesCompatible(spec, ((GraphSet)this.graphSets.get(i)).getSpectrumAt(0), false, true)) continue;
            gs.doZoom(initX, 0.0, finalX, 0.0, is1d, false, checkRange, false, addZoom);
        }
        this.linking = false;
    }

    public void clearLinkViews(GraphSet graphSet) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spec = graphSet.getSpectrum();
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = (GraphSet)this.graphSets.get(i);
            if (gs == graphSet || !Spectrum.areXScalesCompatible(spec, ((GraphSet)this.graphSets.get(i)).getSpectrum(), false, true)) continue;
            gs.clearViews();
        }
        this.linking = false;
    }

    public void setlinkedXMove(GraphSet graphSet, double x, boolean isX2) {
        if (this.linking) {
            return;
        }
        this.linking = true;
        Spectrum spec = graphSet.getSpectrum();
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = (GraphSet)this.graphSets.get(i);
            if (gs == graphSet || !Spectrum.areXScalesCompatible(spec, ((GraphSet)this.graphSets.get(i)).getSpectrum(), false, true) || gs.imageView != null) continue;
            if (isX2) {
                gs.setXPixelMovedTo(Double.MAX_VALUE, x, 0, 0);
                continue;
            }
            gs.setXPixelMovedTo(x, Double.MAX_VALUE, 0, 0);
        }
        this.linking = false;
    }

    public void set2DCrossHairsLinked(GraphSet graphSet, double x, double y, boolean isLocked) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            GraphSet gs = (GraphSet)this.graphSets.get(i);
            if (gs == graphSet) continue;
            gs.set2DXY(x, y, isLocked);
        }
    }

    public void dialogsToFront(Spectrum spec) {
        this.currentGraphSet.dialogsToFront(spec);
    }

    public void setColor(ScriptToken st, GenericColor color) {
        if (color != null) {
            this.options.put(st, CU.toRGBHexString(color));
        }
        switch (st) {
            case COORDINATESCOLOR: {
                this.coordinatesColor = color;
                return;
            }
            case HIGHLIGHTCOLOR: {
                this.highlightColor = color;
                if (this.highlightColor.getOpacity255() == 255) {
                    this.highlightColor.setOpacity255(150);
                }
                return;
            }
            case ZOOMBOXCOLOR: {
                this.zoomBoxColor = color;
                return;
            }
            case ZOOMBOXCOLOR2: {
                this.zoomBoxColor2 = color;
                return;
            }
            case BACKGROUNDCOLOR: {
                this.bgcolor = color;
                this.jsvp.setBackgroundColor(this.bgcolor);
                break;
            }
            case GRIDCOLOR: {
                this.gridColor = color;
                break;
            }
            case INTEGRALPLOTCOLOR: {
                this.integralPlotColor = color;
                break;
            }
            case PEAKTABCOLOR: {
                this.peakTabColor = color;
                break;
            }
            case PLOTCOLOR: {
                int i = this.graphSets.size();
                while (--i >= 0) {
                    ((GraphSet)this.graphSets.get(i)).setPlotColor0(color);
                }
                break;
            }
            case PLOTAREACOLOR: {
                this.plotAreaColor = color;
                break;
            }
            case SCALECOLOR: {
                this.scaleColor = color;
                break;
            }
            case TITLECOLOR: {
                this.titleColor = color;
                break;
            }
            case UNITSCOLOR: {
                this.unitsColor = color;
                break;
            }
            default: {
                Logger.warn("AwtPanel --- unrecognized color: " + (Object)((Object)st));
                return;
            }
        }
        this.taintedAll = true;
    }

    public GenericColor getColor(ScriptToken whatColor) {
        switch (whatColor) {
            default: {
                Logger.error("awtgraphset missing color " + (Object)((Object)whatColor));
                return this.BLACK;
            }
            case ZOOMBOXCOLOR2: {
                return this.zoomBoxColor2;
            }
            case ZOOMBOXCOLOR: {
                return this.zoomBoxColor;
            }
            case HIGHLIGHTCOLOR: {
                return this.highlightColor;
            }
            case INTEGRALPLOTCOLOR: {
                return this.integralPlotColor;
            }
            case GRIDCOLOR: {
                return this.gridColor;
            }
            case PEAKTABCOLOR: {
                return this.peakTabColor;
            }
            case PLOTAREACOLOR: {
                return this.plotAreaColor;
            }
            case SCALECOLOR: {
                return this.scaleColor;
            }
            case TITLECOLOR: {
                return this.titleColor;
            }
            case UNITSCOLOR: 
        }
        return this.unitsColor;
    }

    public Object[][] getOverlayLegendData() {
        int numSpectra = this.currentGraphSet.nSpectra;
        Object[][] data = new Object[numSpectra][];
        String f1 = this.getSpectrumAt(0).getFilePath();
        String f2 = this.getSpectrumAt(numSpectra - 1).getFilePath();
        boolean useFileName = f1 != null && f2 != null && !f1.equals(f2);
        for (int index = 0; index < numSpectra; ++index) {
            Object[] cols = new Object[3];
            Spectrum spectrum = this.getSpectrumAt(index);
            this.title = spectrum.getTitle();
            if (useFileName) {
                this.title = JSVFileManager.getTagName(spectrum.getFilePath()) + " - " + this.title;
            }
            GenericColor plotColor = this.getCurrentPlotColor(index);
            cols[0] = new Integer(index + 1);
            cols[1] = plotColor;
            cols[2] = " " + this.title;
            data[index] = cols;
        }
        return data;
    }

    public void setColorOrFont(ColorParameters params, ScriptToken st) {
        if (st == null) {
            Map<ScriptToken, GenericColor> colors = params.elementColors;
            for (Map.Entry<ScriptToken, GenericColor> entry : colors.entrySet()) {
                this.setColorOrFont(params, entry.getKey());
            }
            this.setColorOrFont(params, ScriptToken.DISPLAYFONTNAME);
            this.setColorOrFont(params, ScriptToken.TITLEFONTNAME);
            return;
        }
        switch (st) {
            case DISPLAYFONTNAME: {
                this.setFontName(st, params.displayFontName);
                return;
            }
            case TITLEFONTNAME: {
                this.setFontName(st, params.titleFontName);
                return;
            }
        }
        this.setColor(st, params.getElementColor(st));
    }

    public GenericColor getCurrentPlotColor(int i) {
        return this.currentGraphSet.getPlotColor(i);
    }

    public void setPrint(PrintLayout pl, String fontName) {
        if (pl == null) {
            this.options.putAll(this.optionsSaved);
            this.optionsSaved = null;
            return;
        }
        this.printJobTitle = pl.title;
        this.printingFontName = fontName;
        this.printGraphPosition = pl.position;
        this.optionsSaved = new Hashtable();
        this.optionsSaved.putAll(this.options);
        this.gridOn = pl.showGrid;
        this.titleOn = pl.showTitle;
        this.setBoolean(ScriptToken.XSCALEON, pl.showXScale);
        this.setBoolean(ScriptToken.XUNITSON, pl.showXScale);
        this.setBoolean(ScriptToken.YSCALEON, pl.showYScale);
        this.setBoolean(ScriptToken.YUNITSON, pl.showYScale);
    }

    public void setDefaultPrintOptions(PrintLayout pl) {
        pl.showGrid = this.gridOn;
        pl.showXScale = this.getBoolean(ScriptToken.XSCALEON);
        pl.showYScale = this.getBoolean(ScriptToken.YSCALEON);
        pl.showTitle = this.titleOn;
    }

    public JSVDialog showDialog(Annotation.AType type) {
        AnnotationData ad = this.getDialog(type);
        this.closeAllDialogsExcept(type);
        if (ad != null && ad instanceof JSVDialog) {
            return ((JSVDialog)ad).reEnable();
        }
        int iSpec = this.getCurrentSpectrumIndex();
        if (iSpec < 0) {
            this.jsvp.showMessage("To enable " + (Object)((Object)type) + " first select a spectrum by clicking on it.", "" + (Object)((Object)type));
            return null;
        }
        Spectrum spec = this.getSpectrum();
        JSVDialog dialog = this.vwr.getDialog(type, spec);
        if (ad == null && type == Annotation.AType.Measurements) {
            ad = new MeasurementData(Annotation.AType.Measurements, spec);
        }
        if (ad != null) {
            dialog.setData(ad);
        }
        this.addDialog(iSpec, type, dialog);
        dialog.reEnable();
        return dialog;
    }

    public void printPdf(GenericGraphics pdfCreator, PrintLayout pl) {
        boolean isPortrait = !pl.layout.equals("landscape");
        this.print(pdfCreator, isPortrait ? pl.imageableHeight : pl.imageableWidth, isPortrait ? pl.imageableWidth : pl.imageableHeight, pl.imageableX, pl.imageableY, pl.paperHeight, pl.paperWidth, isPortrait, 0);
    }

    public int print(Object g, double height, double width, double x, double y, double paperHeight, double paperWidth, boolean isPortrait, int pi) {
        this.g2d = this.g2d0;
        if (pi == 0) {
            this.isPrinting = true;
            boolean addFilePath = false;
            if (g instanceof GenericGraphics) {
                this.g2d = (GenericGraphics)g;
                g = this.gMain;
            }
            if (this.printGraphPosition.equals("default")) {
                if (isPortrait) {
                    height = 450.0;
                    width = 280.0;
                } else {
                    height = 280.0;
                    width = 450.0;
                }
            } else if (this.printGraphPosition.equals("fit to page")) {
                addFilePath = true;
            } else if (isPortrait) {
                height = 450.0;
                width = 280.0;
                x = (int)(paperWidth - width) / 2;
                y = (int)(paperHeight - height) / 2;
            } else {
                height = 280.0;
                width = 450.0;
                y = (int)(paperWidth - 280.0) / 2;
                x = (int)(paperHeight - 450.0) / 2;
            }
            this.g2d.translateScale(g, x, y, 0.1);
            this.setTaintedAll();
            this.drawGraph(g, g, g, (int)width, (int)height, addFilePath);
            this.isPrinting = false;
            return 0;
        }
        this.isPrinting = false;
        return 1;
    }

    @Override
    public boolean keyPressed(int code, int modifiers) {
        if (this.isPrinting) {
            return false;
        }
        this.checkKeyControl(code, true);
        switch (code) {
            case 8: 
            case 27: 
            case 127: {
                this.escapeKeyPressed(code != 27);
                this.isIntegralDrag = false;
                this.setTaintedAll();
                this.repaint();
                return true;
            }
        }
        double scaleFactor = 0.0;
        boolean doConsume = false;
        if (modifiers == 0) {
            switch (code) {
                case 37: 
                case 39: {
                    this.doMouseMoved(code == 39 ? (this.mouseX = this.mouseX + 1) : (this.mouseX = this.mouseX - 1), this.mouseY);
                    this.repaint();
                    doConsume = true;
                    break;
                }
                case 33: 
                case 34: {
                    scaleFactor = code == 33 ? GraphSet.RT2 : 1.0 / GraphSet.RT2;
                    doConsume = true;
                    break;
                }
                case 38: 
                case 40: {
                    int dir;
                    int n = dir = code == 40 ? -1 : 1;
                    if (this.getSpectrumAt(0).getSubSpectra() == null) {
                        this.notifySubSpectrumChange(dir, null);
                    } else {
                        this.advanceSubSpectrum(dir);
                        this.setTaintedAll();
                        this.repaint();
                    }
                    doConsume = true;
                }
            }
        } else if (this.checkMod(code, 2)) {
            switch (code) {
                case 38: 
                case 40: 
                case 45: 
                case 61: {
                    scaleFactor = code == 61 || code == 38 ? GraphSet.RT2 : 1.0 / GraphSet.RT2;
                    doConsume = true;
                    break;
                }
                case 37: 
                case 39: {
                    this.toPeak(code == 39 ? 1 : -1);
                    doConsume = true;
                }
            }
        }
        if (scaleFactor != 0.0) {
            this.scaleYBy(scaleFactor);
            this.setTaintedAll();
            this.repaint();
        }
        return doConsume;
    }

    @Override
    public void keyReleased(int keyCode) {
        if (this.isPrinting) {
            return;
        }
        this.checkKeyControl(keyCode, false);
    }

    @Override
    public boolean keyTyped(int ch, int mods) {
        if (this.isPrinting) {
            return false;
        }
        switch (ch) {
            case 110: {
                if (mods != 0) break;
                this.normalizeIntegral();
                return true;
            }
            case 26: {
                if (mods != 2) break;
                this.previousView();
                this.setTaintedAll();
                this.repaint();
                return true;
            }
            case 25: {
                if (mods != 2) break;
                this.nextView();
                this.setTaintedAll();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseAction(int mode, long time, int x, int y, int countIgnored, int buttonMods) {
        if (this.isPrinting) {
            return;
        }
        switch (mode) {
            case 4: {
                if (!this.checkMod(buttonMods, 16)) {
                    return;
                }
                this.doMousePressed(x, y);
                break;
            }
            case 5: {
                this.doMouseReleased(x, y, this.checkMod(buttonMods, 16));
                this.setTaintedAll();
                this.repaint();
                break;
            }
            case 1: {
                this.doMouseDragged(x, y);
                this.repaint();
                break;
            }
            case 0: {
                this.jsvp.getFocusNow(false);
                if ((buttonMods & 0x1C) != 0) {
                    this.doMouseDragged(x, y);
                    this.repaint();
                    return;
                }
                this.doMouseMoved(x, y);
                if (this.coordStr == null) break;
                this.repaint();
                break;
            }
            case 2: {
                if (this.checkMod(buttonMods, 4)) {
                    this.jsvp.showMenu(x, y);
                    return;
                }
                this.ctrlPressed = false;
                this.doMouseClicked(x, y, this.updateControlPressed(buttonMods));
            }
        }
    }

    public boolean checkMod(int buttonMods, int mask) {
        return (buttonMods & mask) == mask;
    }

    public void checkKeyControl(int keyCode, boolean isPressed) {
        switch (keyCode) {
            case 17: 
            case 157: {
                this.ctrlPressed = isPressed;
                break;
            }
            case 16: {
                this.shiftPressed = isPressed;
            }
        }
    }

    public boolean updateControlPressed(int mods) {
        return this.ctrlPressed |= this.checkMod(mods, 2) || this.checkMod(mods, 20);
    }

    @Override
    public void mouseEnterExit(long time, int x, int y, boolean isExit) {
        if (isExit) {
            this.thisWidget = null;
            this.isIntegralDrag = false;
            this.integralShiftMode = 0;
        } else {
            try {
                this.jsvp.getFocusNow(false);
            }
            catch (Exception e) {
                System.out.println("pd " + this + " cannot focus");
            }
        }
    }

    public void setSolutionColor(String what) {
        boolean asFitted;
        boolean isNone = what.indexOf("none") >= 0;
        boolean bl = asFitted = what.indexOf("false") < 0;
        if (what.indexOf("all") < 0) {
            int color = isNone ? -1 : this.vwr.getSolutionColor(asFitted);
            this.getSpectrum().setFillColor(color == -1 ? null : this.vwr.parameters.getColor1(color));
        } else {
            VisibleInterface vi = (VisibleInterface)JSViewer.getInterface("jspecview.common.Visible");
            int i = this.graphSets.size();
            while (--i >= 0) {
                ((GraphSet)this.graphSets.get(i)).setSolutionColor(vi, isNone, asFitted);
            }
        }
    }

    public void setIRMode(Spectrum.IRMode mode, String type) {
        int i = this.graphSets.size();
        while (--i >= 0) {
            ((GraphSet)this.graphSets.get(i)).setIRMode(mode, type);
        }
    }

    public void closeSpectrum() {
        this.vwr.close("views");
        this.vwr.close(this.getSourceID());
        this.vwr.execView("*", true);
    }

    private static enum Mouse {
        UP,
        DOWN;

    }

    public static enum LinkMode {
        ALL,
        NONE,
        AB,
        ABC;


        public static LinkMode getMode(String abc) {
            if (abc.equals("*")) {
                return ALL;
            }
            for (LinkMode mode : LinkMode.values()) {
                if (!mode.name().equalsIgnoreCase(abc)) continue;
                return mode;
            }
            return NONE;
        }
    }
}

