/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlEnumType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/yaml/meta/impl/YamlDeprecatedValuesInspectionBase;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase;", "<init>", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "StructureChecker", "intellij.yaml.backend"})
@ApiStatus.Internal
public abstract class YamlDeprecatedValuesInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
        return new StructureChecker(holder, metaTypeProvider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/yaml/meta/impl/YamlDeprecatedValuesInspectionBase$StructureChecker;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase$SimpleYamlPsiVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;)V", "visitYAMLKeyValue", "", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.yaml.backend"})
    private static final class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final YamlMetaTypeProvider metaTypeProvider;

        public StructureChecker(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
            this.holder = holder;
            this.metaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
            YAMLValue yAMLValue = keyValue.getValue();
            if (yAMLValue == null) {
                return;
            }
            YAMLValue yamlValue = yAMLValue;
            String string = keyValue.getValueText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
            String yamlValueText = string;
            if (((CharSequence)yamlValueText).length() == 0) {
                return;
            }
            Object object = this.metaTypeProvider.getValueMetaType(yamlValue);
            if (object == null || (object = object.getMetaType()) == null) {
                return;
            }
            Object yamlValueMetaType = object;
            if (yamlValueMetaType instanceof YamlEnumType && ((YamlEnumType)yamlValueMetaType).isLiteralDeprecated(yamlValueText)) {
                Object[] objectArray = new Object[]{yamlValueText};
                this.holder.registerProblem((PsiElement)yamlValue, YAMLBundle.message((String)"YamlDeprecatedKeysInspectionBase.deprecated.value", (Object[])objectArray), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
        }
    }
}

