// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GDKMM_COLORSTATE_H
#define _GDKMM_COLORSTATE_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2024 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>
#include <glibmm/value.h>
#include <gdk/gdk.h> // For GdkColorState

namespace Gdk
{
class GDKMM_API CicpParams;

/** A %Gdk::ColorState object provides the information to interpret
 * colors and pixels in a variety of ways.
 *
 * They are also known as
 * [*color spaces*](https://en.wikipedia.org/wiki/Color_space).
 *
 * Crucially, GTK knows how to convert colors from one color state to another.
 *
 * %ColorState objects are immutable and therefore threadsafe.
 *
 * @newin{4,16}
 */
class GDKMM_API ColorState final
{
  // GdkColorState is registered as a boxed type, but it has custom
  // reference-counting instead of copy/free functions, so we use it via RefPtr.
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = ColorState;
  using BaseObjectType = GdkColorState;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GdkColorState*       gobj();

  ///Provides access to the underlying C instance.
  const GdkColorState* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkColorState* gobj_copy() const;

  ColorState() = delete;

  // noncopyable
  ColorState(const ColorState&) = delete;
  ColorState& operator=(const ColorState&) = delete;

protected:
  // Do not derive this.  Gdk::ColorState can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  
  /** Returns the color state object representing the sRGB color space.
   * 
   * This color state uses the primaries defined by BT.709-6 and the transfer function
   * defined by IEC 61966-2-1.
   * 
   * It is equivalent to the [Cicp](class.CicpParams.html) tuple 1/13/0/1.
   * 
   * See e.g. [the CSS Color Module](https://www.w3.org/TR/css-color-4/#predefined-sRGB)
   * for details about this colorstate.
   * 
   * @newin{4,16}
   * 
   * @return The color state object for sRGB.
   */
  static Glib::RefPtr<ColorState> get_srgb();
  
  /** Returns the color state object representing the linearized sRGB color space.
   * 
   * This color state uses the primaries defined by BT.709-6 and a linear transfer function.
   * 
   * It is equivalent to the [Cicp](class.CicpParams.html) tuple 1/8/0/1.
   * 
   * See e.g. [the CSS Color Module](https://www.w3.org/TR/css-color-4/#predefined-sRGB-linear)
   * for details about this colorstate.
   * 
   * @newin{4,16}
   * 
   * @return The color state object for linearized sRGB.
   */
  static Glib::RefPtr<ColorState> get_srgb_linear();
  
  /** Returns the color state object representing the rec2100-pq color space.
   * 
   * This color state uses the primaries defined by BT.2020-2 and BT.2100-0 and the transfer
   * function defined by SMPTE ST 2084 and BT.2100-2.
   * 
   * It is equivalent to the [Cicp](class.CicpParams.html) tuple 9/16/0/1.
   * 
   * See e.g. [the CSS HDR Module](https://drafts.csswg.org/css-color-hdr/#valdef-color-rec2100-pq)
   * for details about this colorstate.
   * 
   * @newin{4,16}
   * 
   * @return The color state object for rec2100-pq.
   */
  static Glib::RefPtr<ColorState> get_rec2100_pq();
  
  /** Returns the color state object representing the linear rec2100 color space.
   * 
   * This color state uses the primaries defined by BT.2020-2 and BT.2100-0 and a linear
   * transfer function.
   * 
   * It is equivalent to the [Cicp](class.CicpParams.html) tuple 9/8/0/1.
   * 
   * See e.g. [the CSS HDR Module](https://drafts.csswg.org/css-color-hdr/#valdef-color-rec2100-linear)
   * for details about this colorstate.
   * 
   * @newin{4,16}
   * 
   * @return The color state object for linearized rec2100.
   */
  static Glib::RefPtr<ColorState> get_rec2100_linear();
  
  /** Returns the color state object representing the oklab color space.
   * 
   * This is a perceptually uniform color state.
   * 
   * @newin{4,18}
   * 
   * @return The color state object for oklab.
   */
  static Glib::RefPtr<ColorState> get_oklab();
  
  /** Returns the color state object representing the oklch color space.
   * 
   * This is the polar variant of oklab, in which the hue is encoded as
   * a polar coordinate.
   * 
   * @newin{4,18}
   * 
   * @return The color state object for oklch.
   */
  static Glib::RefPtr<ColorState> get_oklch();

  
  /** Compares two `Gdk::ColorStates` for equality.
   * 
   * Note that this function is not guaranteed to be perfect and two objects
   * describing the same color state may compare not equal. However, different
   * color states will never compare equal.
   * 
   * @newin{4,16}
   * 
   * @param other Another `Gdk::ColorStatee`.
   * @return <tt>true</tt> if the two color states compare equal.
   */
  bool equal(const Glib::RefPtr<const ColorState>& other) const;
  
  /** Compares two `Gdk::ColorStates` for equivalence.
   * 
   * Two objects that represent the same color state should be equivalent,
   * even though they may not be equal in the sense of equal().
   * 
   * @newin{4,20}
   * 
   * @param other Another `Gdk::ColorStatee`.
   * @return <tt>true</tt> if the two color states are equivalent.
   */
  bool equivalent(const Glib::RefPtr<const ColorState>& other) const;
  
  /** Create a Gdk::CicpParams representing the colorstate.
   * 
   * It is not guaranteed that every `Gdk::ColorState` can be
   * represented with Cicp parameters. If that is the case,
   * this function returns <tt>nullptr</tt>.
   * 
   * @newin{4,16}
   * 
   * @return A new Gdk::CicpParams.
   */
  Glib::RefPtr<CicpParams> create_cicp_params() const;


};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{
// This is needed so Glib::RefPtr<Gdk::ColorState> can be used with
// Glib::Value and _WRAP_PROPERTY in Gdk::DmabufTextureBuilder and elsewhere.
template <>
class GDKMM_API Value<Glib::RefPtr<Gdk::ColorState>> : public ValueBase_Boxed
{
public:
  using CppType = Glib::RefPtr<Gdk::ColorState>;
  using CType = GdkColorState*;

  static GType value_type();

  void set(const CppType& data);
  CppType get() const;
};
} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::ColorState
 */
GDKMM_API
Glib::RefPtr<Gdk::ColorState> wrap(GdkColorState* object, bool take_copy = false);

} // namespace Glib


#endif /* _GDKMM_COLORSTATE_H */

