/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMMStatementInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final DBCExecutionPurpose purpose;
    private final transient QMMStatementInfo previous;
    private transient DBCStatement reference;

    public QMMStatementInfo(QMMConnectionInfo connection, DBCStatement reference, QMMStatementInfo previous) {
        super(QMMetaObjectType.STATEMENT_INFO);
        this.connection = connection;
        this.reference = reference;
        this.purpose = reference.getSession().getPurpose();
        this.previous = previous;
    }

    public QMMStatementInfo(long openTime, long closeTime, QMMConnectionInfo session, DBCExecutionPurpose purpose) {
        super(QMMetaObjectType.STATEMENT_INFO, openTime, closeTime);
        this.connection = session;
        this.purpose = purpose;
        this.previous = null;
    }

    @Override
    public void close() {
        super.close();
        if (this.reference != null) {
            this.reference = null;
        }
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }

    @Nullable
    public DBCStatement getReference() {
        return this.reference;
    }

    public String getReferenceText() {
        return this.reference != null ? this.reference.getQueryString() : "N/A";
    }

    @Override
    @NotNull
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    @NotNull
    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    @Nullable
    public QMMStatementInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "STATEMENT " + this.getReferenceText();
    }
}

