/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.completion.ml.personalization.Day;
import com.intellij.openapi.diagnostic.Logger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/ml/personalization/impl/DayImpl;", "Lcom/intellij/completion/ml/personalization/Day;", "date", "Ljava/util/Date;", "<init>", "(Ljava/util/Date;)V", "dayOfMonth", "", "getDayOfMonth", "()I", "month", "getMonth", "year", "getYear", "compareTo", "other", "hashCode", "equals", "", "", "toString", "", "Companion", "intellij.completionMlRanking"})
public final class DayImpl
implements Day {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int dayOfMonth;
    private final int month;
    private final int year;
    @NotNull
    private static final Logger LOG;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT;

    public DayImpl(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.dayOfMonth = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    @Override
    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(@NotNull Day other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getYear() == other.getYear()) {
            if (this.getMonth() == other.getMonth()) {
                return Intrinsics.compare((int)this.getDayOfMonth(), (int)other.getDayOfMonth());
            }
            return Intrinsics.compare((int)this.getMonth(), (int)other.getMonth());
        }
        return Intrinsics.compare((int)this.getYear(), (int)other.getYear());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getYear(), this.getMonth(), this.getDayOfMonth()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (other != null && other instanceof Day) {
            return this.compareTo((Day)other) == 0;
        }
        return false;
    }

    @NotNull
    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getYear(), this.getMonth() - 1, this.getDayOfMonth());
        String string = DATE_FORMAT.get().format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final SimpleDateFormat DATE_FORMAT$lambda$0() {
        return new SimpleDateFormat("dd-MM-yyyy");
    }

    static {
        Logger logger = Logger.getInstance(DayImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DATE_FORMAT = ThreadLocal.withInitial(DayImpl::DATE_FORMAT$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/DayImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DATE_FORMAT", "Ljava/lang/ThreadLocal;", "Ljava/text/SimpleDateFormat;", "kotlin.jvm.PlatformType", "fromString", "Lcom/intellij/completion/ml/personalization/Day;", "str", "", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Day fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            ParsePosition position = new ParsePosition(0);
            Date date = null;
            try {
                Date date2 = ((SimpleDateFormat)DATE_FORMAT.get()).parse(str, position);
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"parse(...)");
                date = date2;
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse a date from string: " + str + ". Collected data for the day will be skipped.", (Throwable)e);
                return null;
            }
            if (position.getIndex() == 0) {
                return null;
            }
            return new DayImpl(date);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

