/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class XmlLocationCompletionContributor
extends CompletionContributor {
    public static final Function<Object, LookupElement> MAPPING = o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((Object)o);

    XmlLocationCompletionContributor() {
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiReference reference;
        if (parameters == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset())) instanceof URLReference) {
            if (((URLReference)reference).isSchemaLocation()) {
                Object[] objects = XmlLocationCompletionContributor.completeSchemaLocation(reference.getElement());
                result.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
                if (objects.length > 0) {
                    result.stopHere();
                }
                return;
            }
            Object[] objects = XmlLocationCompletionContributor.completeNamespace(reference.getElement());
            result.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
            if (objects.length > 0) {
                result.stopHere();
            }
            return;
        }
        if (reference instanceof PsiMultiReference) {
            reference = ((PsiMultiReference)reference).getReferences()[0];
        }
        if (reference instanceof DependentNSReference) {
            MultiMap map = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(parameters.getOriginalFile().getProject());
            String namespace = ((DependentNSReference)reference).getNamespaceReference().getCanonicalText();
            Collection strings = map.get((Object)namespace);
            for (String string : strings) {
                if (namespace.equals(string)) continue;
                result.consume(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string), (double)100.0));
            }
            if (!strings.isEmpty()) {
                result.stopHere();
            }
        }
    }

    private static Object[] completeNamespace(PsiElement myElement) {
        XmlFile file = (XmlFile)myElement.getContainingFile();
        PsiElement parent = myElement.getParent();
        HashSet list = new HashSet();
        for (XmlSchemaProvider provider : XmlSchemaProvider.EP_NAME.getExtensionList()) {
            if (!provider.isAvailable(file)) continue;
            list.addAll(provider.getAvailableNamespaces(file, null));
        }
        if (!list.isEmpty()) {
            return ArrayUtil.toObjectArray(list);
        }
        HashSet set = new HashSet(ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(myElement.getProject()).keySet());
        Set fromIndex = XmlNamespaceIndex.getAllResources(null, (Project)myElement.getProject()).stream().filter(resource -> "xsd".equals(resource.getFile().getExtension())).map(resource -> ((XsdNamespaceBuilder)resource.getValue()).getNamespace()).collect(Collectors.toSet());
        ContainerUtil.addAllNotNull(set, fromIndex);
        Object[] resourceUrls = set.toArray();
        XmlDocument document = file.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas((XmlTag)rootTag, xmlTag -> {
                String s = xmlTag.getAttributeValue("targetNamespace");
                if (s != null) {
                    additionalNs.add(s);
                }
                return true;
            });
        }
        resourceUrls = ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtilRt.toStringArray(additionalNs));
        HashSet<String> preferred = new HashSet<String>();
        if (parent instanceof XmlAttribute && "xmlns".equals(((XmlAttribute)parent).getName())) {
            XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper((PsiFile)file);
            preferred.addAll(helper.guessUnboundNamespaces(parent.getParent(), file));
        }
        return ContainerUtil.map2Array((Object[])resourceUrls, o -> {
            LookupElementBuilder builder = LookupElementBuilder.create((Object)o);
            return preferred.contains(o) ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)100.0) : builder;
        });
    }

    private static Object[] completeSchemaLocation(PsiElement element) {
        XmlTag tag = (XmlTag)element.getParent().getParent();
        Object[] attributes = tag.getAttributes();
        PsiReference[] refs = element.getReferences();
        return ContainerUtil.mapNotNull((Object[])attributes, attribute -> {
            String attributeValue = attribute.getValue();
            return attributeValue != null && attribute.isNamespaceDeclaration() && ContainerUtil.find((Object[])refs, ref -> ref.getCanonicalText().equals(attributeValue)) == null ? attributeValue + " " : null;
        }, (Object[])ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlLocationCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

