/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.ide.impl.wsl.WslEelDescriptor;
import com.intellij.util.io.PathKt;
import git4idea.commands.GitScriptGenerator;
import git4idea.commit.signing.GenerateLauncherException;
import git4idea.commit.signing.GpgAgentCommandExecutorImpl;
import git4idea.commit.signing.GpgAgentConfiguratorKt;
import git4idea.commit.signing.GpgAgentPaths;
import git4idea.config.GitExecutable;
import git4idea.gpg.PinentryApp;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u0010\u0014\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lgit4idea/commit/signing/PinentryShellScriptLauncherGenerator;", "", "executable", "Lgit4idea/config/GitExecutable;", "<init>", "(Lgit4idea/config/GitExecutable;)V", "getExecutable", "()Lgit4idea/config/GitExecutable;", "generate", "project", "Lcom/intellij/openapi/project/Project;", "gpgAgentPaths", "Lgit4idea/commit/signing/GpgAgentPaths;", "fallbackPinentryPath", "", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commit/signing/GpgAgentPaths;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCommandLineParameters", "", "()[Ljava/lang/String;", "getCommandLine", "getScriptTemplate", "intellij.vcs.git"})
public final class PinentryShellScriptLauncherGenerator {
    @NotNull
    private final GitExecutable executable;

    public PinentryShellScriptLauncherGenerator(@NotNull GitExecutable executable) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        this.executable = executable;
    }

    @NotNull
    public final GitExecutable getExecutable() {
        return this.executable;
    }

    @Nullable
    public final Object generate(@NotNull Project project, @NotNull GpgAgentPaths gpgAgentPaths, @Nullable String fallbackPinentryPath, @NotNull Continuation<Object> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(gpgAgentPaths, this, fallbackPinentryPath, project, null){
            int label;
            final /* synthetic */ GpgAgentPaths $gpgAgentPaths;
            final /* synthetic */ PinentryShellScriptLauncherGenerator this$0;
            final /* synthetic */ String $fallbackPinentryPath;
            final /* synthetic */ Project $project;
            {
                this.$gpgAgentPaths = $gpgAgentPaths;
                this.this$0 = $receiver;
                this.$fallbackPinentryPath = $fallbackPinentryPath;
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)$result);
                        Path path = this.$gpgAgentPaths.getGpgPinentryAppLauncher();
                        try {
                            Object object;
                            PathsKt.writeText$default((Path)PathKt.createParentDirectories((Path)path), (CharSequence)PinentryShellScriptLauncherGenerator.access$getScriptTemplate(this.this$0, this.$fallbackPinentryPath), null, (OpenOption[])new OpenOption[0], (int)2, null);
                            if (this.this$0.getExecutable() instanceof GitExecutable.Wsl) {
                                String launcherConfigPath = this.$gpgAgentPaths.getGpgPinentryAppLauncherConfigPath();
                                String[] stringArray = new String[]{"+x", launcherConfigPath};
                                object = new GpgAgentCommandExecutorImpl(this.$project, this.this$0.getExecutable()).execute("chmod", stringArray);
                            } else {
                                NioFiles.setExecutable((Path)path);
                                object = Unit.INSTANCE;
                            }
                            unit = object;
                        }
                        catch (IOException e) {
                            GpgAgentConfiguratorKt.access$getLOG$p().warn("Cannot generate " + path, (Throwable)e);
                            throw new GenerateLauncherException(e);
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final String[] getCommandLineParameters() {
        String[] stringArray;
        if (GpgAgentConfiguratorKt.access$getLOG$p().isDebugEnabled()) {
            String[] stringArray2 = new String[]{"--log"};
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @NotNull
    public final String getCommandLine() {
        GitScriptGenerator gitScriptGenerator;
        if (this.executable instanceof GitExecutable.Eel) {
            EelDescriptor eelDescriptor = ((GitExecutable.Eel)this.executable).getEel().getDescriptor();
            WslEelDescriptor wslEelDescriptor = eelDescriptor instanceof WslEelDescriptor ? (WslEelDescriptor)eelDescriptor : null;
            gitScriptGenerator = new GitScriptGenerator((WSLDistribution)(wslEelDescriptor != null ? wslEelDescriptor.getDistribution() : null));
        } else {
            gitScriptGenerator = new GitScriptGenerator(this.executable);
        }
        GitScriptGenerator gitScriptGenerator2 = gitScriptGenerator;
        String[] stringArray = this.getCommandLineParameters();
        String string = gitScriptGenerator2.addParameters(Arrays.copyOf(stringArray, stringArray.length)).commandLine(PinentryApp.class, false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandLine(...)");
        return string;
    }

    @Language(value="Shell Script")
    private final String getScriptTemplate(String fallbackPinentryPath) {
        return fallbackPinentryPath == null ? StringsKt.trimMargin$default((String)("|#!/bin/sh\n         |" + this.getCommandLine() + "\n      "), null, (int)1, null) : StringsKt.trimMargin$default((String)("|#!/bin/sh\n         |if [ -n \"$PINENTRY_USER_DATA\" ]; then\n         |  case \"$PINENTRY_USER_DATA\" in\n         |    IJ_PINENTRY=*)\n         |      " + this.getCommandLine() + "\n         |      exit $?\n         |    ;;\n         |  esac\n         |fi\n         |exec " + CommandLineUtil.posixQuote((String)fallbackPinentryPath) + " \"$@\"\n      "), null, (int)1, null);
    }

    public static final /* synthetic */ String access$getScriptTemplate(PinentryShellScriptLauncherGenerator $this, String fallbackPinentryPath) {
        return $this.getScriptTemplate(fallbackPinentryPath);
    }
}

