/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.pqc.lms.Composer;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedVerifier;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPublicKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricLMSPublicKey
extends AsymmetricLMSKey
implements AsymmetricPublicKey {
    private final byte[] keyData;
    private final int hashCode;
    private final AsymmetricKeyParameter lwKey;

    public AsymmetricLMSPublicKey(int n, byte[] byArray) {
        super(n);
        this.keyData = Arrays.clone(byArray);
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPublicKey.getLwKey(this);
    }

    public AsymmetricLMSPublicKey(byte[] byArray) throws IOException {
        this(SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricLMSPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this(subjectPublicKeyInfo.getAlgorithm(), ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey()).getOctets());
    }

    private AsymmetricLMSPublicKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        super(Pack.bigEndianToInt(byArray, 0));
        if (!PKCSObjectIdentifiers.id_alg_hss_lms_hashsig.equals(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("cannot identify key encoding");
        }
        this.keyData = Arrays.copyOfRange(byArray, 4, byArray.length);
        this.hashCode = this.calculateHashCode();
        this.lwKey = AsymmetricLMSPublicKey.getLwKey(this);
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.keyData);
    }

    @Override
    public byte[] getEncoded() {
        byte[] byArray = Composer.compose().u32str(this.L).bytes(this.keyData).build();
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig), new DEROctetString(byArray));
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricLMSPublicKey)) {
            return false;
        }
        AsymmetricLMSPublicKey asymmetricLMSPublicKey = (AsymmetricLMSPublicKey)object;
        if (!Arrays.areEqual(this.keyData, asymmetricLMSPublicKey.keyData)) {
            return false;
        }
        return this.getAlgorithm().equals(asymmetricLMSPublicKey.getAlgorithm());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getAlgorithm().hashCode();
        n = 31 * n + Arrays.hashCode(this.keyData);
        return n;
    }

    public LMSContextBasedVerifier getContextBasedVerifier() {
        return (LMSContextBasedVerifier)((Object)this.lwKey);
    }

    private static AsymmetricKeyParameter getLwKey(final AsymmetricLMSPublicKey asymmetricLMSPublicKey) {
        return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyParameter>(){

            @Override
            public AsymmetricKeyParameter run() {
                try {
                    if (asymmetricLMSPublicKey.getL() == 1) {
                        return LMSPublicKeyParameters.getInstance(asymmetricLMSPublicKey.getPublicData());
                    }
                    Composer composer = Composer.compose().u32str(asymmetricLMSPublicKey.getL()).bytes(asymmetricLMSPublicKey.getPublicData());
                    return HSSPublicKeyParameters.getInstance(composer.build());
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }
        });
    }
}

