/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.PutIndicesSettingsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutIndicesSettingsRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutIndicesSettingsRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean preserveExisting;
    @Nonnull
    private final IndexSettings settings;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutIndicesSettingsRequest> _DESERIALIZER = PutIndicesSettingsRequest.createPutIndicesSettingsRequestDeserializer();
    public static final Endpoint<PutIndicesSettingsRequest, PutIndicesSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutIndicesSettingsRequest, PutIndicesSettingsResponse>(request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_settings";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            buf.append("/_settings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutIndicesSettingsResponse._DESERIALIZER);

    private PutIndicesSettingsRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.flatSettings = builder.flatSettings;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.masterTimeout = builder.masterTimeout;
        this.preserveExisting = builder.preserveExisting;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.timeout = builder.timeout;
    }

    public static PutIndicesSettingsRequest of(Function<Builder, ObjectBuilder<PutIndicesSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean preserveExisting() {
        return this.preserveExisting;
    }

    @Nonnull
    public final IndexSettings settings() {
        return this.settings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.settings.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<PutIndicesSettingsRequest> createPutIndicesSettingsRequestDeserializer() {
        JsonpDeserializer<IndexSettings> valueDeserializer = IndexSettings._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().settings((IndexSettings)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.flatSettings != null) {
            params.put("flat_settings", String.valueOf(this.flatSettings));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (this.preserveExisting != null) {
            params.put("preserve_existing", String.valueOf(this.preserveExisting));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.flatSettings);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.preserveExisting);
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutIndicesSettingsRequest other = (PutIndicesSettingsRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.flatSettings, other.flatSettings) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.index, other.index) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.preserveExisting, other.preserveExisting) && this.settings.equals(other.settings) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutIndicesSettingsRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean preserveExisting;
        private IndexSettings settings;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutIndicesSettingsRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.flatSettings = o.flatSettings;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.preserveExisting = o.preserveExisting;
            this.settings = o.settings;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.flatSettings = o.flatSettings;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.masterTimeout = o.masterTimeout;
            this.preserveExisting = o.preserveExisting;
            this.settings = o.settings;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder preserveExisting(@Nullable Boolean value) {
            this.preserveExisting = value;
            return this;
        }

        @Nonnull
        public final Builder settings(IndexSettings value) {
            this.settings = value;
            return this;
        }

        @Nonnull
        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public PutIndicesSettingsRequest build() {
            this._checkSingleUse();
            return new PutIndicesSettingsRequest(this);
        }
    }
}

