/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.feature;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.common.exception.EndRunException;

public abstract class AbstractRetriever {
    protected double parseAggregation(Aggregation aggregationToParse) {
        Iterator percentile;
        Aggregation aggregation;
        List aggrs;
        InternalAggregations bucket;
        Double result = null;
        if (aggregationToParse instanceof InternalSingleBucketAggregation && (bucket = ((InternalSingleBucketAggregation)aggregationToParse).getAggregations()) != null && (aggrs = bucket.asList()).size() == 1) {
            aggregationToParse = (Aggregation)aggrs.get(0);
        }
        if ((aggregation = aggregationToParse) instanceof NumericMetricsAggregation.SingleValue) {
            result = ((NumericMetricsAggregation.SingleValue)aggregation).value();
        } else if (aggregation instanceof InternalTDigestPercentiles && (percentile = ((InternalTDigestPercentiles)aggregation).iterator()).hasNext()) {
            result = ((Percentile)percentile.next()).getValue();
        }
        return Optional.ofNullable(result).orElseThrow(() -> new EndRunException("Failed to parse aggregation " + String.valueOf(aggregation), true).countedInStats(false));
    }

    protected long parseAggregationDocCount(Aggregation aggregationToParse, long defaultCount) {
        InternalSingleBucketAggregation bucket;
        if (aggregationToParse instanceof InternalSingleBucketAggregation && (bucket = (InternalSingleBucketAggregation)aggregationToParse) != null) {
            return bucket.getDocCount();
        }
        return defaultCount;
    }

    protected Optional<double[]> parseBucket(MultiBucketsAggregation.Bucket bucket, List<String> featureIds, boolean keepMissingValue) {
        return this.parseAggregations(Optional.ofNullable(bucket).map(b -> b.getAggregations()), featureIds, keepMissingValue);
    }

    protected Optional<double[]> parseAggregations(Optional<Aggregations> aggregations, List<String> featureIds, boolean keepMissingValue) {
        return aggregations.map(aggs -> aggs.asMap()).map(map -> featureIds.stream().mapToDouble(id -> Optional.ofNullable((Aggregation)map.get(id)).map(this::parseAggregation).orElse(Double.NaN)).toArray()).flatMap(result -> {
            if (keepMissingValue) {
                return Optional.of(Arrays.stream(result).map(d -> Double.isInfinite(d) ? Double.NaN : d).toArray());
            }
            boolean noneNaNOrInfinite = Arrays.stream(result).noneMatch(d -> Double.isNaN(d) || Double.isInfinite(d));
            return noneNaNOrInfinite ? Optional.of(result) : Optional.empty();
        });
    }

    protected Optional<long[]> extractFeatureDocCounts(MultiBucketsAggregation.Bucket bucket, List<String> featureIds) {
        return Optional.ofNullable(bucket).flatMap(b -> {
            long parentCount = b.getDocCount();
            if (parentCount == 0L) {
                return Optional.empty();
            }
            Map subAggs = b.getAggregations().asMap();
            long[] counts = new long[featureIds.size()];
            for (int i = 0; i < featureIds.size(); ++i) {
                String id = (String)featureIds.get(i);
                Aggregation agg = (Aggregation)subAggs.get(id);
                long count = this.parseAggregationDocCount(agg, parentCount);
                if (count == 0L) {
                    return Optional.empty();
                }
                counts[i] = count;
            }
            return Optional.of(counts);
        });
    }

    protected void updateSourceAfterKey(Map<String, Object> afterKey, SearchSourceBuilder search) {
        AggregationBuilder aggBuilder = (AggregationBuilder)search.aggregations().getAggregatorFactories().iterator().next();
        if (!(aggBuilder instanceof CompositeAggregationBuilder)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid client request; expected a composite builder but instead got {}", aggBuilder));
        }
        CompositeAggregationBuilder comp = (CompositeAggregationBuilder)aggBuilder;
        comp.aggregateAfter(afterKey);
    }
}

