/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.ByteArrayOutputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FinderCommentService {
    private static final String XATTR_FINDER_COMMENT = "com.apple.metadata:kMDItemFinderComment";
    private static final String XATTR_COMMENT = "com.apple.metadata:kMDItemComment";
    private static final MethodHandle setxattr;
    private static final MethodHandle getxattr;
    private static final Logger logger;

    public static String cleanComment(String comment) {
        return comment.replaceAll("\\R", "");
    }

    public static void writeFinderComment(Path filePath, String comment, boolean verify) {
        if (filePath.toString().isEmpty()) {
            logger.warn("Empty file path detected, not writing finder comment.");
            return;
        }
        try (Arena arena = Arena.ofConfined();
             ByteArrayOutputStream out = new ByteArrayOutputStream();){
            NSString nsString = new NSString(FinderCommentService.cleanComment(comment));
            BinaryPropertyListWriter.write((NSObject)nsString, out);
            byte[] plistBytes = out.toByteArray();
            MemorySegment pathSegment = arena.allocateFrom(filePath.toString());
            MemorySegment finderCommentAttrSegment = arena.allocateFrom(XATTR_FINDER_COMMENT);
            MemorySegment commentAttrSegment = arena.allocateFrom(XATTR_COMMENT);
            MemorySegment value = arena.allocate(plistBytes.length);
            value.asByteBuffer().put(plistBytes);
            int result2 = setxattr.invoke(pathSegment, finderCommentAttrSegment, value, plistBytes.length, 0, 0);
            FinderCommentService.checkError(result2);
            result2 = setxattr.invoke(pathSegment, commentAttrSegment, value, plistBytes.length, 0, 0);
            FinderCommentService.checkError(result2);
            logger.trace("Successfully wrote finder comment.");
            if (verify) {
                String newComment = FinderCommentService.getFinderComment(filePath);
                if (newComment != null && newComment.equalsIgnoreCase(FinderCommentService.cleanComment(comment))) {
                    logger.trace("Finder comment verified.");
                } else {
                    logger.error("Finder comment verification failed.");
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed to write finder comment.", t);
        }
    }

    private static String getFinderComment(Path filePath) throws Throwable {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment pathSegment = arena.allocateFrom(filePath.toString());
            MemorySegment nameSegment = arena.allocateFrom(XATTR_FINDER_COMMENT);
            long size = getxattr.invoke(pathSegment, nameSegment, MemorySegment.NULL, 0L, 0, 0);
            if (size <= 0L) {
                String string = null;
                return string;
            }
            MemorySegment buffer = arena.allocate(size);
            long readSize = getxattr.invoke(pathSegment, nameSegment, buffer, size, 0, 0);
            if (readSize != size) {
                throw new RuntimeException("Failed to read full attribute");
            }
            byte[] plistData = buffer.toArray(ValueLayout.JAVA_BYTE);
            NSObject obj = PropertyListParser.parse(plistData);
            if (obj instanceof NSString) {
                NSString ns = (NSString)obj;
                String string = ns.getContent();
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static void checkError(int result2) {
        if (result2 != 0) {
            throw new RuntimeException("setxattr failed with error code: " + result2);
        }
    }

    static {
        logger = LogManager.getLogger();
        try {
            Linker linker = Linker.nativeLinker();
            SymbolLookup libc = linker.defaultLookup();
            setxattr = linker.downcallHandle(libc.find("setxattr").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
            getxattr = linker.downcallHandle(libc.find("getxattr").orElseThrow(), FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), new Linker.Option[0]);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }
}

