/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.spi;

import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.AbstractJdbcLiteralFormatter;

public abstract class BasicJdbcLiteralFormatter<T>
extends AbstractJdbcLiteralFormatter<T> {
    public BasicJdbcLiteralFormatter(JavaType<T> javaType) {
        super(javaType);
    }

    protected <X> X unwrap(Object value, Class<X> unwrapType, WrapperOptions options) {
        assert (value != null);
        if (unwrapType.isInstance(value)) {
            return (X)value;
        }
        JavaType<Object> javaType = this.getJavaType();
        if (!javaType.isInstance(value)) {
            Object coerced = javaType.coerce(value, options::getTypeConfiguration);
            if (unwrapType.isInstance(coerced)) {
                return (X)coerced;
            }
            return javaType.unwrap(coerced, unwrapType, options);
        }
        return javaType.unwrap(value, unwrapType, options);
    }
}

