/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.ElvisInfo;
import org.jetbrains.kotlin.backend.jvm.lower.JvmSafeCallChainFoldingLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.SafeCallInfo;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;

@PhaseDescription(name="JvmSafeCallChainFoldingLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0010*\u00020\u0010H\u0002J\u0016\u0010\u0015\u001a\u00020\u0016*\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020#*\u00020$H\u0002J\f\u0010%\u001a\u00020#*\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "booleanNot", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "irNot", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irAndAnd", "left", "right", "irEqEqNull", "wrapWithBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "irTrue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "startOffset", "", "endOffset", "irFalse", "irValNotNull", "irVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "isJvmNullable", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isJvmPrimitive", "Transformer", "backend.jvm.lower"})
public final class JvmSafeCallChainFoldingLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNot;

    public JvmSafeCallChainFoldingLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.booleanNot = this.context.getIrBuiltIns().getBooleanNotSymbol();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new Transformer());
    }

    private final IrCallImpl irNot(IrExpression $this$irNot) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irNot_u24lambda_u240 = irCallImpl = BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$irNot.getStartOffset(), $this$irNot.getEndOffset(), this.booleanNot);
        boolean bl = false;
        $this$irNot_u24lambda_u240.setDispatchReceiver($this$irNot);
        return irCallImpl;
    }

    private final IrExpression irAndAnd(IrExpression left, IrExpression right) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irAndAnd_u24lambda_u240 = irCallImpl = BuildersKt.fromSymbolOwner(IrCallImpl.Companion, right.getStartOffset(), right.getEndOffset(), this.context.getIrBuiltIns().getAndandSymbol());
        boolean bl = false;
        $this$irAndAnd_u24lambda_u240.getArguments().set(0, left);
        $this$irAndAnd_u24lambda_u240.getArguments().set(1, right);
        return irCallImpl;
    }

    private final IrExpression irEqEqNull(IrExpression $this$irEqEqNull) {
        IrCallImpl irCallImpl;
        IrCallImpl $this$irEqEqNull_u24lambda_u240 = irCallImpl = BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$irEqEqNull.getStartOffset(), $this$irEqEqNull.getEndOffset(), this.context.getIrBuiltIns().getEqeqSymbol());
        boolean bl = false;
        $this$irEqEqNull_u24lambda_u240.getArguments().set(0, $this$irEqEqNull);
        $this$irEqEqNull_u24lambda_u240.getArguments().set(1, IrConstImpl.Companion.constNull($this$irEqEqNull_u24lambda_u240.getStartOffset(), $this$irEqEqNull_u24lambda_u240.getEndOffset(), this.context.getIrBuiltIns().getNothingNType()));
        return irCallImpl;
    }

    private final IrBlock wrapWithBlock(IrExpression $this$wrapWithBlock, IrStatementOrigin origin) {
        return BuildersKt.IrBlockImpl($this$wrapWithBlock.getStartOffset(), $this$wrapWithBlock.getEndOffset(), $this$wrapWithBlock.getType(), origin, CollectionsKt.listOf((Object)$this$wrapWithBlock));
    }

    private final IrConstImpl irTrue(int startOffset, int endOffset) {
        return IrConstImpl.Companion.boolean(startOffset, endOffset, this.context.getIrBuiltIns().getBooleanType(), true);
    }

    private final IrConstImpl irFalse(int startOffset, int endOffset) {
        return IrConstImpl.Companion.boolean(startOffset, endOffset, this.context.getIrBuiltIns().getBooleanType(), false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrExpression irValNotNull(int startOffset, int endOffset, IrVariable irVariable) {
        IrExpression irExpression;
        if (!this.isJvmNullable(irVariable.getType())) {
            IrExpression irExpression2 = irVariable.getInitializer();
            boolean bl = irExpression2 != null ? IrUtilsKt.isConstantLike(irExpression2) : false;
            if (bl) {
                irExpression = this.irTrue(startOffset, endOffset);
                return irExpression;
            }
        }
        irExpression = this.irNot(this.irEqEqNull(BuildersKt.IrGetValueImpl$default(startOffset, endOffset, irVariable.getSymbol(), null, 8, null)));
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJvmNullable(IrType $this$isJvmNullable) {
        if (IrTypeUtilsKt.isNullable($this$isJvmNullable)) return true;
        IrAnnotationContainer irAnnotationContainer = $this$isJvmNullable;
        FqName fqName = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJvmPrimitive(IrType $this$isJvmPrimitive) {
        if (!(IrTypePredicatesKt.isBoolean($this$isJvmPrimitive) || IrTypePredicatesKt.isByte($this$isJvmPrimitive) || IrTypePredicatesKt.isShort($this$isJvmPrimitive) || IrTypePredicatesKt.isInt($this$isJvmPrimitive) || IrTypePredicatesKt.isLong($this$isJvmPrimitive) || IrTypePredicatesKt.isChar($this$isJvmPrimitive) || IrTypePredicatesKt.isFloat($this$isJvmPrimitive))) {
            if (!IrTypePredicatesKt.isDouble($this$isJvmPrimitive)) return false;
        }
        IrAnnotationContainer irAnnotationContainer = $this$isJvmPrimitive;
        FqName fqName = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName)) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/JvmSafeCallChainFoldingLowering;)V", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "foldSafeCall", "safeCallInfo", "Lorg/jetbrains/kotlin/backend/jvm/lower/SafeCallInfo;", "foldElvis", "elvisInfo", "Lorg/jetbrains/kotlin/backend/jvm/lower/ElvisInfo;", "isFoldedSafeCallWithNonNullResult", "", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.jvm.lower"})
    private final class Transformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.transformChildrenVoid(expression2);
            SafeCallInfo safeCallInfo = JvmSafeCallChainFoldingLoweringKt.parseSafeCall(expression2, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns());
            if (safeCallInfo != null) {
                return this.foldSafeCall(safeCallInfo);
            }
            ElvisInfo elvisInfo = JvmSafeCallChainFoldingLoweringKt.parseElvis(expression2, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns());
            if (elvisInfo != null) {
                return this.foldElvis(elvisInfo);
            }
            return expression2;
        }

        private final IrExpression foldSafeCall(SafeCallInfo safeCallInfo) {
            IrBlock safeCallBlock = safeCallInfo.getBlock();
            int startOffset = safeCallBlock.getStartOffset();
            int endOffset = safeCallBlock.getEndOffset();
            IrType safeCallType = safeCallBlock.getType();
            IrVariable safeCallTmpVal = safeCallInfo.getTmpVal();
            IrExpression tmpValInitializer = safeCallTmpVal.getInitializer();
            if (tmpValInitializer instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)tmpValInitializer).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL())) {
                IrBlock foldedBlock = (IrBlock)tmpValInitializer;
                IrStatement irStatement = foldedBlock.getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen foldedWhen = (IrWhen)irStatement;
                IrExpression safeReceiverCondition = foldedWhen.getBranches().get(0).getCondition();
                IrExpression safeReceiverResult = foldedWhen.getBranches().get(0).getResult();
                safeCallTmpVal.setInitializer(safeReceiverResult);
                safeCallTmpVal.setType(safeReceiverResult.getType());
                Object[] objectArray = new IrStatement[]{safeCallTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, safeCallTmpVal)};
                IrCompositeImpl foldedConditionPart = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                foldedBlock.setType(safeCallType);
                foldedWhen.setType(safeCallType);
                foldedWhen.getBranches().get(0).setCondition(JvmSafeCallChainFoldingLowering.this.irAndAnd(safeReceiverCondition, foldedConditionPart));
                foldedWhen.getBranches().get(0).setResult(safeCallInfo.getIfNotNullBranch().getResult());
                return foldedBlock;
            }
            Object[] foldedWhen = new IrStatement[]{safeCallTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, safeCallTmpVal)};
            IrCompositeImpl foldedCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])foldedWhen));
            IrExpression safeCallResult = safeCallInfo.getIfNotNullBranch().getResult();
            IrExpression nullResult = safeCallInfo.getIfNullBranch().getResult();
            Object[] objectArray = new IrBranchImpl[]{BuildersKt.IrBranchImpl(startOffset, endOffset, foldedCondition, safeCallResult), BuildersKt.IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), nullResult)};
            IrWhenImpl foldedWhen2 = BuildersKt.IrWhenImpl(startOffset, endOffset, safeCallType, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL(), CollectionsKt.listOf((Object[])objectArray));
            return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(foldedWhen2, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL());
        }

        private final IrExpression foldElvis(ElvisInfo elvisInfo) {
            IrExpression elvisLhs = elvisInfo.getElvisLhs();
            IrBlock elvisBlock = elvisInfo.getBlock();
            int startOffset = elvisBlock.getStartOffset();
            int endOffset = elvisBlock.getEndOffset();
            IrType elvisType = elvisBlock.getType();
            IrVariable elvisTmpVal = elvisInfo.getTmpVal();
            if (elvisLhs instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)elvisLhs).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL())) {
                boolean bl;
                IrStatement irStatement = ((IrBlock)elvisLhs).getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen safeCallWhen = (IrWhen)irStatement;
                IrExpression safeCallCondition = safeCallWhen.getBranches().get(0).getCondition();
                IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                elvisTmpVal.setInitializer(safeCallResult);
                elvisTmpVal.setType(safeCallResult.getType());
                Object[] objectArray = new IrStatement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
                IrCompositeImpl foldedConditionPart = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                ArrayList<IrBranchImpl> branches = new ArrayList<IrBranchImpl>();
                branches.add(BuildersKt.IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irAndAnd(safeCallCondition, foldedConditionPart), BuildersKt.IrGetValueImpl$default(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null)));
                IrExpression elvisRhs = elvisInfo.getElvisRhs();
                if (this.isFoldedSafeCallWithNonNullResult(elvisRhs)) {
                    Intrinsics.checkNotNull((Object)elvisRhs, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlock");
                    IrStatement irStatement2 = ((IrBlock)elvisRhs).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen rhsInnerWhen = (IrWhen)irStatement2;
                    bl = branches.addAll((Collection)rhsInnerWhen.getBranches());
                } else {
                    bl = branches.add(BuildersKt.IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs()));
                }
                return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(BuildersKt.IrWhenImpl(startOffset, endOffset, elvisType, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS(), (List<? extends IrBranch>)branches), JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS());
            }
            if (elvisLhs instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)elvisLhs).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS())) {
                IrStatement irStatement = ((IrBlock)elvisLhs).getStatements().get(0);
                Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                IrWhen innerElvisWhen = (IrWhen)irStatement;
                IrBranch innerElvisLastBranch = (IrBranch)CollectionsKt.last(innerElvisWhen.getBranches());
                IrExpression innerElvisRhs = innerElvisLastBranch.getResult();
                elvisTmpVal.setInitializer(innerElvisRhs);
                elvisTmpVal.setType(innerElvisRhs.getType());
                Object[] objectArray = new IrElement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
                IrCompositeImpl newCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])objectArray));
                innerElvisLastBranch.setCondition(newCondition);
                innerElvisLastBranch.setResult(BuildersKt.IrGetValueImpl$default(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null));
                innerElvisWhen.getBranches().add(BuildersKt.IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs()));
                innerElvisWhen.setType(elvisType);
                return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(innerElvisWhen, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS());
            }
            Object[] innerElvisLastBranch = new IrElement[]{elvisTmpVal, JvmSafeCallChainFoldingLowering.this.irValNotNull(startOffset, endOffset, elvisTmpVal)};
            IrCompositeImpl newCondition = new IrCompositeImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getBooleanType(), null, CollectionsKt.listOf((Object[])innerElvisLastBranch));
            Object[] objectArray = new IrBranchImpl[]{BuildersKt.IrBranchImpl(startOffset, endOffset, newCondition, BuildersKt.IrGetValueImpl$default(startOffset, endOffset, elvisTmpVal.getSymbol(), null, 8, null)), BuildersKt.IrBranchImpl(startOffset, endOffset, JvmSafeCallChainFoldingLowering.this.irTrue(startOffset, endOffset), elvisInfo.getElvisRhs())};
            IrWhenImpl foldedWhen = BuildersKt.IrWhenImpl(startOffset, endOffset, elvisType, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS(), CollectionsKt.listOf((Object[])objectArray));
            return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(foldedWhen, JvmLoweredStatementOrigin.INSTANCE.getFOLDED_ELVIS());
        }

        private final boolean isFoldedSafeCallWithNonNullResult(IrExpression $this$isFoldedSafeCallWithNonNullResult) {
            if (!($this$isFoldedSafeCallWithNonNullResult instanceof IrBlock)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((IrBlock)$this$isFoldedSafeCallWithNonNullResult).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL())) {
                return false;
            }
            IrStatement irStatement = ((IrBlock)$this$isFoldedSafeCallWithNonNullResult).getStatements().get(0);
            IrWhen irWhen = irStatement instanceof IrWhen ? (IrWhen)irStatement : null;
            if (irWhen == null) {
                return false;
            }
            IrWhen innerWhen = irWhen;
            IrExpression safeCallResult = innerWhen.getBranches().get(0).getResult();
            return !JvmSafeCallChainFoldingLowering.this.isJvmNullable(safeCallResult.getType());
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.transformChildrenVoid(expression2);
            if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)JvmSafeCallChainFoldingLowering.this.getContext().getIrBuiltIns().getEqeqSymbol())) {
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                IrExpression irExpression = (IrExpression)expression2.getArguments().get(0);
                if (irExpression == null) {
                    throw new AssertionError((Object)("No value argument #0: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)));
                }
                IrExpression left = irExpression;
                IrExpression irExpression2 = (IrExpression)expression2.getArguments().get(1);
                if (irExpression2 == null) {
                    throw new AssertionError((Object)("No value argument #1: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)));
                }
                IrExpression right = irExpression2;
                if (left instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)left).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL()) && JvmSafeCallChainFoldingLowering.this.isJvmPrimitive(right.getType())) {
                    IrStatement irStatement = ((IrBlock)left).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen safeCallWhen = (IrWhen)irStatement;
                    IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                    expression2.getArguments().set(0, safeCallResult);
                    safeCallWhen.getBranches().get(0).setResult(expression2);
                    safeCallWhen.getBranches().get(1).setResult(JvmSafeCallChainFoldingLowering.this.irFalse(startOffset, endOffset));
                    safeCallWhen.setType(expression2.getType());
                    return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(safeCallWhen, null);
                }
                if (right instanceof IrBlock && Intrinsics.areEqual((Object)((IrBlock)right).getOrigin(), (Object)JvmLoweredStatementOrigin.INSTANCE.getFOLDED_SAFE_CALL()) && JvmSafeCallChainFoldingLowering.this.isJvmPrimitive(left.getType())) {
                    IrStatement irStatement = ((IrBlock)right).getStatements().get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhen");
                    IrWhen safeCallWhen = (IrWhen)irStatement;
                    IrExpression safeCallResult = safeCallWhen.getBranches().get(0).getResult();
                    expression2.getArguments().set(1, safeCallResult);
                    safeCallWhen.getBranches().get(0).setResult(expression2);
                    safeCallWhen.getBranches().get(1).setResult(JvmSafeCallChainFoldingLowering.this.irFalse(startOffset, endOffset));
                    safeCallWhen.setType(expression2.getType());
                    return JvmSafeCallChainFoldingLowering.this.wrapWithBlock(safeCallWhen, null);
                }
            }
            return expression2;
        }
    }
}

