/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;

public class ProjectDirectoryProjectSpec
extends AbstractProjectSpec {
    private final File dir;

    public ProjectDirectoryProjectSpec(File dir) {
        this.dir = dir;
    }

    @Override
    protected String formatNoMatchesMessage(String settings) {
        return String.format("Project directory '%s' is not part of the build defined by %s.", this.dir, settings);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<ProjectDescriptorInternal> matches) {
        return String.format("Multiple projects in this build have project directory '%s': %s", this.dir, matches);
    }

    @Override
    protected void select(ProjectDescriptorRegistry candidates, List<ProjectDescriptorInternal> matches) {
        for (ProjectDescriptorInternal candidate : candidates.getAllProjects()) {
            if (!candidate.getProjectDir().equals(this.dir)) continue;
            matches.add(candidate);
        }
    }

    @Override
    protected void checkPreconditions(ProjectDescriptorRegistry registry) {
        if (!this.dir.exists()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' does not exist.", this.dir));
        }
        if (!this.dir.isDirectory()) {
            throw new InvalidUserDataException(String.format("Project directory '%s' is not a directory.", this.dir));
        }
    }
}

