---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Mailgun webhook signing key'
---

## Description

The response body contains content that matches the pattern of a Mailgun webhook signing key was identified. This key is used by Mailgun to sign all incoming webhook message payloads. A malicious actor with access to this key can potentially sign fake webhook events and send it to your service to pass validation and be processed..
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate your HTTP webhook signing key:

- Sign in to your Mailgun account and access the dashboard at <https://app.mailgun.com/>
- In the upper-right side, select your account profile and select "API Security"
- In the "HTTP webhook signing key" section, select the rotate arrow icon in the right hand side
- When prompted, select "Reset Key" in the "Reset HTTP webhook signing key" dialog

For more information, please see [Mailgun's documentation on webhooks](https://documentation.mailgun.com/docs/mailgun/user-manual/tracking-messages/#securing-webhooks).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.75 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
