/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import java.math.BigInteger;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;

public class MDEncodedNumber
extends MDParsableItem {
    String number = "";
    BigInteger value;

    public MDEncodedNumber(MDMang dmang) {
        super(dmang);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    @Override
    public void insert(StringBuilder builder) {
        this.dmang.insertSpacedString(builder, this.value.toString());
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() >= '0' && this.dmang.peek() <= '9') {
            this.value = BigInteger.valueOf(this.dmang.getAndIncrement() - 48 + 1);
        } else if (this.dmang.peek() >= 'A' && this.dmang.peek() <= 'P' || this.dmang.peek() == '@') {
            this.value = new BigInteger("0");
            while (this.dmang.peek() >= 'A' && this.dmang.peek() <= 'P') {
                this.value = this.value.shiftLeft(4);
                this.value = this.value.add(BigInteger.valueOf(this.dmang.getAndIncrement() - 65));
            }
            if (this.dmang.peek() == '@') {
                this.dmang.increment();
            }
        } else {
            throw new MDException("Illegal character at index " + this.dmang.getIndex() + " in MDEncodedNumber: " + this.dmang.peek());
        }
    }
}

