/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import generic.Span;
import generic.ULongSpan;
import ghidra.app.plugin.core.debug.stack.UnwindInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerTypedefBuilder;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class FrameStructureBuilder {
    public static final String RETURN_ADDRESS_FIELD_NAME = "return_address";
    public static final String SAVED_REGISTER_FIELD_PREFIX = "saved_";
    private final AddressSpace codeSpace;
    private final Register pc;
    private final Address min;
    private Address max;
    private final long functionOffset;
    private final NavigableMap<Address, FrameField> fields = new TreeMap<Address, FrameField>();

    FrameStructureBuilder(Language language, Address pcVal, UnwindInfo info, int prevParamSize) {
        this.codeSpace = language.getDefaultSpace();
        this.pc = language.getProgramCounter();
        this.max = this.min = info.function().getProgram().getAddressFactory().getStackSpace().getAddress(info.depth() + (long)prevParamSize);
        this.functionOffset = pcVal.subtract(info.function().getEntryPoint());
        this.processSaved(info.saved());
        if (info.ofReturn() != null) {
            this.processOfReturn(info.ofReturn());
        }
        this.processFunction(info.function());
    }

    protected List<FrameField> resolveOverlaps() {
        ArrayList<FrameField> result = new ArrayList<FrameField>(this.fields.size());
        Map.Entry<Address, FrameField> ent1 = this.fields.pollFirstEntry();
        block0: while (ent1 != null) {
            FrameField field1 = ent1.getValue();
            while (true) {
                Map.Entry<Address, FrameField> ent2;
                if ((ent2 = this.fields.pollFirstEntry()) == null) {
                    result.add(field1);
                    return result;
                }
                FrameField field2 = ent2.getValue();
                if (!field1.overlaps(field2)) {
                    result.add(field1);
                    ent1 = ent2;
                    continue block0;
                }
                if (field1.scopeStart() > field2.scopeStart()) continue;
                if (field1.scopeStart() < field2.scopeStart()) {
                    ent1 = ent2;
                    continue block0;
                }
                Msg.warn((Object)this, (Object)"Two overlapping variables with equal first use offsets....");
            }
        }
        return result;
    }

    public Structure build(CategoryPath path, String name, TraceBasedDataTypeManager dtm) {
        DataType type;
        List<FrameField> resolved = this.resolveOverlaps();
        if (resolved.isEmpty()) {
            return null;
        }
        int length = (int)this.max.subtract(this.min);
        if (length == 0) {
            return null;
        }
        StructureDataType structure = new StructureDataType(path, name, length, (DataTypeManager)dtm);
        ULongSpan.DefaultULongSpanSet undefined = new ULongSpan.DefaultULongSpanSet();
        undefined.add((Span)ULongSpan.extent((long)0L, (int)structure.getLength()));
        for (FrameField field : resolved) {
            int offset = (int)field.address().subtract(this.min);
            if (offset < 0) continue;
            type = field.type();
            if (type == IntegerDataType.dataType) {
                type = IntegerDataType.getUnsignedDataType((int)field.length(), (DataTypeManager)dtm);
            } else if (type == PointerDataType.dataType) {
                type = new PointerTypedefBuilder((Pointer)PointerDataType.dataType, (DataTypeManager)dtm).addressSpace(this.codeSpace).build();
            }
            structure.replaceAtOffset(offset, type, field.length(), field.name(), "");
            undefined.remove((Span)ULongSpan.extent((long)offset, (int)field.length()));
        }
        for (ULongSpan undefSpan : undefined.spans()) {
            int spanLength = (int)undefSpan.length();
            type = new ArrayDataType(DataType.DEFAULT, spanLength, 1, (DataTypeManager)dtm);
            int offset = ((Long)undefSpan.min()).intValue();
            Address addr = this.min.add((long)offset);
            String fieldName = addr.getOffset() < 0L ? String.format("offset_0x%x", -addr.getOffset()) : String.format("posOff_0x%x", addr.getOffset());
            structure.replaceAtOffset(offset, type, spanLength, fieldName, "");
        }
        return structure;
    }

    void processVar(Address address, String name, DataType type, int length, int scopeStart) {
        if (!address.isStackAddress()) {
            return;
        }
        Address varMax = address.add((long)length);
        if (varMax.compareTo((Object)this.max) > 0) {
            this.max = varMax;
        }
        this.fields.put(address, new FrameField(address, name, type, length, scopeStart));
    }

    void processRegisterVar(Address address, String name, DataType dataType, Register register, int scopeStart) {
        this.processVar(address, name, dataType, register.getNumBytes(), scopeStart);
    }

    void processSavedRegister(Address address, Register register) {
        this.processRegisterVar(address, SAVED_REGISTER_FIELD_PREFIX + register.getName(), (DataType)IntegerDataType.dataType, register, -1);
    }

    void processSaved(Map<Register, Address> saved) {
        for (Map.Entry<Register, Address> entry : saved.entrySet()) {
            this.processSavedRegister(entry.getValue(), entry.getKey());
        }
    }

    void processOfReturn(Address address) {
        this.processRegisterVar(address, RETURN_ADDRESS_FIELD_NAME, (DataType)PointerDataType.dataType, this.pc, Integer.MAX_VALUE);
    }

    void processFunction(Function function) {
        for (Variable variable : function.getStackFrame().getStackVariables()) {
            if ((long)variable.getFirstUseOffset() > this.functionOffset) continue;
            this.processVariable(variable);
        }
    }

    String prependIfAbsent(String prefix, String name) {
        if (name.startsWith(prefix)) {
            return name;
        }
        return prefix + name;
    }

    void processVariable(Variable variable) {
        Varnode[] varnodes = variable.getVariableStorage().getVarnodes();
        String name = variable.getName();
        if (variable instanceof Parameter) {
            name = this.prependIfAbsent("param_", name);
        } else if (variable instanceof LocalVariable) {
            name = this.prependIfAbsent("local_", name);
        } else {
            throw new AssertionError();
        }
        if (varnodes.length == 1) {
            this.processVarnode(name, variable.getDataType(), varnodes[0], variable.getFirstUseOffset());
        } else {
            for (int i = 0; i < varnodes.length; ++i) {
                this.processVarnode(name + "_pt" + i, (DataType)IntegerDataType.dataType, varnodes[i], variable.getFirstUseOffset());
            }
        }
    }

    void processVarnode(String name, DataType type, Varnode vn, int scopeStart) {
        this.processVar(vn.getAddress(), name, type, vn.getSize(), scopeStart);
    }

    private record FrameField(Address address, String name, DataType type, int length, int scopeStart) {
        AddressRange range() {
            return new AddressRangeImpl(this.address, this.address.add((long)(this.length - 1)));
        }

        boolean overlaps(FrameField that) {
            return this.range().intersects(that.range());
        }
    }
}

